/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.css;

import com.sun.jsfcl.std.css.StyleBuilderPanel;
import com.sun.jsfcl.std.css.StyleEditor;
import com.sun.jsfcl.std.css.model.CssStyleData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StyleEditorListPanel
extends JPanel {
    StyleBuilderPanel styleBuilderPanel = null;
    CssStyleData cssStyleData = null;
    List editorList = new ArrayList();
    private JList styleEditorList;

    public StyleEditorListPanel(StyleBuilderPanel mainPanel, CssStyleData styleData) {
        this.cssStyleData = styleData;
        this.styleBuilderPanel = mainPanel;
        this.initComponents();
        this.styleEditorList.setBackground(this.getBackground());
        this.styleEditorList.setModel(new StyleEditorListModel());
        this.styleEditorList.setCellRenderer(new StyleEditorListRenderer());
    }

    public void addEditor(StyleEditor editor) {
        this.editorList.add(editor);
    }

    public void setSelectedEditor(StyleEditor editor) {
        int index = this.editorList.indexOf(editor);
        if (index >= 0) {
            this.styleEditorList.setSelectedIndex(index);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.setSize(dim.getWidth() + 20.0, dim.getHeight());
        return dim;
    }

    private void initComponents() {
        this.styleEditorList = new JList();
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(80, 200));
        this.setOpaque(false);
        this.styleEditorList.setBorder(new EmptyBorder(new Insets(2, 2, 2, 2)));
        this.styleEditorList.setSelectionMode(0);
        this.styleEditorList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                StyleEditorListPanel.this.styleEditorListValueChanged(evt);
            }
        });
        this.add((Component)this.styleEditorList, "North");
    }

    private void styleEditorListValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        JList list = (JList)evt.getSource();
        StyleEditor styleEditor = (StyleEditor)list.getSelectedValue();
        this.styleBuilderPanel.setEditorPanel(styleEditor);
    }

    class StyleEditorListRenderer
    extends DefaultListCellRenderer {
        StyleEditorListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                Color lineColor = list.getSelectionBackground().darker();
                this.setBorder(new LineBorder(lineColor, 1, true));
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
                this.setBorder(null);
            }
            StyleEditor styleEditor = (StyleEditor)value;
            this.setText(styleEditor.getDisplayName());
            return this;
        }
    }

    class StyleEditorListModel
    extends AbstractListModel {
        StyleEditorListModel() {
        }

        public int getSize() {
            return StyleEditorListPanel.this.editorList.size();
        }

        public Object getElementAt(int i) {
            return StyleEditorListPanel.this.editorList.get(i);
        }
    }
}

