/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.css.model;

import com.sun.jsfcl.std.css.model.BorderModel;
import com.sun.jsfcl.std.css.model.ColorModel;
import com.sun.jsfcl.std.css.model.PropertyData;
import com.sun.jsfcl.std.css.model.PropertyWithUnitData;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;

public class BorderData
extends PropertyData {
    PropertyData styleValue = new PropertyData();
    PropertyData colorValue = new PropertyData();
    PropertyWithUnitData widthValue = new PropertyWithUnitData();
    ColorModel colorModel = new ColorModel();

    public void setBorder(String boderStr) {
        if (boderStr != null) {
            StringTokenizer st;
            if ((boderStr = boderStr.toLowerCase()).indexOf("rgb") >= 0) {
                String borderColor = boderStr.substring(boderStr.indexOf("rgb"));
                String borderColorTrimmed = borderColor.replaceAll(" ", "");
                boderStr = boderStr.substring(0, boderStr.indexOf("rgb")) + " " + borderColorTrimmed;
            }
            if ((st = new StringTokenizer(boderStr)).hasMoreTokens()) {
                this.setWidth(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                this.setStyle(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                this.setColor(st.nextToken());
            }
        }
    }

    public void setWidth(String widthStr) {
        this.widthValue.setUnit(this.getUnit(widthStr));
        this.widthValue.setValue(widthStr.replaceAll(this.widthValue.getUnit(), "").trim());
    }

    private String getUnit(String positionStr) {
        DefaultComboBoxModel unitList = new BorderModel().getWidthUnitList();
        for (int i = 0; i < unitList.getSize(); ++i) {
            String unit = (String)unitList.getElementAt(i);
            if (!positionStr.trim().endsWith(unit)) continue;
            return unit;
        }
        return "";
    }

    public void setStyle(String style) {
        this.styleValue.setValue(style);
    }

    public void setColor(String color) {
        if (color.toLowerCase().trim().startsWith("rgb")) {
            color = color.replaceAll(" ", "");
        }
        this.colorValue.setValue(color);
    }

    public void setWidthValue(String width) {
        this.widthValue.setValue(width);
    }

    public void setWidthUnit(String widthUnit) {
        this.widthValue.setUnit(widthUnit);
    }

    public String getStyle() {
        return this.styleValue.getValue();
    }

    public String getColor() {
        return this.colorValue.getValue();
    }

    public String getWidthValue() {
        return this.widthValue.getValue();
    }

    public String getWidthUnit() {
        return this.widthValue.getUnit();
    }

    public String toString() {
        String borderString = "";
        if (!this.widthValue.toString().equals("")) {
            borderString = borderString + " " + this.widthValue.toString();
        }
        if (!this.styleValue.toString().equals("")) {
            if (borderString.equals("")) {
                borderString = "1px";
            }
            borderString = borderString + " " + this.styleValue.toString();
        } else if (!borderString.equals("")) {
            borderString = borderString + " solid";
        }
        if (!this.colorValue.toString().equals("")) {
            borderString = borderString + " " + this.colorValue.toString();
        }
        return borderString.trim();
    }
}

