/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.css.model;

import java.util.StringTokenizer;

public class TextDecorationData {
    private boolean noDecorationEnabled = false;
    private boolean underlineEnabled = false;
    private boolean overlineEnabled = false;
    private boolean lineThroughEnabled = false;
    private boolean blinkEnabled = false;

    public void setDecoration(String decorationStr) {
        StringTokenizer st = new StringTokenizer(decorationStr);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.trim().equals("underline")) {
                this.enableUnderline(true);
            }
            if (token.trim().equals("overline")) {
                this.enableOverline(true);
            }
            if (token.trim().equals("line-through")) {
                this.enableLineThrough(true);
            }
            if (token.trim().equals("blink")) {
                this.enableBlink(true);
            }
            if (!token.trim().equals("none")) continue;
            this.enableNoDecoration(true);
        }
    }

    public void enableUnderline(boolean underlineEnabled) {
        this.underlineEnabled = underlineEnabled;
    }

    public boolean underlineEnabled() {
        return this.underlineEnabled;
    }

    public void enableOverline(boolean overlineEnabled) {
        this.overlineEnabled = overlineEnabled;
    }

    public boolean overlineEnabled() {
        return this.overlineEnabled;
    }

    public void enableLineThrough(boolean lineThroughEnabled) {
        this.lineThroughEnabled = lineThroughEnabled;
    }

    public boolean lineThroughEnabled() {
        return this.lineThroughEnabled;
    }

    public void enableBlink(boolean blinkEnabled) {
        this.blinkEnabled = blinkEnabled;
    }

    public boolean blinkEnabled() {
        return this.blinkEnabled;
    }

    public void enableNoDecoration(boolean noDecorationEnabled) {
        this.noDecorationEnabled = noDecorationEnabled;
    }

    public boolean noDecorationEnabled() {
        return this.noDecorationEnabled;
    }

    public String toString() {
        String textDecoration = "";
        if (this.noDecorationEnabled) {
            return "none";
        }
        if (this.underlineEnabled) {
            textDecoration = textDecoration + " underline";
        }
        if (this.overlineEnabled) {
            textDecoration = textDecoration + " overline";
        }
        if (this.lineThroughEnabled) {
            textDecoration = textDecoration + " line-through";
        }
        if (this.blinkEnabled) {
            textDecoration = textDecoration + " blink";
        }
        return textDecoration;
    }
}

