/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.property;

import com.sun.jsfcl.std.property.BundleHolder;
import com.sun.jsfcl.std.property.ChooseManyOfManyNodeData;
import com.sun.jsfcl.std.property.ChooseManyOfManyNodeDataTwoColumnTreeCellRenderer;
import com.sun.jsfcl.std.property.ChooseManyOfManyReferenceDataPropertyEditor;
import com.sun.jsfcl.std.property.ChooseManyReferenceDataPanel;
import com.sun.jsfcl.std.reference.ReferenceDataItem;
import com.sun.rave.designtime.DesignProperty;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ChooseManyOfManyReferenceDataPanel
extends ChooseManyReferenceDataPanel
implements TreeSelectionListener {
    protected static final String ADD_LIST_ACTION = "add list";
    protected static final String DELETE_LIST_ACTION = "delete list";
    protected JButton deleteListJButton;
    protected JTree selectedJTree;
    protected DefaultTreeModel selectedJTreeModel;
    protected DefaultMutableTreeNode selectedRootNode;

    public ChooseManyOfManyReferenceDataPanel(ChooseManyOfManyReferenceDataPropertyEditor propertyEditor, DesignProperty liveProperty) {
        super(propertyEditor, liveProperty);
    }

    public void actionPerformed(ActionEvent event) {
        super.actionPerformed(event);
        if (ADD_LIST_ACTION.equals(event.getActionCommand())) {
            this.handleAddListAction(event);
            return;
        }
        if (DELETE_LIST_ACTION.equals(event.getActionCommand())) {
            this.handleDeleteListAction(event);
            return;
        }
    }

    protected ChooseManyOfManyReferenceDataPropertyEditor getChooseManyOfManyReferenceDataPropertyEditor() {
        return (ChooseManyOfManyReferenceDataPropertyEditor)this.getPropertyEditor();
    }

    protected void adjustLeftColumnWidthIfNecessary(DefaultMutableTreeNode node) {
        ChooseManyOfManyNodeDataTwoColumnTreeCellRenderer renderer = (ChooseManyOfManyNodeDataTwoColumnTreeCellRenderer)this.selectedJTree.getCellRenderer();
        renderer.getTreeCellRendererComponent(this.selectedJTree, node, false, false, false, -1, false);
        renderer.adjustLeftColumnWidthIfNecessary();
    }

    protected ChooseManyOfManyNodeData getSelectedData() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        ChooseManyOfManyNodeData data = (ChooseManyOfManyNodeData)node.getUserObject();
        return data;
    }

    protected DefaultMutableTreeNode getSelectedNode() {
        TreePath[] paths = this.selectedJTree.getSelectionModel().getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        TreePath path = paths[0];
        return (DefaultMutableTreeNode)path.getLastPathComponent();
    }

    public List getSelectedListOfListOfItems() {
        List list;
        Enumeration<TreeNode> rootChildrenEnum = this.selectedRootNode.children();
        ArrayList manyOfManyList = new ArrayList();
        while (rootChildrenEnum.hasMoreElements()) {
            ArrayList<Object> manyList = new ArrayList<Object>(16);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)rootChildrenEnum.nextElement();
            Enumeration<TreeNode> nodeChildrenEnum = node.children();
            while (nodeChildrenEnum.hasMoreElements()) {
                DefaultMutableTreeNode nodeChild = (DefaultMutableTreeNode)nodeChildrenEnum.nextElement();
                ChooseManyOfManyNodeData nodeChildData = (ChooseManyOfManyNodeData)nodeChild.getUserObject();
                manyList.add(nodeChildData.getData());
            }
            manyOfManyList.add(manyList);
        }
        for (int i = manyOfManyList.size() - 1; i >= 0 && (list = (List)manyOfManyList.get(i)).size() == 0; --i) {
            manyOfManyList.remove(i);
        }
        return manyOfManyList;
    }

    protected String getListNodeNamePrefix() {
        return BundleHolder.bundle.getMessage("GroupPrefix") + " ";
    }

    public Object getPropertyValue() {
        List selectedListOfListOfItems = this.getSelectedListOfListOfItems();
        if (selectedListOfListOfItems == null || selectedListOfListOfItems.size() == 0) {
            return null;
        }
        String string = this.getChooseManyOfManyReferenceDataPropertyEditor().getStringForManyOfManyItems(selectedListOfListOfItems);
        return string;
    }

    protected List getSelected_ItemsList() {
        ChooseManyOfManyNodeData data = this.getSelectedData();
        if (data == null) {
            return null;
        }
        return (List)data.getData();
    }

    protected String getTopLabel() {
        return this.getCompositeReferenceData().getChooseManyOfManyTitle();
    }

    protected void handleAddListAction(ActionEvent event) {
        ArrayList list = new ArrayList();
        ChooseManyOfManyNodeData data = new ChooseManyOfManyNodeData(null, list);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(data, true);
        this.selectedJTreeModel.insertNodeInto(node, this.selectedRootNode, this.selectedRootNode.getChildCount());
        TreePath path = new TreePath(node.getPath());
        this.selectedJTree.scrollPathToVisible(path);
        this.selectedJTree.setSelectionPath(path);
    }

    protected void handleDeselectAllAction(ActionEvent event) {
        Enumeration<TreeNode> parentEnum = this.selectedRootNode.children();
        while (parentEnum.hasMoreElements()) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)parentEnum.nextElement();
            parent.removeAllChildren();
        }
        this.selectedJTreeModel.reload();
        this.updateTreeRelatedButtons();
    }

    protected void handleChoicesJListSelectionChanged(ListSelectionEvent event) {
        super.handleChoicesJListSelectionChanged(event);
        if (event.getValueIsAdjusting()) {
            return;
        }
        this.updateTreeRelatedButtons();
    }

    protected void handleDeleteListAction(ActionEvent event) {
        TreePath[] paths = this.selectedJTree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        DefaultMutableTreeNode sibling = null;
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            sibling = node.getNextSibling();
            if (sibling == null) {
                sibling = node.getPreviousSibling();
            }
            this.removePath(path);
        }
        if (sibling != null) {
            this.selectedJTree.setSelectionPath(new TreePath(sibling.getPath()));
        }
    }

    protected void handleDeselectAction(ActionEvent event) {
        TreePath[] paths = this.selectedJTree.getSelectionPaths();
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            this.removePath(path);
        }
        this.selectedJTree.setSelectionPaths(null);
    }

    protected void handleDownAction(ActionEvent event) {
        TreePath[] paths = this.selectedJTree.getSelectionPaths();
        this.sortTreePaths(paths);
        for (int i = paths.length - 1; i >= 0; --i) {
            TreePath path = paths[i];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            int index = parent.getIndex(node);
            if (index + 1 == parent.getChildCount()) continue;
            DefaultMutableTreeNode removed = (DefaultMutableTreeNode)parent.getChildAt(index);
            boolean wasExpanded = this.selectedJTree.isExpanded(path);
            this.selectedJTreeModel.removeNodeFromParent(removed);
            this.selectedJTreeModel.insertNodeInto(removed, parent, index + 1);
            if (!wasExpanded || removed.getChildCount() <= 0) continue;
            DefaultMutableTreeNode firstChild = (DefaultMutableTreeNode)removed.getFirstChild();
            this.selectedJTree.makeVisible(new TreePath(firstChild.getPath()));
        }
        this.selectedJTree.setSelectionPaths(paths);
    }

    protected void handleSelectAction(ActionEvent event) {
        TreePath[] selectionPaths = this.selectedJTree.getSelectionPaths();
        for (int j = 0; j < selectionPaths.length; ++j) {
            TreePath selectionPath = selectionPaths[j];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
            int insertIndex = -1;
            if (node.getParent() != this.selectedRootNode) {
                insertIndex = node.getParent().getIndex(node);
                ++insertIndex;
                node = (DefaultMutableTreeNode)node.getParent();
            }
            Object[] items = this.choicesJList.getSelectedValues();
            for (int i = 0; i < items.length; ++i) {
                ReferenceDataItem item = (ReferenceDataItem)items[i];
                Enumeration<TreeNode> children = node.children();
                boolean foundMatch = false;
                if (!this.getChooseManyReferenceDataPropertyEditor().getAllowDuplicates()) {
                    while (children.hasMoreElements()) {
                        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)children.nextElement();
                        ChooseManyOfManyNodeData data = (ChooseManyOfManyNodeData)childNode.getUserObject();
                        ReferenceDataItem otherItem = (ReferenceDataItem)data.getData();
                        if (!item.equals(otherItem)) continue;
                        foundMatch = true;
                        break;
                    }
                }
                if (foundMatch) continue;
                DefaultMutableTreeNode itemNode = new DefaultMutableTreeNode(new ChooseManyOfManyNodeData(item.getDisplayString(), item), false);
                int actualInsertIndex = insertIndex == -1 ? node.getChildCount() : insertIndex++;
                this.selectedJTreeModel.insertNodeInto(itemNode, node, actualInsertIndex);
                this.selectedJTree.makeVisible(new TreePath(itemNode.getPath()));
                this.adjustLeftColumnWidthIfNecessary(itemNode);
            }
        }
        this.updateTreeRelatedButtons();
    }

    protected void handleSelectedJTreeSelectionChanged(TreeSelectionEvent event) {
        this.updateTreeRelatedButtons();
    }

    protected void handleUpAction(ActionEvent event) {
        TreePath[] paths = this.selectedJTree.getSelectionPaths();
        this.sortTreePaths(paths);
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            int index = parent.getIndex(node);
            if (index == 0) continue;
            DefaultMutableTreeNode removed = (DefaultMutableTreeNode)parent.getChildAt(index);
            boolean wasExpanded = this.selectedJTree.isExpanded(path);
            this.selectedJTreeModel.removeNodeFromParent(removed);
            this.selectedJTreeModel.insertNodeInto(removed, parent, index - 1);
            if (!wasExpanded || removed.getChildCount() <= 0) continue;
            DefaultMutableTreeNode firstChild = (DefaultMutableTreeNode)removed.getFirstChild();
            this.selectedJTree.makeVisible(new TreePath(firstChild.getPath()));
        }
        this.selectedJTree.setSelectionPaths(paths);
    }

    protected void initializeComponents() {
        super.initializeComponents();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        JButton addListJButton = new JButton(BundleHolder.bundle.getMessage("NewGroup"));
        addListJButton.setActionCommand(ADD_LIST_ACTION);
        addListJButton.addActionListener(this);
        buttonPanel.add(addListJButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.deleteListJButton = new JButton(BundleHolder.bundle.getMessage("RemoveGroup"));
        this.deleteListJButton.setActionCommand(DELETE_LIST_ACTION);
        this.deleteListJButton.addActionListener(this);
        this.deleteListJButton.setEnabled(false);
        buttonPanel.add(this.deleteListJButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 24;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add((Component)buttonPanel, gridBagConstraints);
        this.updateTreeRelatedButtons();
    }

    protected Component initializeSelectedListComponent() {
        ChooseManyOfManyNodeData data = new ChooseManyOfManyNodeData("root", null);
        this.selectedRootNode = new DefaultMutableTreeNode(data, true);
        this.selectedJTreeModel = new DefaultTreeModel(this.selectedRootNode);
        this.selectedJTree = new JTree();
        ChooseManyOfManyNodeDataTwoColumnTreeCellRenderer renderer = new ChooseManyOfManyNodeDataTwoColumnTreeCellRenderer(this.getListNodeNamePrefix());
        this.selectedJTree.setCellRenderer(renderer);
        this.populateSelectedJTreeModel();
        this.selectedJTree.setModel(this.selectedJTreeModel);
        this.selectedJTree.setRootVisible(false);
        this.selectedJTree.setShowsRootHandles(true);
        this.selectedJTree.putClientProperty("JTree.lineStyle", "Angled");
        this.selectedJTree.getSelectionModel().setSelectionMode(4);
        this.selectedJTree.getSelectionModel().addTreeSelectionListener(this);
        for (int i = 0; i < this.selectedJTree.getRowCount(); ++i) {
            this.selectedJTree.expandRow(i);
        }
        return this.selectedJTree;
    }

    protected void populateSelectedJTreeModel() {
        this.selectedRootNode.removeAllChildren();
        this.selectedJTreeModel.reload();
        ChooseManyOfManyNodeDataTwoColumnTreeCellRenderer renderer = (ChooseManyOfManyNodeDataTwoColumnTreeCellRenderer)this.selectedJTree.getCellRenderer();
        renderer.resetLeftColumnWidth();
        List manyOfManyList = this.getChooseManyOfManyReferenceDataPropertyEditor().getValueListOfManyOfManyReferenceDataItems();
        if (manyOfManyList == null) {
            return;
        }
        if (manyOfManyList.size() == 0) {
            manyOfManyList.add(new ArrayList());
        }
        Iterator manyOfManyIterator = manyOfManyList.iterator();
        int i = 0;
        while (manyOfManyIterator.hasNext()) {
            List manyList = (List)manyOfManyIterator.next();
            DefaultMutableTreeNode listNode = new DefaultMutableTreeNode(new ChooseManyOfManyNodeData(null, manyList), true);
            this.selectedJTreeModel.insertNodeInto(listNode, this.selectedRootNode, this.selectedRootNode.getChildCount());
            Iterator manyIterator = manyList.iterator();
            while (manyIterator.hasNext()) {
                ReferenceDataItem item = (ReferenceDataItem)manyIterator.next();
                DefaultMutableTreeNode itemNode = new DefaultMutableTreeNode(new ChooseManyOfManyNodeData(item.getDisplayString(), item), false);
                this.selectedJTreeModel.insertNodeInto(itemNode, listNode, listNode.getChildCount());
                renderer.getTreeCellRendererComponent(this.selectedJTree, itemNode, false, false, false, -1, false);
                renderer.adjustLeftColumnWidthIfNecessary();
            }
            ++i;
        }
    }

    protected void removePath(TreePath path) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        int index = parent.getIndex(node);
        DefaultMutableTreeNode removed = (DefaultMutableTreeNode)parent.getChildAt(index);
        this.selectedJTreeModel.removeNodeFromParent(removed);
    }

    protected void sortTreePaths(TreePath[] paths) {
        IdentityHashMap<DefaultMutableTreeNode, TreePath> selected = new IdentityHashMap<DefaultMutableTreeNode, TreePath>();
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            selected.put(node, path);
        }
        this.sortTreePaths(paths, selected, this.selectedRootNode, 0);
    }

    protected int sortTreePaths(TreePath[] paths, IdentityHashMap pathsNodes, DefaultMutableTreeNode currentNode, int index) {
        if (pathsNodes.containsKey(currentNode)) {
            paths[index] = (TreePath)pathsNodes.get(currentNode);
            ++index;
        }
        Enumeration<TreeNode> enumer = currentNode.children();
        while (enumer.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)enumer.nextElement();
            index = this.sortTreePaths(paths, pathsNodes, child, index);
        }
        return index;
    }

    protected void updateTreeRelatedButtons() {
        int selectedCount;
        TreePath[] selected = this.selectedJTree.getSelectionPaths();
        int n = selectedCount = selected == null ? 0 : selected.length;
        if (selectedCount == 0 && !this.selectedRootNode.isLeaf()) {
            this.selectedJTree.setSelectionRow(0);
            return;
        }
        int groupCount = 0;
        int itemCount = 0;
        Enumeration<TreeNode> enumer = this.selectedRootNode.breadthFirstEnumeration();
        while (enumer.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumer.nextElement();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            if (parent == null) continue;
            if (parent == this.selectedRootNode) {
                ++groupCount;
                continue;
            }
            ++itemCount;
        }
        int groupsSelectedCount = 0;
        boolean onlyGroupsSelected = true;
        boolean anyChildAtTop = false;
        boolean anyChildAtBottom = false;
        for (int i = 0; i < selectedCount; ++i) {
            TreePath path = selected[i];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node.getParent() == this.selectedRootNode) {
                ++groupsSelectedCount;
            } else {
                onlyGroupsSelected = false;
            }
            int childIndex = node.getParent().getIndex(node);
            if (childIndex == 0) {
                anyChildAtTop = true;
            }
            if (childIndex != node.getParent().getChildCount() - 1) continue;
            anyChildAtBottom = true;
        }
        boolean choicesSelected = this.choicesJList.getSelectedIndices().length > 0;
        this.selectJButton.setEnabled(selectedCount > 0 && choicesSelected);
        this.deselectJButton.setEnabled(groupsSelectedCount == 0 && selectedCount > 0);
        this.deleteListJButton.setEnabled(selectedCount > 0 && onlyGroupsSelected);
        if (this.getCompositeReferenceData().canOrderItems()) {
            this.upJButton.setEnabled(selectedCount > 0 && !anyChildAtTop);
            this.downJButton.setEnabled(selectedCount > 0 && !anyChildAtBottom);
        }
        this.deselectAllJButton.setEnabled(itemCount > 0);
    }

    public void valueChanged(TreeSelectionEvent event) {
        if (event.getSource() == this.selectedJTree.getSelectionModel()) {
            this.handleSelectedJTreeSelectionChanged(event);
        }
    }
}

