/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.property;

import com.sun.jsfcl.std.property.AbstractPropertyJPanel;
import com.sun.jsfcl.std.property.BundleHolder;
import com.sun.jsfcl.std.property.ChooseOneReferenceDataPropertyEditor;
import com.sun.jsfcl.std.property.NewReferenceDataItemDialog;
import com.sun.jsfcl.std.property.ReferenceDataTwoColumnListCellRenderer;
import com.sun.jsfcl.std.reference.CompositeReferenceData;
import com.sun.jsfcl.std.reference.ReferenceDataItem;
import com.sun.rave.designtime.DesignProperty;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;

public class ChooseOneReferenceDataPanel
extends AbstractPropertyJPanel
implements EnhancedCustomPropertyEditor {
    protected static final String ADD_ACTION = "add";
    protected static final String REMOVE_ACTION = "remove";
    protected static final String CLEAR_FILTER_ACTION = "clearFilter";
    protected static final int MIN_ITEMS_FOR_FILTER = 15;
    protected JButton addJButton;
    protected JList choicesJList;
    protected DefaultListModel choicesJListModel;
    protected JScrollPane choicesJListScrollPane;
    protected JButton clearFilterButton;
    protected Pattern filterPattern;
    protected JTextField filterTextControl;
    protected JButton removeJButton;
    protected ReferenceDataItem selectedChoice;

    public ChooseOneReferenceDataPanel(ChooseOneReferenceDataPropertyEditor propertyEditor, DesignProperty liveProperty) {
        super(propertyEditor, liveProperty);
    }

    public void actionPerformed(ActionEvent event) {
        super.actionPerformed(event);
        if (ADD_ACTION.equals(event.getActionCommand())) {
            this.handleAddAction(event);
            return;
        }
        if (REMOVE_ACTION.equals(event.getActionCommand())) {
            this.handleRemoveAction(event);
            return;
        }
        if (CLEAR_FILTER_ACTION.equals(event.getActionCommand())) {
            this.handleClearFilterAction(event);
            return;
        }
    }

    protected List getChoices() {
        return this.getChooseFromReferenceDataPropertyEditor().getItems();
    }

    protected ChooseOneReferenceDataPropertyEditor getChooseFromReferenceDataPropertyEditor() {
        return (ChooseOneReferenceDataPropertyEditor)this.getPropertyEditor();
    }

    protected CompositeReferenceData getCompositeReferenceData() {
        return this.getChooseFromReferenceDataPropertyEditor().getCompositeReferenceData();
    }

    protected int getListSelectionStyle() {
        return 0;
    }

    public Object getPropertyValue() {
        if (this.selectedChoice == null) {
            return null;
        }
        return this.selectedChoice.getValue();
    }

    protected ReferenceDataItem getSelectedChoice() {
        return this.selectedChoice;
    }

    protected String getTopLabel() {
        return this.getCompositeReferenceData().getChooseOneTitle();
    }

    protected int getValueLabelGridWidth() {
        return 2;
    }

    protected void grabCurrentValueFromPropertyEditor() {
        this.selectedChoice = this.getChooseFromReferenceDataPropertyEditor().getValueReferenceDataItem();
    }

    protected void handleAddAction(ActionEvent event) {
        ReferenceDataItem item = new NewReferenceDataItemDialog(this.getCompositeReferenceData()).showDialog(this);
        if (item == null) {
            return;
        }
        this.populateChoicesJListModel();
        this.choicesJList.setSelectedValue(item, true);
    }

    protected void handleChoicesJListSelectionChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        this.selectedChoice = this.choicesJList.getSelectedIndices().length == 0 ? null : (ReferenceDataItem)this.choicesJList.getSelectedValue();
        this.updateButtonsState();
    }

    public void handleClearFilterAction(ActionEvent action) {
        this.filterTextControl.setText("");
    }

    public void handleFilterChanged() {
        String string = this.filterTextControl.getText().trim();
        this.clearFilterButton.setEnabled(string.length() > 0);
        if (string.length() == 0) {
            this.filterPattern = null;
        } else {
            try {
                this.filterPattern = Pattern.compile(".*" + string + ".*", 66);
            }
            catch (PatternSyntaxException e) {
                this.filterPattern = null;
            }
        }
        this.populateChoicesJListModel();
    }

    protected void handleRemoveAction(ActionEvent event) {
        int index = this.choicesJList.getMinSelectionIndex();
        this.getCompositeReferenceData().remove(this.getSelectedChoice());
        this.populateChoicesJListModel();
        if (this.choicesJListModel.size() > 0) {
            if (index >= this.choicesJListModel.size()) {
                index = this.choicesJListModel.size() - 1;
            }
            this.choicesJList.setSelectedIndex(index);
            this.choicesJList.ensureIndexIsVisible(index);
        }
    }

    protected boolean includeInChoicesJList(ReferenceDataItem item) {
        return this.filterPattern == null || item.matchesPattern(this.filterPattern);
    }

    protected void initializeComponents() {
        this.setLayout(new GridBagLayout());
        JLabel label = new JLabel();
        label.setText(this.getTopLabel());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = this.getValueLabelGridWidth();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)label, gridBagConstraints);
        if (this.getChoices().size() > 15) {
            JPanel filterPanel = new JPanel();
            filterPanel.setLayout(new BoxLayout(filterPanel, 2));
            label = new JLabel();
            label.setText(BundleHolder.bundle.getMessage("Filter"));
            filterPanel.add(label);
            filterPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            this.filterTextControl = new JTextField();
            this.filterTextControl.setColumns(10);
            this.filterTextControl.getDocument().addDocumentListener(this);
            filterPanel.add(this.filterTextControl);
            filterPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            this.clearFilterButton = new JButton(BundleHolder.bundle.getMessage("CLEAR_BUTTON_TXT"));
            this.clearFilterButton.setEnabled(false);
            this.clearFilterButton.setActionCommand(CLEAR_FILTER_ACTION);
            this.clearFilterButton.addActionListener(this);
            filterPanel.add(this.clearFilterButton);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(10, 10, 0, 10);
            this.add((Component)filterPanel, gridBagConstraints);
        }
        this.choicesJListModel = new DefaultListModel();
        this.choicesJList = new JList(this.choicesJListModel);
        this.choicesJList.setSelectionMode(this.getListSelectionStyle());
        this.choicesJList.setLayoutOrientation(0);
        this.choicesJList.setVisibleRowCount(-1);
        this.choicesJList.addListSelectionListener(this);
        this.choicesJList.setCellRenderer(new ReferenceDataTwoColumnListCellRenderer());
        this.populateChoicesJListModel();
        this.updateChoicesJListSelection();
        this.choicesJListScrollPane = new JScrollPane(this.choicesJList);
        this.choicesJListScrollPane.setPreferredSize(new Dimension(200, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.choicesJListScrollPane, gridBagConstraints);
        if (this.getCompositeReferenceData().canAddRemoveItems()) {
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
            this.addJButton = new JButton(BundleHolder.bundle.getMessage("New"));
            this.addJButton.setActionCommand(ADD_ACTION);
            this.addJButton.addActionListener(this);
            buttonPanel.add(this.addJButton);
            buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            this.removeJButton = new JButton(BundleHolder.bundle.getMessage(REMOVE_ACTION));
            this.removeJButton.setActionCommand(REMOVE_ACTION);
            this.removeJButton.addActionListener(this);
            buttonPanel.add(this.removeJButton);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.anchor = 23;
            gridBagConstraints.insets = new Insets(5, 10, 0, 0);
            this.add((Component)buttonPanel, gridBagConstraints);
        }
    }

    public void documentEvent(DocumentEvent event) {
        if (event.getDocument() == this.filterTextControl.getDocument()) {
            this.handleFilterChanged();
        }
    }

    public void doLayout() {
        super.doLayout();
        this.choicesJList.ensureIndexIsVisible(this.choicesJList.getSelectedIndex());
        this.updateButtonsState();
    }

    protected void populateChoicesJListModel() {
        this.choicesJListModel.clear();
        ReferenceDataTwoColumnListCellRenderer renderer = (ReferenceDataTwoColumnListCellRenderer)this.choicesJList.getCellRenderer();
        renderer.resetLeftColumnWidth();
        Iterator iterator = this.getChoices().iterator();
        while (iterator.hasNext()) {
            ReferenceDataItem item = (ReferenceDataItem)iterator.next();
            if (!this.includeInChoicesJList(item)) continue;
            this.choicesJListModel.addElement(item);
            renderer.getListCellRendererComponent(this.choicesJList, item, -1, false, false);
            renderer.adjustLeftColumnWidthIfNecessary();
        }
    }

    protected void updateButtonsState() {
        if (this.removeJButton != null) {
            ReferenceDataItem item = this.getSelectedChoice();
            this.removeJButton.setEnabled(item != null && item.isRemovable());
        }
    }

    protected void updateChoicesJListSelection() {
        this.choicesJList.setSelectedValue(this.getSelectedChoice(), true);
    }

    public void valueChanged(ListSelectionEvent event) {
        super.valueChanged(event);
        if (event.getSource() == this.choicesJList) {
            this.handleChoicesJListSelectionChanged(event);
        }
    }
}

