/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.property;

import com.sun.jsfcl.std.property.AbstractPropertyJPanel;
import com.sun.jsfcl.std.property.BundleHolder;
import com.sun.jsfcl.std.property.DateTimePatternPropertyEditor;
import com.sun.rave.designtime.DesignProperty;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;

public class DateTimePatternPanel
extends AbstractPropertyJPanel {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected JTextField nowOutputField;
    protected JTextField patternInputField;
    protected JTextField sampleInputField;
    protected JTextField sampleOutputField;
    String previousPattern;

    public DateTimePatternPanel(DateTimePatternPropertyEditor propertyEditor, DesignProperty liveProperty) {
        super(propertyEditor, liveProperty);
        this.updateNowOutputField();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void documentEvent(DocumentEvent event) {
        if (this.initializing) {
            return;
        }
        if (event.getDocument() == this.patternInputField.getDocument()) {
            this.handlePatternInputDocumentEvent(event);
        }
        if (event.getDocument() == this.sampleInputField.getDocument()) {
            this.handleSampleInputDocumentEvent(event);
        }
    }

    public DateTimePatternPropertyEditor getDateTimePatternPropertyEditor() {
        return (DateTimePatternPropertyEditor)this.getPropertyEditor();
    }

    protected String getPattern() {
        String result = this.patternInputField.getText();
        if (result == null) {
            result = "";
        }
        return result;
    }

    protected String getSample() {
        String result = this.sampleInputField.getText();
        if (result == null) {
            result = "";
        }
        return result;
    }

    public void handlePatternInputDocumentEvent(DocumentEvent event) {
        this.updateNowOutputField();
        String property = this.getDateTimePatternPropertyEditor().getDesignProperty().getPropertyDescriptor().getName();
        this.propertyChangeSupport.firePropertyChange(property, this.previousPattern, this.getPattern());
        this.previousPattern = this.getPattern();
    }

    public void handleSampleInputDocumentEvent(DocumentEvent event) {
        this.updateSampleOutputField();
    }

    public void initializeComponents() {
        this.setLayout(new GridBagLayout());
        JLabel label = new JLabel();
        label.setHorizontalAlignment(2);
        label.setText(BundleHolder.bundle.getMessage("pattern"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.fill = 1;
        this.add((Component)label, gridBagConstraints);
        this.patternInputField = new JTextField();
        this.patternInputField.getDocument().addDocumentListener(this);
        this.patternInputField.setText(this.getPropertyEditor().getAsText());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 280;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.fill = 1;
        this.add((Component)this.patternInputField, gridBagConstraints);
        this.nowOutputField = new JTextField();
        this.nowOutputField.setText("");
        this.nowOutputField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.fill = 1;
        this.add((Component)this.nowOutputField, gridBagConstraints);
        label = new JLabel();
        label.setHorizontalAlignment(4);
        label.setText(BundleHolder.bundle.getMessage("test"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.fill = 1;
        this.add((Component)label, gridBagConstraints);
        this.sampleInputField = new JTextField();
        this.sampleInputField.getDocument().addDocumentListener(this);
        this.sampleInputField.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.fill = 1;
        this.add((Component)this.sampleInputField, gridBagConstraints);
        this.sampleOutputField = new JTextField();
        this.sampleOutputField.setText("");
        this.sampleOutputField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.fill = 1;
        this.add((Component)this.sampleOutputField, gridBagConstraints);
    }

    protected void updateNowOutputField() {
        String output;
        try {
            Date date = new Date();
            String pattern = this.getPattern();
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            output = format.format(date);
        }
        catch (Throwable t) {
            output = "** ERROR: " + t.getMessage();
        }
        this.nowOutputField.setText(output);
    }

    protected void updateSampleOutputField() {
        String output;
        try {
            String pattern = this.getPattern();
            SimpleDateFormat inputFormat = new SimpleDateFormat(pattern);
            String sample = this.getSample();
            Date date = inputFormat.parse(sample);
            DateFormat outputFormat = DateFormat.getDateTimeInstance(0, 0);
            output = outputFormat.format(date);
        }
        catch (Throwable t) {
            output = "** ERROR: " + t.getMessage();
        }
        this.sampleOutputField.setText(output);
    }
}

