/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.property;

import com.sun.jsfcl.std.property.AbstractPropertyEditor;
import com.sun.jsfcl.std.property.LocalizedMessageRuntimeException;
import com.sun.jsfcl.util.ComponentBundle;
import com.sun.rave.designtime.DesignProperty;
import org.openide.ErrorManager;

public abstract class NumberPropertyEditor
extends AbstractPropertyEditor {
    protected boolean isValueString;
    protected static final ComponentBundle bundle = ComponentBundle.getBundle(NumberPropertyEditor.class);
    public static final String MIN_VALUE_KEY = "minValue";
    public static final String MAX_VALUE_KEY = "maxValue";
    public static final String UNSET_VALUE_KEY = "unsetValue";
    public static final String MIN_VALUE_PROP_KEY = "minValueProperty";
    public static final String MAX_VALUE_PROP_KEY = "maxValueProperty";
    public static final String UNSET_VALUE_PROP_KEY = "unsetValueProperty";
    Comparable minValue = null;
    Comparable maxValue = null;
    Comparable unsetValue = null;
    String minValueProperty = null;
    String maxValueProperty = null;
    String unsetValueProperty = null;

    public void attachToNewDesignProperty() {
        Object temp;
        super.attachToNewDesignProperty();
        this.isValueString = this.getDesignProperty().getPropertyDescriptor().getPropertyType() == String.class;
        ErrorManager em = ErrorManager.getDefault();
        String errMsg = "jsfcl.NumberPropertyEditor: The Property Descriptor for " + this.getDesignProperty().getPropertyDescriptor().getName() + " has incorrect value for ";
        try {
            temp = this.getDesignProperty().getPropertyDescriptor().getValue(MIN_VALUE_KEY);
            if (temp != null) {
                this.minValue = (Comparable)temp;
            }
        }
        catch (ClassCastException exc) {
            em.log(65536, errMsg + MIN_VALUE_KEY);
        }
        try {
            temp = this.getDesignProperty().getPropertyDescriptor().getValue(MAX_VALUE_KEY);
            if (temp != null) {
                this.maxValue = (Comparable)temp;
            }
        }
        catch (ClassCastException exc) {
            em.log(65536, errMsg + MAX_VALUE_KEY);
        }
        try {
            temp = this.getDesignProperty().getPropertyDescriptor().getValue(UNSET_VALUE_KEY);
            if (temp != null) {
                this.unsetValue = (Comparable)temp;
            }
        }
        catch (ClassCastException exc) {
            em.log(65536, errMsg + UNSET_VALUE_KEY);
        }
        try {
            temp = this.getDesignProperty().getPropertyDescriptor().getValue(MIN_VALUE_PROP_KEY);
            if (temp != null) {
                this.minValueProperty = (String)temp;
            }
        }
        catch (ClassCastException exc) {
            em.log(65536, errMsg + MIN_VALUE_PROP_KEY);
        }
        try {
            temp = this.getDesignProperty().getPropertyDescriptor().getValue(MAX_VALUE_PROP_KEY);
            if (temp != null) {
                this.maxValueProperty = (String)temp;
            }
        }
        catch (ClassCastException exc) {
            em.log(65536, errMsg + MAX_VALUE_PROP_KEY);
        }
        try {
            temp = this.getDesignProperty().getPropertyDescriptor().getValue(UNSET_VALUE_PROP_KEY);
            if (temp != null) {
                this.unsetValueProperty = (String)temp;
            }
        }
        catch (ClassCastException exc) {
            em.log(65536, errMsg + UNSET_VALUE_PROP_KEY);
        }
    }

    public Object getUnsetValue() {
        try {
            DesignProperty temp;
            if (this.unsetValueProperty != null && (temp = this.liveProperty.getDesignBean().getProperty(this.unsetValueProperty)) != null) {
                return (Comparable)temp.getValue();
            }
        }
        catch (ClassCastException exc) {
            ErrorManager em = ErrorManager.getDefault();
            em.log(65536, "jsfcl.NumberPropertyEditor:  value of " + this.getDesignProperty().getPropertyDescriptor().getName() + " is not of Comparable type");
        }
        return this.unsetValue;
    }

    public String getAsText() {
        Object value = this.getValue();
        if (value == null || value.equals(this.getUnsetValue())) {
            return "";
        }
        return value.toString();
    }

    public String getJavaInitializationString() {
        Object value = this.getValue();
        String result = value != null ? value.toString() : "0";
        String suffix = this.getJavaInitializationStringSuffix();
        if (suffix != null) {
            result = result + suffix;
        }
        return result;
    }

    public String getJavaInitializationStringSuffix() {
        return null;
    }

    public abstract Object parseString(String var1) throws NumberFormatException;

    public void setAsText(String string) throws IllegalArgumentException {
        string = string.trim();
        Object value = this.getUnsetValue();
        boolean unset = true;
        if (string.length() > 0) {
            try {
                value = this.parseString(string);
            }
            catch (NumberFormatException nfe) {
                String errMsg = bundle.getMessage("valueInvalid", this.getDesignProperty().getPropertyDescriptor().getName());
                throw new LocalizedMessageRuntimeException(errMsg, nfe);
            }
            this.checkRange(value);
            unset = false;
        }
        if (this.isValueString) {
            if (value == null) {
                this.setValue(null);
            } else {
                this.setValue(String.valueOf(value));
            }
        } else {
            this.setValue(value);
        }
        if (unset) {
            this.unsetProperty();
        }
    }

    public void checkRange(Object value) throws IllegalArgumentException {
        Comparable min = this.minValue;
        Comparable max = this.maxValue;
        String errMsg = null;
        ErrorManager em = ErrorManager.getDefault();
        try {
            Comparable minUnset;
            DesignProperty minProp;
            if (this.minValueProperty != null && (minProp = this.liveProperty.getDesignBean().getProperty(this.minValueProperty)) != null && (min = (Comparable)minProp.getValue()).compareTo(minUnset = (Comparable)minProp.getPropertyDescriptor().getValue(UNSET_VALUE_KEY)) == 0) {
                min = this.minValue;
            }
        }
        catch (ClassCastException exc) {
            em.log(65536, "jsfcl.NumberPropertyEditor:  value of " + this.getDesignProperty().getPropertyDescriptor().getName() + " is not of Comparable type");
        }
        try {
            Comparable maxUnset;
            DesignProperty maxProp;
            if (this.maxValueProperty != null && (maxProp = this.liveProperty.getDesignBean().getProperty(this.maxValueProperty)) != null && (max = (Comparable)maxProp.getValue()).compareTo(maxUnset = (Comparable)maxProp.getPropertyDescriptor().getValue(UNSET_VALUE_KEY)) == 0) {
                max = this.maxValue;
            }
        }
        catch (ClassCastException exc) {
            em.log(65536, "jsfcl.NumberPropertyEditor:  value of " + this.getDesignProperty().getPropertyDescriptor().getName() + " is not of Comparable type");
        }
        int result = min.compareTo(value);
        if (result > 0) {
            errMsg = bundle.getMessage("valueHigher", this.getDesignProperty().getPropertyDescriptor().getName(), min);
            throw new IllegalArgumentException(errMsg);
        }
        result = max.compareTo(value);
        if (result < 0) {
            errMsg = bundle.getMessage("valueLower", this.getDesignProperty().getPropertyDescriptor().getName(), max);
            throw new IllegalArgumentException(errMsg);
        }
    }
}

