/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.property;

import com.sun.jsfcl.std.property.AbstractPropertyEditor;
import com.sun.jsfcl.std.property.SingleChoiceListPanel;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;

public abstract class SingleChoiceListPropertyEditor
extends AbstractPropertyEditor {
    protected static final Object CHOICE_NOT_FOUND_MARKER = new Object();
    protected static final int MAX_CHOICE_COUNT_FOR_TAGS = 8;
    protected List choices;
    protected Object valueChoice;

    public void attachToNewDesignProperty() {
        super.attachToNewDesignProperty();
        this.initializeValueChoice();
    }

    public String getAsText() {
        return this.getStringForChoice(this.getValueChoice());
    }

    protected Object getChoiceForString(String lookFor) {
        Object result;
        if (lookFor != null) {
            lookFor.trim();
        }
        if ((result = this.getChoiceForStringImp(lookFor)) == CHOICE_NOT_FOUND_MARKER) {
            result = this.getChoiceForStringNotFound(lookFor);
        }
        return result;
    }

    protected Object getChoiceForStringImp(String lookFor) {
        if (lookFor == null) {
            lookFor = "";
        }
        Iterator iterator = this.getChoices().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            String string = this.getStringForChoice(object);
            if (!lookFor.equalsIgnoreCase(string)) continue;
            return object;
        }
        return CHOICE_NOT_FOUND_MARKER;
    }

    protected Object getChoiceForStringNotFound(String lookFor) {
        return lookFor;
    }

    public List getChoices() {
        if (this.choices == null) {
            this.choices = this.getChoicesImp();
        }
        return this.choices;
    }

    protected abstract List getChoicesImp();

    public Component getCustomEditor() {
        return new SingleChoiceListPanel(this, this.getDesignProperty());
    }

    public String getJavaInitializationString() {
        return SingleChoiceListPropertyEditor.stringToJavaSourceString(this.getAsText());
    }

    protected String getStringForChoice(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public String[] getTags() {
        List choices = this.getChoices();
        if (choices.size() > 8) {
            return null;
        }
        String[] result = new String[choices.size()];
        int i = 0;
        Iterator iterator = choices.iterator();
        while (iterator.hasNext()) {
            result[i] = this.getStringForChoice(iterator.next());
            ++i;
        }
        return result;
    }

    public Object getValueChoice() {
        return this.valueChoice;
    }

    protected Object getValueForChoice(Object object) {
        return this.getStringForChoice(object);
    }

    protected void initializeValueChoice() {
        this.valueChoice = this.getChoiceForString((String)this.getValue());
    }

    public boolean isPaintable() {
        if (this.wantsAbilityToRefreshChoices()) {
            this.refreshChoices();
        }
        return super.isPaintable();
    }

    protected boolean isUnsetMarker(Object object) {
        return object == null || "".equals(object);
    }

    public void refreshChoices() {
        this.choices = null;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        Object object = this.getChoiceForString(text);
        this.setValueChoice(object);
    }

    public void setValueChoice(Object object) {
        this.valueChoice = object;
        this.setValue(this.getValueForChoice(object));
        if (this.isUnsetMarker(object)) {
            this.unsetProperty();
        }
    }

    public boolean supportsCustomEditor() {
        return this.getChoices().size() > 8;
    }

    protected boolean wantsAbilityToRefreshChoices() {
        return false;
    }
}

