/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.reference;

import com.sun.jsfcl.std.reference.ReferenceDataDefiner;
import com.sun.jsfcl.std.reference.ReferenceDataItem;
import com.sun.jsfcl.std.reference.ReferenceDataManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

public class MediaTypesReferenceDataDefiner
extends ReferenceDataDefiner {
    protected static final String FILENAME = "media-types.txt";
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBaseItems(List list) {
        list.add(this.newItem("", null, true, false));
        InputStream in = null;
        try {
            String line;
            in = this.getClass().getResourceAsStream(FILENAME);
            if (in == null) {
                if (!$assertionsDisabled && !ReferenceDataManager.loggerUtil.warning("Could not find mime-types file: media-types.txt")) {
                    throw new AssertionError();
                }
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String contentType = null;
            while ((line = reader.readLine()) != null) {
                String contentSubType;
                int index;
                if (line.length() == 0 || line.startsWith("#")) continue;
                if (line.startsWith("---")) {
                    break;
                }
                boolean isSubTypeLine = Character.isWhitespace(line.charAt(0));
                line = line.trim();
                if (!isSubTypeLine) {
                    index = line.indexOf(" ");
                    if (index == -1) {
                        contentType = line;
                    } else {
                        contentType = line.substring(0, index);
                        line = line.substring(index).trim();
                    }
                }
                if ((contentSubType = (index = line.indexOf("[")) == -1 ? line : line.substring(0, index).trim()).length() == 0) {
                    contentSubType = null;
                }
                String combinedName = contentType;
                if (contentType == null) {
                    throw new RuntimeException("Found an entry in media-types.txt with no content type defined");
                }
                if (contentSubType != null) {
                    combinedName = combinedName + "/" + contentSubType;
                }
                ReferenceDataItem item = this.newItem(combinedName, combinedName, false, false);
                list.add(item);
            }
        }
        catch (IOException e) {
            if (!$assertionsDisabled && !ReferenceDataManager.loggerUtil.config("Problems parsing reference data ref file for: media-types.txt")) {
                throw new AssertionError();
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public boolean canAddRemoveItems() {
        return true;
    }

    public boolean isValueAString() {
        return true;
    }

    static {
        $assertionsDisabled = !MediaTypesReferenceDataDefiner.class.desiredAssertionStatus();
    }
}

