/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.reference;

import com.sun.jsfcl.std.reference.BundleHolder;
import com.sun.jsfcl.std.reference.ReferenceDataDefiner;
import com.sun.jsfcl.std.reference.ReferenceDataManager;
import java.util.ArrayList;
import java.util.List;

public abstract class ReferenceData {
    protected ReferenceDataDefiner definer;
    protected List items;
    protected ReferenceDataManager manager;
    protected String name;

    public ReferenceData(ReferenceDataManager manager, ReferenceDataDefiner definer, String name) {
        this.name = name;
        this.manager = manager;
        this.definer = definer;
    }

    public boolean canAddRemoveItems() {
        return this.getDefiner().canAddRemoveItems();
    }

    public boolean canOrderItems() {
        return this.getDefiner().canOrderItems();
    }

    protected abstract void defineItems();

    public ReferenceDataDefiner getDefiner() {
        return this.definer;
    }

    public String getDisplayName() {
        return BundleHolder.bundle.getMessage(this.getName());
    }

    public List getItems() {
        if (this.items == null) {
            this.items = new ArrayList(16);
            this.defineItems();
        }
        return this.items;
    }

    public String getChooseOneTitle() {
        return BundleHolder.bundle.getMessage("chooseA", this.getName());
    }

    public String getChooseManyTitle() {
        return BundleHolder.bundle.getMessage("ChooseMany_" + this.getName());
    }

    public String getChooseManyOfManyTitle() {
        return BundleHolder.bundle.getMessage("ChooseManyOfMany_" + this.getName());
    }

    public String getName() {
        return this.name;
    }

    public void invalidateItemsCache() {
        this.items = null;
    }

    public boolean isValueAString() {
        return this.getDefiner().isValueAString();
    }
}

