/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.reference;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReferenceDataItem
implements Comparable {
    protected ReferenceDataItem aliasFor;
    protected boolean isUnsetMarker;
    protected boolean isRemovable;
    protected String name;
    protected Object value;
    protected String javaInitializationString;

    public static ArrayList sorted(List items) {
        ArrayList result = new ArrayList(items.size());
        result.addAll(items);
        Collections.sort(result);
        return result;
    }

    protected ReferenceDataItem(String name, Object value, String javaInitializationString, boolean isUnsetMarker, boolean isRemovable, ReferenceDataItem aliasFor) {
        this.name = name;
        this.value = value;
        this.javaInitializationString = javaInitializationString;
        this.isUnsetMarker = isUnsetMarker;
        this.isRemovable = isRemovable;
        this.aliasFor = aliasFor;
    }

    public int compareTo(Object object) {
        ReferenceDataItem otherItem = (ReferenceDataItem)object;
        return this.getName().compareToIgnoreCase(otherItem.getName());
    }

    public boolean equals(Object object) {
        if (object instanceof ReferenceDataItem) {
            return this.equals((ReferenceDataItem)object);
        }
        return false;
    }

    public boolean equals(ReferenceDataItem other) {
        return this.value != null && other.value != null && this.value.equals(other.value);
    }

    public ReferenceDataItem getAliasFor() {
        return this.aliasFor;
    }

    public String getDisplayString() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        return this.name;
    }

    public String getJavaInitializationString() {
        return this.javaInitializationString;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        return this.value.hashCode();
    }

    public boolean isRemovable() {
        return this.isRemovable;
    }

    public boolean isUnsetMarker() {
        return this.isUnsetMarker;
    }

    public boolean matchesPattern(Pattern pattern) {
        Matcher matcher = pattern.matcher(this.getName());
        if (matcher.matches()) {
            return true;
        }
        return this.getValue() instanceof String && (matcher = pattern.matcher((String)this.getValue())).matches();
    }

    public void setIsRemovable(boolean isRemovable) {
        this.isRemovable = isRemovable;
    }

    public void setIsUnsetMarker(boolean isUnsetValue) {
        this.isUnsetMarker = isUnsetValue;
    }

    public void setJavaInitializationString(String string) {
        this.javaInitializationString = string;
    }
}

