/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.reference;

import com.sun.jsfcl.std.reference.BaseReferenceData;
import com.sun.jsfcl.std.reference.CharacterSetsReferenceDataDefiner;
import com.sun.jsfcl.std.reference.CommandButtonTypesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.ComponentIdsReferenceDataDefiner;
import com.sun.jsfcl.std.reference.CompositeReferenceData;
import com.sun.jsfcl.std.reference.ConcurrencyTypesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.DataSourceNamesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.DateTimeStylesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.DateTimeTypesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.DesignPropertyAttachedReferenceData;
import com.sun.jsfcl.std.reference.FrameTargetsReferenceDataDefiner;
import com.sun.jsfcl.std.reference.ImageMapNamesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.LanguageCodesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.LinkTypesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.LocalesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.ManyCheckboxLayoutStylesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.MediaTypesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.MessagesLayoutsReferenceDataDefiner;
import com.sun.jsfcl.std.reference.ProjectAttachedReferenceData;
import com.sun.jsfcl.std.reference.ReferenceDataDefiner;
import com.sun.jsfcl.std.reference.RegionShapesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.StyleClassesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.TFramesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.TableRulesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.TextDirectionsReferenceDataDefiner;
import com.sun.jsfcl.std.reference.TimeZonesReferenceDataDefiner;
import com.sun.jsfcl.util.LoggerUtil;
import com.sun.rave.designtime.DesignProject;
import com.sun.rave.designtime.DesignProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class ReferenceDataManager {
    public static final String CHARACTER_SETS = "character-sets";
    public static final String COMMAND_BUTTON_TYPES = "command-button-types";
    public static final String COMPONENT_IDS = "component-ids";
    public static final String CONCURRENCY_TYPES = "concurrency-types";
    public static final String DATASOURCE_NAMES = "datasource-names";
    public static final String DATETIME_STYLES = "datetime-style";
    public static final String DATETIME_TYPES = "datetime-type";
    public static final String FRAME_TARGETS = "frame-targets";
    public static final String IMAGE_MAP_NAMES = "image-map-names";
    public static final String LANGUAGE_CODES = "language-code";
    public static final String LINK_TYPES = "link-types";
    public static final String LOCALES = "locales";
    public static final String MANY_CHECKBOX_LAYOUT_STYLES = "many-chekbox-layout-styles";
    public static final String MEDIA_TYPES = "media-types";
    public static final String MESSAGES_LAYOUTS = "messages-layouts";
    public static final String REGION_SHAPES = "region-shape";
    public static final String STYLE_CLASSES = "style-classes";
    public static final String TABLE_RULES = "table-rules";
    public static final String TEXT_DIRECTIONS = "text-direction";
    public static final String TFRAMES = "tframes";
    public static final String TIME_ZONES = "time-zones";
    protected static ReferenceDataManager instance;
    public static LoggerUtil loggerUtil;
    protected static WeakHashMap projectRelatedReferenceDataMap;
    protected Map definersByName;
    protected Map referenceDataByName = new HashMap();
    protected Map referenceDataByProperty = new WeakHashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public static ReferenceDataManager getInstance() {
        return instance;
    }

    protected static void setInstance(ReferenceDataManager instance) {
        ReferenceDataManager.instance = instance;
    }

    protected ReferenceDataManager() {
    }

    public BaseReferenceData getBaseReferenceData(String name) {
        BaseReferenceData result = (BaseReferenceData)this.referenceDataByName.get(name);
        if (result == null) {
            ReferenceDataDefiner definer = this.getDefiner(name);
            if (definer == null) {
                throw new RuntimeException("No definer defined for: " + name);
            }
            if (!definer.definesBaseItems()) {
                return null;
            }
            result = new BaseReferenceData(this, definer, name);
            this.referenceDataByName.put(name, result);
        }
        return result;
    }

    public ReferenceDataDefiner getDefiner(String name) {
        ReferenceDataDefiner result = (ReferenceDataDefiner)this.getDefinersByName().get(name);
        if (result == null && !$assertionsDisabled && !loggerUtil.warning("Found no ReferenceDataDefiner registered under: " + name)) {
            throw new AssertionError();
        }
        return result;
    }

    protected Map getDefinersByName() {
        if (this.definersByName == null) {
            this.initializeDefinersByName();
        }
        return this.definersByName;
    }

    public DesignPropertyAttachedReferenceData getDesignPropertyAttachedReferenceData(String name, DesignProperty property) {
        DesignPropertyAttachedReferenceData result;
        HashMap<String, DesignPropertyAttachedReferenceData> byName = (HashMap<String, DesignPropertyAttachedReferenceData>)this.referenceDataByProperty.get(property);
        if (byName == null) {
            byName = new HashMap<String, DesignPropertyAttachedReferenceData>();
            this.referenceDataByProperty.put(property, byName);
        }
        if ((result = (DesignPropertyAttachedReferenceData)byName.get(name)) == null) {
            ReferenceDataDefiner definer = this.getDefiner(name);
            if (definer == null) {
                throw new RuntimeException("No definer defined for: " + name);
            }
            if (!definer.definesDesignPropertyItems()) {
                return null;
            }
            result = new DesignPropertyAttachedReferenceData(this, definer, name, property);
            byName.put(name, result);
        }
        return result;
    }

    public CompositeReferenceData getCompositeReferenceData(String name, DesignProject project, DesignProperty liveProperty) {
        return new CompositeReferenceData(this, name, this.getDefiner(name), this.getBaseReferenceData(name), this.getProjectAttachedReferenceData(name, project), this.getDesignPropertyAttachedReferenceData(name, liveProperty));
    }

    public ProjectAttachedReferenceData getProjectAttachedReferenceData(String name, DesignProject project) {
        ProjectAttachedReferenceData referenceData;
        HashMap<String, ProjectAttachedReferenceData> byNameMap = (HashMap<String, ProjectAttachedReferenceData>)projectRelatedReferenceDataMap.get(project);
        if (byNameMap == null) {
            byNameMap = new HashMap<String, ProjectAttachedReferenceData>();
            projectRelatedReferenceDataMap.put(project, byNameMap);
        }
        if ((referenceData = (ProjectAttachedReferenceData)byNameMap.get(name)) != null) {
            return referenceData;
        }
        ReferenceDataDefiner definer = this.getDefiner(name);
        if (definer == null) {
            throw new RuntimeException("No definer defined for: " + name);
        }
        if (!definer.definesProjectItems()) {
            return null;
        }
        referenceData = new ProjectAttachedReferenceData(this, definer, name, project);
        byNameMap.put(name, referenceData);
        return referenceData;
    }

    protected void initializeDefinersByName() {
        this.definersByName = new HashMap();
        this.definersByName.put(CHARACTER_SETS, new CharacterSetsReferenceDataDefiner());
        this.definersByName.put(COMMAND_BUTTON_TYPES, new CommandButtonTypesReferenceDataDefiner());
        this.definersByName.put(COMPONENT_IDS, new ComponentIdsReferenceDataDefiner());
        this.definersByName.put(CONCURRENCY_TYPES, new ConcurrencyTypesReferenceDataDefiner());
        this.definersByName.put(DATASOURCE_NAMES, new DataSourceNamesReferenceDataDefiner());
        this.definersByName.put(DATETIME_STYLES, new DateTimeStylesReferenceDataDefiner());
        this.definersByName.put(DATETIME_TYPES, new DateTimeTypesReferenceDataDefiner());
        this.definersByName.put(FRAME_TARGETS, new FrameTargetsReferenceDataDefiner());
        this.definersByName.put(IMAGE_MAP_NAMES, new ImageMapNamesReferenceDataDefiner());
        this.definersByName.put(LANGUAGE_CODES, new LanguageCodesReferenceDataDefiner());
        this.definersByName.put(LINK_TYPES, new LinkTypesReferenceDataDefiner());
        this.definersByName.put(LOCALES, new LocalesReferenceDataDefiner());
        this.definersByName.put(MANY_CHECKBOX_LAYOUT_STYLES, new ManyCheckboxLayoutStylesReferenceDataDefiner());
        this.definersByName.put(MEDIA_TYPES, new MediaTypesReferenceDataDefiner());
        this.definersByName.put(MESSAGES_LAYOUTS, new MessagesLayoutsReferenceDataDefiner());
        this.definersByName.put(REGION_SHAPES, new RegionShapesReferenceDataDefiner());
        this.definersByName.put(STYLE_CLASSES, new StyleClassesReferenceDataDefiner());
        this.definersByName.put(TABLE_RULES, new TableRulesReferenceDataDefiner());
        this.definersByName.put(TEXT_DIRECTIONS, new TextDirectionsReferenceDataDefiner());
        this.definersByName.put(TFRAMES, new TFramesReferenceDataDefiner());
        this.definersByName.put(TIME_ZONES, new TimeZonesReferenceDataDefiner());
    }

    static {
        $assertionsDisabled = !ReferenceDataManager.class.desiredAssertionStatus();
        projectRelatedReferenceDataMap = new WeakHashMap();
        instance = new ReferenceDataManager();
        loggerUtil = LoggerUtil.getLogger(ReferenceDataManager.class.getName());
    }
}

