/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors;

import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.propertyeditors.IllegalTextArgumentException;
import com.sun.rave.propertyeditors.PropertyEditorBase;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.openide.util.NbBundle;

public class DatePropertyEditor
extends PropertyEditorBase {
    public static final String DATE_FORMAT_PATTERN = "dateFormatPattern";

    private DateFormat getDateFormat() {
        DesignProperty patternProp = this.getDesignProperty().getDesignBean().getProperty(DATE_FORMAT_PATTERN);
        Object patternPropValue = patternProp.getValue();
        if (patternPropValue instanceof String) {
            SimpleDateFormat df = new SimpleDateFormat((String)patternPropValue);
            return df;
        }
        return DateFormat.getDateInstance(3);
    }

    public String getAsText() {
        Date d = (Date)this.getValue();
        if (d != null) {
            return this.getDateFormat().format(d);
        }
        return "";
    }

    public void setAsText(String text) {
        if (text.trim().length() == 0) {
            this.setValue(null);
            return;
        }
        try {
            this.setValue(this.getDateFormat().parse(text));
        }
        catch (ParseException e) {
            String pattern = NbBundle.getMessage((Class)DatePropertyEditor.class, (String)"DatePropertyEditor.formatErrorMessage", (Object[])new String[]{text});
            throw new IllegalTextArgumentException(MessageFormat.format(pattern, text), e);
        }
    }

    public String getJavaInitializationString() {
        Date date = (Date)this.getValue();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return "(new java.util.GregorianCalendar(" + cal.get(1) + ", " + cal.get(2) + ", " + cal.get(5) + ")).getTime()";
    }
}

