/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors;

import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.propertyeditors.PropertyEditorBase;
import com.sun.rave.propertyeditors.domains.AttachedDomain;
import com.sun.rave.propertyeditors.domains.Domain;
import com.sun.rave.propertyeditors.domains.Element;
import java.beans.PropertyDescriptor;

public abstract class DomainPropertyEditor
extends PropertyEditorBase {
    public static final String DOMAIN_CLASS = "com.sun.rave.propertyeditors.DOMAIN_CLASS";
    static final Element EMPTY_ELEMENT = new Element(null, "");
    protected Element defaultElement = EMPTY_ELEMENT;
    Domain domain;

    DomainPropertyEditor() {
        this.domain = null;
    }

    DomainPropertyEditor(Domain domain) {
        this.domain = domain;
    }

    public void setDesignProperty(DesignProperty designProperty) {
        super.setDesignProperty(designProperty);
        if (this.domain != null) {
            return;
        }
        PropertyDescriptor descriptor = designProperty.getPropertyDescriptor();
        Object domainClassValue = descriptor.getValue(DOMAIN_CLASS);
        if (domainClassValue == null) {
            throw new IllegalArgumentException(bundle.getMessage("DomainPropertyEditor.domainMissing", designProperty.getPropertyDescriptor().getDisplayName()));
        }
        if (!(domainClassValue instanceof Class)) {
            throw new IllegalArgumentException(bundle.getMessage("DomainPropertyEditor.domainValueNotClass", designProperty.getPropertyDescriptor().getDisplayName()));
        }
        Class domainClass = (Class)domainClassValue;
        try {
            Domain domain = (Domain)domainClass.newInstance();
            if (domain instanceof AttachedDomain) {
                ((AttachedDomain)domain).setDesignProperty(designProperty);
            }
            this.domain = domain;
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(bundle.getMessage("DomainPropertyEditor.domainError", domainClass.toString(), designProperty.getPropertyDescriptor().getDisplayName()));
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(bundle.getMessage("DomainPropertyEditor.domainError", domainClass.toString(), designProperty.getPropertyDescriptor().getDisplayName()));
        }
        Object defaultValue = designProperty.getUnsetValue();
        if (defaultValue != null) {
            Element[] elements = this.domain.getElements();
            for (int i = 0; i < elements.length; ++i) {
                if (!defaultValue.equals(elements[i].getValue())) continue;
                this.defaultElement = elements[i];
            }
        }
    }

    protected Domain getDomain() {
        return this.domain;
    }

    protected String getPropertyHelpId() {
        if (this.domain != null) {
            return this.domain.getPropertyHelpId();
        }
        return null;
    }
}

