/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors;

import com.sun.rave.propertyeditors.IllegalTextArgumentException;
import com.sun.rave.propertyeditors.NumberPropertyEditor;
import com.sun.rave.propertyeditors.util.JavaInitializer;
import java.text.MessageFormat;

public class DoublePropertyEditor
extends NumberPropertyEditor {
    public static final Double DEFAULT_MIN_VALUE = new Double(Double.MIN_VALUE);
    public static final Double DEFAULT_MAX_VALUE = new Double(Double.MAX_VALUE);

    public DoublePropertyEditor() {
        super(DEFAULT_MIN_VALUE, DEFAULT_MAX_VALUE);
    }

    protected Number parseString(String str) throws NumberFormatException {
        try {
            return Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new IllegalTextArgumentException(MessageFormat.format(bundle.getString("DoublePropertyEditor.formatErrorMessage"), str), e);
        }
    }

    public String getJavaInitializationString() {
        Class<?> c = this.getDesignProperty().getPropertyDescriptor().getPropertyType();
        if (c.equals(Double.class)) {
            return JavaInitializer.toJavaInitializationString((Double)this.getValue());
        }
        return this.getValue().toString() + "D";
    }
}

