/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors;

import com.sun.rave.propertyeditors.IllegalTextArgumentException;
import com.sun.rave.propertyeditors.NumberPropertyEditor;
import com.sun.rave.propertyeditors.util.JavaInitializer;
import java.text.MessageFormat;

public class IntegerPropertyEditor
extends NumberPropertyEditor {
    public static final Integer DEFAULT_MIN_VALUE = new Integer(Integer.MIN_VALUE);
    public static final Integer DEFAULT_MAX_VALUE = new Integer(Integer.MAX_VALUE);

    public IntegerPropertyEditor() {
        super(DEFAULT_MIN_VALUE, DEFAULT_MAX_VALUE);
    }

    protected Number parseString(String str) throws IllegalTextArgumentException {
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new IllegalTextArgumentException(MessageFormat.format(bundle.getString("IntegerPropertyEditor.formatErrorMessage"), str), e);
        }
    }

    public String getJavaInitializationString() {
        Class<?> c = this.getDesignProperty().getPropertyDescriptor().getPropertyType();
        if (c.equals(Integer.class)) {
            return JavaInitializer.toJavaInitializationString((Integer)this.getValue());
        }
        return this.getValue().toString();
    }
}

