/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors;

import com.sun.rave.propertyeditors.IllegalTextArgumentException;
import com.sun.rave.propertyeditors.PropertyEditorBase;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class LengthPropertyEditor
extends PropertyEditorBase {
    static ResourceBundle bundle = ResourceBundle.getBundle(LengthPropertyEditor.class.getPackage().getName() + ".Bundle");

    public String getAsText() {
        if (this.getValue() == null && this.unsetValue == null) {
            return "";
        }
        return super.getAsText();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        String string = text = text == null ? "" : text.trim();
        if (text.length() > 0) {
            try {
                if (text.endsWith("%")) {
                    int value = Integer.parseInt(text.substring(0, text.length() - 1).trim());
                    if (value < 0 || value > 100) {
                        throw new IllegalArgumentException();
                    }
                    text = Integer.toString(value) + "%";
                } else {
                    int value = Integer.parseInt(text);
                    text = Integer.toString(value);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalTextArgumentException(MessageFormat.format(bundle.getString("LengthPropertyEditor.formatErrorMessage"), text), e);
            }
            super.setValue(text);
        } else {
            super.setValue(null);
        }
    }
}

