/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors;

import com.sun.rave.propertyeditors.IllegalTextArgumentException;
import com.sun.rave.propertyeditors.NumberPropertyEditor;
import com.sun.rave.propertyeditors.util.JavaInitializer;
import java.text.MessageFormat;

public class LongPropertyEditor
extends NumberPropertyEditor {
    public static final Long DEFAULT_MIN_VALUE = new Long(Long.MIN_VALUE);
    public static final Long DEFAULT_MAX_VALUE = new Long(Long.MAX_VALUE);

    public LongPropertyEditor() {
        super(DEFAULT_MIN_VALUE, DEFAULT_MAX_VALUE);
    }

    protected Number parseString(String str) throws IllegalTextArgumentException {
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException e) {
            throw new IllegalTextArgumentException(MessageFormat.format(bundle.getString("LongPropertyEditor.formatErrorMessage"), str), e);
        }
    }

    public String getJavaInitializationString() {
        Class<?> c = this.getDesignProperty().getPropertyDescriptor().getPropertyType();
        if (c.equals(Long.class)) {
            return JavaInitializer.toJavaInitializationString((Long)this.getValue());
        }
        return this.getValue().toString();
    }
}

