/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors;

import com.sun.rave.propertyeditors.PropertyEditorBase;
import com.sun.rave.propertyeditors.StringPropertyPanel;
import com.sun.rave.propertyeditors.util.JavaInitializer;
import java.awt.Component;

public class StringPropertyEditor
extends PropertyEditorBase {
    public StringPropertyEditor() {
        super.setValue("");
    }

    public void setValue(Object value) {
        super.setValue(value == null ? "" : value.toString());
    }

    public Object getValue() {
        String value = (String)super.getValue();
        if (value.trim().length() == 0) {
            return null;
        }
        return value;
    }

    public String getJavaInitializationString() {
        return JavaInitializer.toJavaInitializationString((String)this.getValue());
    }

    public Component getCustomEditor() {
        return new StringPropertyPanel(this);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null) {
            this.setValue(null);
        }
        this.setValue(StringPropertyEditor.unescapeString(text));
    }

    public String getAsText() {
        String value = (String)this.getValue();
        if (value == null) {
            return "";
        }
        return StringPropertyEditor.escapeString(value);
    }

    static String escapeString(String str) {
        StringBuffer buffer = new StringBuffer();
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\n') {
                buffer.append("\\n");
                continue;
            }
            if (chars[i] == '\t') {
                buffer.append("\\t");
                continue;
            }
            if (chars[i] == '\\') {
                buffer.append("\\\\");
                continue;
            }
            buffer.append(chars[i]);
        }
        if (buffer.length() == str.length()) {
            return str;
        }
        return buffer.toString();
    }

    static String unescapeString(String str) {
        StringBuffer buffer = new StringBuffer();
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\\' && i < chars.length - 1) {
                if (chars[++i] == '\\') {
                    buffer.append("\\");
                    continue;
                }
                if (chars[i] == 't') {
                    buffer.append("\t");
                    continue;
                }
                if (chars[i] != 'n') continue;
                buffer.append("\n");
                continue;
            }
            buffer.append(chars[i]);
        }
        if (buffer.length() == str.length()) {
            return str;
        }
        return buffer.toString();
    }
}

