/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors;

import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.propertyeditors.IllegalTextArgumentException;
import com.sun.rave.propertyeditors.PropertyEditorBase;
import com.sun.rave.propertyeditors.StyleClassPropertyPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StyleClassPropertyEditor
extends PropertyEditorBase {
    List styleClassList;

    String[] getStyleClasses() {
        if (this.styleClassList == null) {
            return new String[0];
        }
        return this.styleClassList.toArray(new String[this.styleClassList.size()]);
    }

    void setStyleClasses(String[] styleClasses) {
        this.styleClassList = Arrays.asList(styleClasses);
    }

    public Object getValue() {
        if (this.styleClassList == null || this.styleClassList.size() == 0) {
            return null;
        }
        return this.getAsText();
    }

    public void setValue(Object value) {
        String text = (String)value;
        this.styleClassList = text == null || text.trim().length() == 0 ? null : Arrays.asList(text.trim().split("\\s"));
    }

    public String getAsText() {
        if (this.styleClassList == null || this.styleClassList.size() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.styleClassList.get(0));
        for (int i = 1; i < this.styleClassList.size(); ++i) {
            buffer.append(" ");
            buffer.append(this.styleClassList.get(i));
        }
        return buffer.toString();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null || text.trim().length() == 0) {
            this.styleClassList = null;
        } else {
            String[] styleClasses = text.trim().split("\\s");
            Object[] styleClassesInContext = this.getAvailableStyleClasses();
            this.styleClassList = new ArrayList();
            ArrayList<String> notFoundStyleClassList = new ArrayList<String>();
            for (int i = 0; i < styleClasses.length; ++i) {
                int index = Arrays.binarySearch(styleClassesInContext, styleClasses[i]);
                if (index >= 0) {
                    this.styleClassList.add(styleClassesInContext[index]);
                    continue;
                }
                notFoundStyleClassList.add(styleClasses[i]);
            }
            if (notFoundStyleClassList.size() > 0) {
                throw new IllegalTextArgumentException(bundle.getMessage("StyleClassPropertyEditor.classNotFound", ((Object)notFoundStyleClassList).toString()));
            }
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new StyleClassPropertyPanel(this);
    }

    String[] getAvailableStyleClasses() {
        DesignProperty designProperty = this.getDesignProperty();
        if (designProperty == null) {
            return new String[0];
        }
        DesignContext designContext = designProperty.getDesignBean().getDesignContext();
        Object[] styleClasses = (Object[])designContext.getContextData("css-style-class-descriptors");
        String[] styleClassNames = new String[styleClasses.length];
        for (int i = 0; i < styleClasses.length; ++i) {
            styleClassNames[i] = styleClasses[i].toString();
        }
        return styleClassNames;
    }
}

