/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors;

import com.sun.rave.propertyeditors.TabularPropertyModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;

public class TabularPropertyPanel
extends JPanel
implements EnhancedCustomPropertyEditor,
TableModelListener {
    static ResourceBundle bundle = ResourceBundle.getBundle(TabularPropertyPanel.class.getPackage().getName() + ".Bundle");
    private TableModelSupport tableModelSupport;
    private JPanel buttonsPanel;
    private JScrollPane dataPane;
    private JTable dataTable;
    private JButton deleteButton;
    private JButton downButton;
    private JLabel helpLabel;
    private JButton newButton;
    private JButton upButton;

    public TabularPropertyPanel(TabularPropertyModel tableModel) {
        tableModel.addTableModelListener(this);
        this.tableModelSupport = new TableModelSupport(tableModel);
        this.initComponents();
        if (tableModel.getRowCount() > 0) {
            this.dataTable.changeSelection(0, 0, false, false);
        }
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.tableModelSupport.getValue();
    }

    public void tableChanged(TableModelEvent event) {
        int l;
        int f = event.getFirstRow();
        if (f == (l = event.getLastRow())) {
            this.tableModelSupport.fireTableCellUpdated(f, event.getColumn());
        } else if (event.getType() == -1) {
            this.tableModelSupport.fireTableRowsDeleted(f, l);
        } else if (event.getType() == 1) {
            this.tableModelSupport.fireTableRowsInserted(f, l);
        } else {
            this.tableModelSupport.fireTableRowsUpdated(f, l);
        }
    }

    private void initComponents() {
        this.helpLabel = new JLabel();
        this.dataPane = new JScrollPane();
        this.dataTable = new JTable(this.tableModelSupport);
        this.dataTable.setSelectionMode(0);
        JTextField textField = new JTextField();
        CellEditor cellEditor = new CellEditor(this.dataTable, textField);
        this.dataTable.setDefaultEditor(String.class, cellEditor);
        this.dataTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        ((DefaultCellEditor)this.dataTable.getDefaultEditor(String.class)).setClickCountToStart(1);
        this.dataTable.setDefaultRenderer(String.class, new HomogonousCellRenderer());
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        renderer.setBackground(new Color(212, 208, 200));
        this.dataTable.getTableHeader().setDefaultRenderer(renderer);
        this.buttonsPanel = new JPanel();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.helpLabel.setDisplayedMnemonic(ResourceBundle.getBundle("com/sun/rave/propertyeditors/Bundle").getString("TabularPropertyPanel.helpLabel").charAt(0));
        this.helpLabel.setLabelFor(this.dataTable);
        this.helpLabel.setText(bundle.getString("TablePropertyPanel.help"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 10, 10);
        this.add((Component)this.helpLabel, gridBagConstraints);
        this.dataPane.setEnabled(false);
        this.dataTable.setAutoResizeMode(4);
        this.dataTable.setTableHeader(this.dataTable.getTableHeader());
        this.dataPane.setViewportView(this.dataTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.dataPane, gridBagConstraints);
        this.buttonsPanel.setLayout(new GridLayout(4, 1, 0, 5));
        this.newButton.setMnemonic(ResourceBundle.getBundle("com/sun/rave/propertyeditors/Bundle").getString("TabularPropertyPanel").charAt(0));
        this.newButton.setText(bundle.getString("SelectOneDomainPanel.button.new"));
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TabularPropertyPanel.this.newActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.newButton);
        this.deleteButton.setMnemonic(ResourceBundle.getBundle("com/sun/rave/propertyeditors/Bundle").getString("TabularPropertyPanel.deleteButton").charAt(0));
        this.deleteButton.setText(bundle.getString("SelectOneDomainPanel.button.delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TabularPropertyPanel.this.deleteActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.deleteButton);
        this.upButton.setMnemonic(ResourceBundle.getBundle("com/sun/rave/propertyeditors/Bundle").getString("TabularPropertyPanel.upButton").charAt(0));
        this.upButton.setText(bundle.getString("SelectOneDomainPanel.button.up"));
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TabularPropertyPanel.this.upActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.upButton);
        this.downButton.setMnemonic(ResourceBundle.getBundle("com/sun/rave/propertyeditors/Bundle").getString("TabularPropertyPanel.downButton").charAt(0));
        this.downButton.setText(bundle.getString("SelectOneDomainPanel.button.down"));
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TabularPropertyPanel.this.downActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.downButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 6, 0, 10);
        this.add((Component)this.buttonsPanel, gridBagConstraints);
    }

    private void downActionPerformed(ActionEvent evt) {
        int[] selectedRows;
        TableModelSupport tableModel = (TableModelSupport)this.dataTable.getModel();
        if (this.dataTable.getSelectedRowCount() > 0 && (selectedRows = this.dataTable.getSelectedRows())[0] < this.dataTable.getRowCount() - 1 && tableModel.canMoveRow(selectedRows[0], selectedRows[0] + 1)) {
            tableModel.moveRow(selectedRows[0], selectedRows[0] + 1);
            this.dataTable.setModel(tableModel);
            this.dataTable.changeSelection(selectedRows[0] + 1, 0, false, false);
        }
    }

    private void upActionPerformed(ActionEvent evt) {
        int[] selectedRows;
        TableModelSupport tableModel = (TableModelSupport)this.dataTable.getModel();
        if (this.dataTable.getSelectedRowCount() > 0 && (selectedRows = this.dataTable.getSelectedRows())[0] > 0 && tableModel.canMoveRow(selectedRows[0], selectedRows[0] - 1)) {
            tableModel.moveRow(selectedRows[0], selectedRows[0] - 1);
            this.dataTable.setModel(tableModel);
            this.dataTable.changeSelection(selectedRows[0] - 1, 0, false, false);
        }
    }

    private void deleteActionPerformed(ActionEvent evt) {
        TableModelSupport tableModel = (TableModelSupport)this.dataTable.getModel();
        int numRows = tableModel.getRowCount();
        if (this.dataTable.getSelectedRowCount() > 0) {
            boolean lastRowRemoved;
            int[] selectedRows = this.dataTable.getSelectedRows();
            boolean bl = lastRowRemoved = selectedRows[0] == numRows - 1;
            if (tableModel.canRemoveRow(selectedRows[0])) {
                tableModel.removeRow(selectedRows[0]);
                this.dataTable.setModel(tableModel);
                if (tableModel.getRowCount() == 0) {
                    return;
                }
                if (lastRowRemoved) {
                    this.dataTable.changeSelection(tableModel.getRowCount() - 1, 0, false, false);
                } else {
                    this.dataTable.changeSelection(selectedRows[0], 0, false, false);
                }
            }
        }
    }

    private void newActionPerformed(ActionEvent evt) {
        TableModelSupport tableModel = (TableModelSupport)this.dataTable.getModel();
        if (tableModel.canAddRow()) {
            tableModel.addRow();
            this.dataTable.setModel(tableModel);
            this.dataTable.changeSelection(tableModel.getRowCount() - 1, 0, false, false);
            this.dataTable.requestFocusInWindow();
        }
    }

    class CellEditor
    extends DefaultCellEditor {
        private JTable table;

        public CellEditor(JTable table, JTextField component) {
            super(component);
            this.table = table;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            ((JTextField)super.getComponent()).setText((String)value);
            if (isSelected) {
                ((JTextField)super.getComponent()).selectAll();
                table.repaint();
            }
            return super.getComponent();
        }
    }

    class HomogonousCellRenderer
    extends DefaultTableCellRenderer {
        Color SELECTION_BACKGROUND = UIManager.getDefaults().getColor("TextField.selectionBackground");

        HomogonousCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (isSelected) {
                c.setBackground(this.SELECTION_BACKGROUND);
            } else {
                c.setBackground(Color.WHITE);
            }
            return c;
        }
    }

    static class TableModelSupport
    extends AbstractTableModel {
        TabularPropertyModel tableModel;

        TableModelSupport(TabularPropertyModel tableModel) {
            this.tableModel = tableModel;
        }

        public Object getValue() {
            return this.tableModel.getValue();
        }

        public Class getColumnClass(int columnIndex) {
            return this.tableModel.getColumnClass(columnIndex);
        }

        public String getColumnName(int columnIndex) {
            return this.tableModel.getColumnName(columnIndex);
        }

        public int getColumnCount() {
            return this.tableModel.getColumnCount();
        }

        public int getRowCount() {
            return this.tableModel.getRowCount();
        }

        public boolean canRemoveRow(int index) {
            return this.tableModel.canRemoveRow(index);
        }

        public boolean removeRow(int index) {
            if (this.tableModel.removeRow(index)) {
                this.fireTableRowsDeleted(index, index);
                return true;
            }
            return false;
        }

        public boolean removeAllRows() {
            int numRows = this.tableModel.getRowCount();
            if (this.tableModel.removeAllRows()) {
                this.fireTableRowsDeleted(0, numRows - 1);
                return true;
            }
            return false;
        }

        public void setValueAt(Object newValue, int rowIndex, int columnIndex) {
            this.tableModel.setValueAt(newValue, rowIndex, columnIndex);
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.tableModel.getValueAt(rowIndex, columnIndex);
        }

        public boolean canAddRow() {
            return this.tableModel.canAddRow();
        }

        public boolean addRow() {
            if (this.tableModel.addRow()) {
                this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
                return true;
            }
            return false;
        }

        public boolean canMoveRow(int indexFrom, int indexTo) {
            return this.tableModel.canMoveRow(indexFrom, indexTo);
        }

        public boolean moveRow(int indexFrom, int indexTo) {
            if (this.tableModel.moveRow(indexFrom, indexTo)) {
                this.fireTableDataChanged();
                return true;
            }
            return false;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.tableModel.isCellEditable(rowIndex, columnIndex);
        }
    }
}

