/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.faces.FacesDesignContext;
import com.sun.rave.designtime.faces.ResolveResult;
import com.sun.rave.propertyeditors.PropertyEditorBase;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.validator.DoubleRangeValidator;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.LongRangeValidator;
import javax.faces.validator.Validator;

public class ValidatorPropertyEditor
extends PropertyEditorBase {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("com/sun/rave/propertyeditors/Bundle");
    private static final Class[] defaultFacesValidatorClasses = new Class[]{DoubleRangeValidator.class, LengthValidator.class, LongRangeValidator.class};
    private static Comparator validatorComparator = new Comparator(){

        public int compare(Object obj1, Object obj2) {
            String name1 = ((Class)obj1).getName();
            String name2 = ((Class)obj2).getName();
            return name1.substring(name1.lastIndexOf(46) + 1).compareTo(name2.substring(name2.lastIndexOf(46) + 1));
        }
    };
    private static HashMap validatorIdMap = new HashMap();
    private Class[] validatorClasses;
    private String[] validatorLabels;

    public String[] getTags() {
        int i;
        DesignBean[] validatorBeans = this.getValidatorBeans();
        String[] validatorLabels = this.getValidatorLabels();
        String[] tags = new String[validatorBeans.length + validatorLabels.length + 1];
        int index = 0;
        tags[index++] = "";
        for (i = 0; i < validatorBeans.length; ++i) {
            tags[index++] = validatorBeans[i].getInstanceName();
        }
        for (i = 0; i < validatorLabels.length; ++i) {
            tags[index++] = validatorLabels[i];
        }
        return tags;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        DesignProperty designProperty = this.getDesignProperty();
        if (designProperty != null) {
            FacesDesignContext context = (FacesDesignContext)designProperty.getDesignBean().getDesignContext();
            if (text == null || text.trim().length() == 0) {
                ResolveResult result;
                DesignBean lbean;
                Object value = this.getValue();
                if (value != null && value instanceof MethodBinding && !((lbean = (result = context.resolveBindingExprToBean(((MethodBinding)value).getExpressionString())).getDesignBean()).getInstance() instanceof Validator)) {
                    return;
                }
                this.setValue(null);
                return;
            }
            if (text.startsWith("#{")) {
                this.setValidatorMethodBinding(text);
                return;
            }
            DesignBean[] validatorBeans = this.getValidatorBeans();
            for (int i = 0; i < validatorBeans.length; ++i) {
                if (!validatorBeans[i].getInstanceName().equals(text)) continue;
                this.setValidatorBeanBinding(validatorBeans[i]);
                return;
            }
            String[] validatorLabels = this.getValidatorLabels();
            Class[] validatorClasses = this.getValidatorClasses();
            for (int i = 0; i < validatorLabels.length; ++i) {
                DesignBean bean;
                if (!validatorLabels[i].equals(text) || (bean = context.createBean(validatorClasses[i].getName(), null, null)) == null) continue;
                this.setValidatorBeanBinding(bean);
                return;
            }
        }
    }

    public String getAsText() {
        Object value = this.getValue();
        if (value instanceof MethodBinding) {
            DesignProperty designProperty = this.getDesignProperty();
            String expression = ((MethodBinding)value).getExpressionString();
            if (designProperty != null) {
                FacesDesignContext designContext = (FacesDesignContext)designProperty.getDesignBean().getDesignContext();
                ResolveResult result = designContext.resolveBindingExprToBean(expression);
                DesignBean lbean = result.getDesignBean();
                if (lbean.getInstance() instanceof Validator) {
                    return lbean.getInstanceName();
                }
                return expression;
            }
        }
        return value == null ? "" : value.toString();
    }

    public String getJavaInitializationString() {
        return "null";
    }

    private void setValidatorMethodBinding(String binding) {
        DesignProperty designProperty = this.getDesignProperty();
        if (designProperty != null) {
            FacesDesignContext context = (FacesDesignContext)designProperty.getDesignBean().getDesignContext();
            Application app = context.getFacesContext().getApplication();
            MethodBinding mb = app.createMethodBinding(binding, new Class[]{FacesContext.class, UIComponent.class, Object.class});
            this.setValue(mb);
        }
    }

    private void setValidatorBeanBinding(DesignBean sourceBean) {
        DesignProperty designProperty = this.getDesignProperty();
        if (designProperty != null) {
            FacesDesignContext context = (FacesDesignContext)designProperty.getDesignBean().getDesignContext();
            String binding = context.getBindingExpr(sourceBean, ".validate");
            this.setValidatorMethodBinding(binding);
        }
    }

    private DesignBean[] getValidatorBeans() {
        DesignProperty designProperty = this.getDesignProperty();
        return designProperty == null ? new DesignBean[]{} : designProperty.getDesignBean().getDesignContext().getBeansOfType(Validator.class);
    }

    protected Class[] getValidatorClasses() {
        if (this.validatorClasses != null) {
            return this.validatorClasses;
        }
        DesignProperty designProperty = this.getDesignProperty();
        if (designProperty == null) {
            return defaultFacesValidatorClasses;
        }
        FacesContext facesContext = ((FacesDesignContext)designProperty.getDesignBean().getDesignContext()).getFacesContext();
        Application application = facesContext.getApplication();
        Iterator iter = application.getValidatorIds();
        TreeSet set = new TreeSet(validatorComparator);
        while (iter.hasNext()) {
            String id = (String)iter.next();
            if (!validatorIdMap.containsKey(id)) {
                Validator validator = application.createValidator(id);
                validatorIdMap.put(id, validator.getClass());
            }
            set.add(validatorIdMap.get(id));
        }
        this.validatorClasses = new Class[set.size()];
        iter = set.iterator();
        for (int i = 0; i < this.validatorClasses.length; ++i) {
            this.validatorClasses[i] = (Class)iter.next();
        }
        return this.validatorClasses;
    }

    protected String[] getValidatorLabels() {
        if (this.validatorLabels != null) {
            return this.validatorLabels;
        }
        Class[] validatorClasses = this.getValidatorClasses();
        this.validatorLabels = new String[validatorClasses.length];
        MessageFormat labelFormat = new MessageFormat(bundle.getString("ValidatorPropertyEditor.newValidatorLabel"));
        Object[] args = new Object[1];
        for (int i = 0; i < validatorClasses.length; ++i) {
            String name = validatorClasses[i].getName();
            args[0] = name.substring(name.lastIndexOf(46) + 1);
            this.validatorLabels[i] = labelFormat.format(args);
        }
        return this.validatorLabels;
    }
}

