/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors.binding;

import com.sun.rave.designtime.CategoryDescriptor;
import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.markup.AttributeDescriptor;
import com.sun.rave.propertyeditors.binding.PropertyBindingPanel;
import com.sun.rave.propertyeditors.util.Bundle;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import javax.faces.component.UIComponent;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BindingSourcePanel
extends JPanel {
    private static final Bundle bundle = Bundle.getBundle(BindingSourcePanel.class);
    JComboBox compCombo = new JComboBox();
    JLabel compLabel = new JLabel();
    DefaultComboBoxModel compComboModel = new DefaultComboBoxModel();
    DefaultListModel propListModel = new DefaultListModel();
    JLabel propLabel = new JLabel();
    JScrollPane propScroll = new JScrollPane();
    JList propList = new JList();
    JRadioButton showDefault = new JRadioButton();
    JRadioButton showAdvanced = new JRadioButton();
    JRadioButton showAll = new JRadioButton();
    JPanel radioPanel = new JPanel();
    FlowLayout flowLayout1 = new FlowLayout();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    ButtonGroup showGroup = new ButtonGroup();
    JTextPane noneText = new JTextPane();
    protected PropertyBindingPanel bindingPanel;
    protected DesignContext showingContext = null;
    protected DesignBean showingBean = null;
    protected DesignProperty showingProp = null;
    GridBagConstraints propScrollConstraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 8, 0, 0), 0, 0);
    protected static Icon BLANK_ICON = new Icon(){

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(c.getBackground());
            g.fillRect(x, y, 16, 16);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }
    };
    public static Icon BEAN_ICON = new ImageIcon(BindingSourcePanel.class.getResource("img/bean.gif"));
    static HashMap arrayTypeKeyHash = new HashMap();

    public BindingSourcePanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.propList.getAccessibleContext().setAccessibleName(bundle.getMessage("SOURCE_PROP_LIST_ACCESS_NAME"));
        this.propList.getAccessibleContext().setAccessibleDescription(bundle.getMessage("SOURCE_PROP_LIST_ACCESS_DESC"));
        this.propLabel.setLabelFor(this.propList);
        this.showDefault.getAccessibleContext().setAccessibleName(bundle.getMessage("SHOW_DEFAULT_ACCESS_NAME"));
        this.showDefault.getAccessibleContext().setAccessibleDescription(bundle.getMessage("SHOW_DEFAULT_ACCESS_DESC"));
        this.showAdvanced.getAccessibleContext().setAccessibleName(bundle.getMessage("SHOW_ADVANCED_ACCESS_NAME"));
        this.showAdvanced.getAccessibleContext().setAccessibleDescription(bundle.getMessage("SHOW_ADVANCED_ACCESS_DESC"));
        this.showAll.getAccessibleContext().setAccessibleName(bundle.getMessage("SHOW_ALL_ACCESS_NAME"));
        this.showAll.getAccessibleContext().setAccessibleDescription(bundle.getMessage("SHOW_ALL_ACCESS_DESC"));
        this.showDefault.setMnemonic(bundle.getMessage("SHOW_DEFAULT_MNEMONIC").charAt(0));
        this.showAdvanced.setMnemonic(bundle.getMessage("SHOW_ADVANCED_MNEMONIC").charAt(0));
        this.showAll.setMnemonic(bundle.getMessage("SHOW_ALL_MNEMONIC").charAt(0));
    }

    public BindingSourcePanel(PropertyBindingPanel bindingPanel) {
        this();
        this.bindingPanel = bindingPanel;
    }

    public void sourceContextChanged(DesignContext context) {
        if (this.showingContext != null && this.showingContext == context) {
            return;
        }
        this.showingContext = context;
        this.compComboModel.removeAllElements();
        if (context != null) {
            DesignBean root = context.getRootContainer();
            this.fillCombo(root.getChildBeans());
        }
    }

    public void sourceBeanChanged(DesignBean bean) {
        if (this.showingBean == bean) {
            return;
        }
        this.showingBean = bean;
        if (bean != null) {
            this.compCombo.setSelectedItem(bean);
            this.enumProps();
        } else {
            this.propListModel.removeAllElements();
        }
    }

    public void sourcePropertyChanged(DesignProperty prop) {
        if (this.showingProp == prop) {
            return;
        }
        this.showingProp = prop;
        if (prop != null) {
            this.propList.setSelectedValue(prop, true);
        } else {
            this.propList.clearSelection();
        }
    }

    protected void fillCombo(DesignBean[] beans) {
        for (int i = 0; i < beans.length; ++i) {
            if (beans[i].getInstance() instanceof UIComponent) {
                this.compComboModel.addElement(beans[i]);
            }
            if (!beans[i].isContainer()) continue;
            this.fillCombo(beans[i].getChildBeans());
        }
    }

    protected void enumProps() {
        int i;
        DesignProperty[] props = this.bindingPanel.getSourceBean().getProperties();
        this.propListModel.removeAllElements();
        ArrayList<DesignProperty> pa = new ArrayList<DesignProperty>();
        for (int i2 = 0; i2 < props.length; ++i2) {
            AttributeDescriptor ad;
            if (props[i2].getPropertyDescriptor().getWriteMethod() == null || (ad = (AttributeDescriptor)props[i2].getPropertyDescriptor().getValue("attributeDescriptor")) == null || !ad.isBindable()) continue;
            if (this.showDefault.isSelected()) {
                CategoryDescriptor pcd = (CategoryDescriptor)props[i2].getPropertyDescriptor().getValue("category");
                if (props[i2].getPropertyDescriptor().isHidden() || props[i2].getPropertyDescriptor().isExpert() || pcd != null && pcd.getName().equals("Advanced")) {
                    continue;
                }
            } else if (this.showAdvanced.isSelected() && props[i2].getPropertyDescriptor().isHidden()) continue;
            pa.add(props[i2]);
        }
        ArrayList<DesignProperty> mods = new ArrayList<DesignProperty>();
        ArrayList<DesignProperty> rest = new ArrayList<DesignProperty>();
        for (i = 0; i < pa.size(); ++i) {
            String vx;
            DesignProperty p = (DesignProperty)pa.get(i);
            if (p.isModified() && (vx = p.getValueSource()) != null && vx.startsWith("#{") && vx.endsWith("}")) {
                mods.add(p);
                continue;
            }
            rest.add(p);
        }
        for (i = 0; i < mods.size(); ++i) {
            this.propListModel.addElement(mods.get(i));
        }
        for (i = 0; i < rest.size(); ++i) {
            this.propListModel.addElement(rest.get(i));
        }
        if (this.propListModel.getSize() > 0) {
            this.remove(this.noneText);
            this.add((Component)this.propScroll, this.propScrollConstraints);
            if (mods.size() > 0) {
                this.propList.setSelectedIndex(0);
            } else {
                int i3;
                boolean foundValue = false;
                for (i3 = 0; i3 < rest.size(); ++i3) {
                    if (((DesignProperty)rest.get(i3)).getPropertyDescriptor().getName() != "value") continue;
                    this.propList.setSelectedValue(rest.get(i3), true);
                    foundValue = true;
                    break;
                }
                if (!foundValue) {
                    for (i3 = 0; i3 < rest.size(); ++i3) {
                        if (((DesignProperty)rest.get(i3)).getPropertyDescriptor().getName() != "text") continue;
                        this.propList.setSelectedValue(rest.get(i3), true);
                        break;
                    }
                }
            }
            if (this.propList.getSelectedValue() == null) {
                this.propList.setSelectedIndex(0);
            }
        } else {
            this.remove(this.propScroll);
            this.add((Component)this.noneText, this.propScrollConstraints);
        }
        this.validate();
        this.doLayout();
        this.repaint(100L);
    }

    void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.noneText.setEditable(false);
        this.noneText.setFont(this.propLabel.getFont());
        this.noneText.setBorder(UIManager.getBorder("TextField.border"));
        this.noneText.setText(bundle.getMessage("noBindableProps"));
        this.compLabel.setText(bundle.getMessage("selectComponent"));
        this.compCombo.setModel(this.compComboModel);
        this.compCombo.setRenderer(new CompComboRenderer());
        this.compCombo.setEditable(false);
        this.compCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BindingSourcePanel.this.compCombo_actionPerformed(e);
            }
        });
        this.propLabel.setText(bundle.getMessage("selectBindableProp"));
        this.propLabel.setDisplayedMnemonic(bundle.getMessage("selectBindablePropDisplayedMnemonic").charAt(0));
        this.propList.setModel(this.propListModel);
        this.propList.setCellRenderer(new PropListRenderer());
        this.propList.setSelectionMode(0);
        this.propList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                BindingSourcePanel.this.propList_valueChanged(e);
            }
        });
        this.showDefault.setText(bundle.getMessage("default"));
        this.showDefault.setSelected(true);
        this.showDefault.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                BindingSourcePanel.this.show_itemStateChanged(e);
            }
        });
        this.showAdvanced.setText(bundle.getMessage("advanced"));
        this.showAdvanced.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                BindingSourcePanel.this.show_itemStateChanged(e);
            }
        });
        this.showAll.setText(bundle.getMessage("all"));
        this.showAll.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                BindingSourcePanel.this.show_itemStateChanged(e);
            }
        });
        this.radioPanel.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.flowLayout1.setHgap(5);
        this.flowLayout1.setVgap(0);
        this.add((Component)this.propLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(8, 8, 2, 0), 0, 0));
        this.add((Component)this.propScroll, this.propScrollConstraints);
        this.add((Component)this.radioPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 8, 0), 0, 0));
        this.radioPanel.add((Component)this.showDefault, null);
        this.radioPanel.add((Component)this.showAdvanced, null);
        this.radioPanel.add((Component)this.showAll, null);
        this.propScroll.getViewport().add((Component)this.propList, null);
        this.showGroup.add(this.showDefault);
        this.showGroup.add(this.showAdvanced);
        this.showGroup.add(this.showAll);
    }

    void show_itemStateChanged(ItemEvent e) {
        Object o = this.propList.getSelectedValue();
        this.enumProps();
        this.propList.setSelectedValue(o, false);
    }

    void compCombo_actionPerformed(ActionEvent e) {
        DesignBean b = (DesignBean)this.compCombo.getSelectedItem();
        this.bindingPanel.setSourceBean(b);
    }

    void propList_valueChanged(ListSelectionEvent e) {
        DesignProperty p = (DesignProperty)this.propList.getSelectedValue();
        this.bindingPanel.setSourceProperty(p);
    }

    String decodeTypeName(String tn) {
        if (tn.startsWith("[")) {
            int depth = 0;
            while (tn.startsWith("[")) {
                tn = tn.substring(1);
                ++depth;
            }
            if (tn.startsWith("L")) {
                tn = tn.substring(1);
                tn = tn.substring(0, tn.length() - 1);
            } else {
                char typeKey = tn.charAt(0);
                tn = (String)arrayTypeKeyHash.get("" + typeKey);
            }
            for (int i = 0; i < depth; ++i) {
                tn = tn + "[]";
            }
        }
        return tn;
    }

    static {
        arrayTypeKeyHash.put("B", "byte");
        arrayTypeKeyHash.put("C", "char");
        arrayTypeKeyHash.put("D", "double");
        arrayTypeKeyHash.put("F", "float");
        arrayTypeKeyHash.put("I", "int");
        arrayTypeKeyHash.put("J", "long");
        arrayTypeKeyHash.put("S", "short");
        arrayTypeKeyHash.put("Z", "boolean");
        arrayTypeKeyHash.put("V", "void");
    }

    class PropListRenderer
    extends DefaultListCellRenderer {
        PropListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof DesignProperty) {
                DesignProperty p = (DesignProperty)value;
                PropertyDescriptor pd = p.getPropertyDescriptor();
                String cn = pd.getPropertyType().getName();
                if (cn.startsWith("[")) {
                    cn = BindingSourcePanel.this.decodeTypeName(cn);
                }
                if (cn.indexOf(".") > -1) {
                    cn = cn.substring(cn.lastIndexOf(".") + 1);
                }
                boolean bold = false;
                if (p.isModified()) {
                    String vx = p.getValueSource();
                    if (vx == null) {
                        vx = "";
                    }
                    bold = vx.startsWith("#{") && vx.endsWith("}");
                }
                StringBuffer sb = new StringBuffer();
                sb.append("<html>");
                if (bold) {
                    sb.append("<b>");
                }
                sb.append(pd.getName());
                if (bold) {
                    sb.append("</b>");
                }
                sb.append(" &nbsp; <font size=\"-1\"><i>");
                sb.append(cn);
                sb.append("</i></font></html>");
                this.setText(sb.toString());
                this.setIcon(UIManager.getIcon("Tree.leafIcon"));
            }
            return this;
        }
    }

    class CompComboRenderer
    extends DefaultListCellRenderer {
        CompComboRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof DesignBean) {
                DesignBean b = (DesignBean)value;
                String prefix = "";
                for (DesignBean p = b.getBeanParent(); p != null && p != b.getDesignContext().getRootContainer(); p = p.getBeanParent()) {
                    prefix = prefix + "   ";
                }
                this.setText(prefix + b.getInstanceName());
                BeanInfo bi = b.getBeanInfo();
                Image img = bi.getIcon(1);
                if (img != null) {
                    this.setIcon(new ImageIcon(img));
                } else {
                    this.setIcon(BEAN_ICON);
                }
            }
            return this;
        }
    }
}

