/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors.binding;

import com.sun.rave.designtime.Customizer2;
import com.sun.rave.designtime.CustomizerResult;
import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.DisplayAction;
import com.sun.rave.designtime.Result;
import com.sun.rave.designtime.impl.BasicDisplayAction;
import com.sun.rave.propertyeditors.binding.PropertyBindingsCustomizer;
import com.sun.rave.propertyeditors.util.Bundle;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.openide.ErrorManager;

public class PropertyBindingHelper {
    public static final Bundle bundle = Bundle.getBundle(PropertyBindingHelper.class);
    static HashMap arrayTypeKeyHash = new HashMap();

    public static DisplayAction getContextItem(DesignBean bean) {
        return new PropertyBindingsAction(bean);
    }

    public static DisplayAction getContextItem(DesignProperty prop) {
        return new PropertyBindingAction(prop);
    }

    public static Object getPropInstance(DesignBean bean, PropertyDescriptor[] propPath) {
        if (propPath != null && propPath.length > 0) {
            try {
                ArrayList<PropertyDescriptor> propList = new ArrayList<PropertyDescriptor>();
                for (int i = 0; i < propPath.length; ++i) {
                    propList.add(propPath[i]);
                }
                Object o = bean.getInstance();
                block5: while (o != null && propList.size() > 0) {
                    PropertyDescriptor pdnext = (PropertyDescriptor)propList.get(0);
                    BeanInfo bi = Introspector.getBeanInfo(o.getClass());
                    PropertyDescriptor[] pdanext = bi.getPropertyDescriptors();
                    for (int i = 0; i < pdanext.length; ++i) {
                        if (!pdanext[i].getName().equals(pdnext.getName())) continue;
                        Method read = pdanext[i].getReadMethod();
                        if (read != null && !read.getName().equals("getFieldKeys")) {
                            try {
                                o = read.invoke(o, new Object[0]);
                                if (o instanceof ValueBinding) {
                                    o = ((ValueBinding)o).getValue(FacesContext.getCurrentInstance());
                                }
                            }
                            catch (Exception exc) {
                                ErrorManager.getDefault().notify(1, (Throwable)exc);
                                return null;
                            }
                            if (o == null) continue;
                            propList.remove(0);
                            continue block5;
                        }
                        return null;
                    }
                }
                return o;
            }
            catch (Exception exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
        } else {
            return bean.getInstance();
        }
        return null;
    }

    public static String getPrettyTypeName(String tn) {
        if ((tn = PropertyBindingHelper.getJavaTypeName(tn)).indexOf(".") > -1) {
            tn = tn.substring(tn.lastIndexOf(".") + 1);
        }
        return tn;
    }

    public static String getJavaTypeName(String tn) {
        if (tn.startsWith("[")) {
            int depth = 0;
            while (tn.startsWith("[")) {
                tn = tn.substring(1);
                ++depth;
            }
            if (tn.startsWith("L")) {
                tn = tn.substring(1);
                tn = tn.substring(0, tn.length() - 1);
            } else {
                char typeKey = tn.charAt(0);
                tn = (String)arrayTypeKeyHash.get("" + typeKey);
            }
            for (int i = 0; i < depth; ++i) {
                tn = tn + "[]";
            }
        }
        return tn;
    }

    static {
        arrayTypeKeyHash.put("B", "byte");
        arrayTypeKeyHash.put("C", "char");
        arrayTypeKeyHash.put("D", "double");
        arrayTypeKeyHash.put("F", "float");
        arrayTypeKeyHash.put("I", "int");
        arrayTypeKeyHash.put("J", "long");
        arrayTypeKeyHash.put("S", "short");
        arrayTypeKeyHash.put("Z", "boolean");
        arrayTypeKeyHash.put("V", "void");
    }

    private static class PropertyBindingsAction
    extends BasicDisplayAction {
        protected DesignBean bean;

        public PropertyBindingsAction(DesignBean bean) {
            super(bundle.getMessage("propBindingsEllipse"));
            this.bean = bean;
        }

        public Result invoke() {
            PropertyBindingsCustomizer bc = new PropertyBindingsCustomizer(this.bean);
            return new CustomizerResult(this.bean, (Customizer2)bc);
        }
    }

    private static class PropertyBindingAction
    extends BasicDisplayAction {
        protected DesignProperty prop = null;

        public PropertyBindingAction(DesignProperty prop) {
            super(bundle.getMessage("propBindingEllipse"));
            this.prop = prop;
        }

        public Result invoke() {
            PropertyBindingsCustomizer bc = new PropertyBindingsCustomizer(this.prop);
            bc.panel.setShowSourcePanel(false);
            return new CustomizerResult(this.prop.getDesignBean(), (Customizer2)bc);
        }
    }
}

