/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors.binding;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.Result;
import com.sun.rave.designtime.impl.BasicCustomizer2;
import com.sun.rave.propertyeditors.binding.PropertyBindingPanel;
import com.sun.rave.propertyeditors.util.Bundle;
import java.awt.Component;

public class PropertyBindingsCustomizer
extends BasicCustomizer2 {
    public static final Bundle bundle = Bundle.getBundle(PropertyBindingsCustomizer.class);
    protected DesignProperty prop = null;
    protected PropertyBindingPanel panel = null;

    public PropertyBindingsCustomizer() {
        this.setDisplayName(bundle.getMessage("propBindings"));
        this.setApplyCapable(false);
        this.setHelpKey("projrave_ui_elements_dialogs_property_binding_db");
    }

    public PropertyBindingsCustomizer(DesignBean designBean) {
        this();
        this.designBean = designBean;
        this.setDisplayName(bundle.getMessage("propBindingsPattern", designBean.getInstanceName()));
    }

    public PropertyBindingsCustomizer(DesignProperty prop) {
        this(prop.getDesignBean());
        this.prop = prop;
        this.setDisplayName(bundle.getMessage("propBindingPattern", this.designBean.getInstanceName(), prop.getPropertyDescriptor().getName()));
    }

    public Component getCustomizerPanel(DesignBean bean) {
        this.panel = new PropertyBindingPanel();
        if (this.prop != null) {
            this.panel.setSourceProperty(this.prop);
        } else {
            this.panel.setSourceBean(bean);
        }
        this.panel.setCustomizer(this);
        return this.panel;
    }

    public Result applyChanges() {
        return Result.SUCCESS;
    }

    public boolean isModified() {
        if (this.panel != null) {
            return this.panel.isModified();
        }
        return super.isModified();
    }
}

