/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors.binding;

import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.faces.FacesBindingPropertyEditor;
import com.sun.rave.designtime.faces.FacesDesignContext;
import com.sun.rave.designtime.faces.FacesDesignProperty;
import com.sun.rave.propertyeditors.binding.BindingTargetCallback;
import com.sun.rave.propertyeditors.binding.data.DataBindingHelper;
import com.sun.rave.propertyeditors.binding.data.TabbedDataBindingPanel;
import com.sun.rave.propertyeditors.util.Bundle;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Vector;
import javax.faces.application.Application;
import javax.faces.el.ValueBinding;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;

public class ValueBindingPropertyEditor
implements PropertyEditor,
ExPropertyEditor,
FacesBindingPropertyEditor,
BindingTargetCallback {
    public static final String BINDING_PANEL_CLASS_NAMES = "bindingPanelClassNames";
    private static final Bundle bundle = Bundle.getBundle(ValueBindingPropertyEditor.class);
    protected PropertyEditor delegatePropertyEditor;
    private Object value;
    protected Component customEditor;
    private Vector listeners;
    private boolean useDelegatePropertyEditor;
    protected DesignProperty designProperty;
    protected FacesDesignProperty facesDesignProperty;
    private static final ImageIcon BOUND_ICON = new ImageIcon(ValueBindingPropertyEditor.class.getResource("bound.png"));
    private static final JLabel lbl = new JLabel(BOUND_ICON, 2);

    public ValueBindingPropertyEditor() {
        this(null);
    }

    public ValueBindingPropertyEditor(PropertyEditor propertyEditor) {
        this.delegatePropertyEditor = propertyEditor;
    }

    protected boolean isPropertyBound() {
        return this.facesDesignProperty != null && this.facesDesignProperty.isBound();
    }

    protected boolean isValueBindingValue() {
        return this.value instanceof ValueBinding;
    }

    protected Object getValueBindingValue() {
        if (this.isValueBindingValue()) {
            FacesDesignContext fctx = (FacesDesignContext)this.facesDesignProperty.getDesignBean().getDesignContext();
            ValueBinding valueBinding = (ValueBinding)this.value;
            return valueBinding.getValue(fctx.getFacesContext());
        }
        return null;
    }

    protected boolean isUseDelegatePropertyEditor() {
        return this.useDelegatePropertyEditor;
    }

    protected void setUseDelegatePropertyEditor(boolean newUseValue) {
        if (this.delegatePropertyEditor == null) {
            this.useDelegatePropertyEditor = false;
        } else {
            if (this.useDelegatePropertyEditor == newUseValue) {
                return;
            }
            this.useDelegatePropertyEditor = newUseValue;
        }
    }

    protected void setValueInternal(Object newValue) {
        this.value = newValue;
    }

    protected Object getValueInternal() {
        return this.value;
    }

    public void setDesignProperty(DesignProperty prop) {
        this.designProperty = prop;
        this.facesDesignProperty = prop instanceof FacesDesignProperty ? (FacesDesignProperty)prop : null;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        this.setValue(this.designProperty.getValue());
        if (this.delegatePropertyEditor == null) {
            this.customEditor = new TabbedDataBindingPanelAdapter(this, this.designProperty, (Class[])this.designProperty.getPropertyDescriptor().getValue(BINDING_PANEL_CLASS_NAMES), true);
        } else {
            Component delegateCustomEditorComponent = null;
            if (this.delegatePropertyEditor.supportsCustomEditor()) {
                delegateCustomEditorComponent = this.delegatePropertyEditor.getCustomEditor();
            }
            this.customEditor = new TabbedDataBindingPanelWrapper(this, this.designProperty, (Class[])this.designProperty.getPropertyDescriptor().getValue(BINDING_PANEL_CLASS_NAMES), true, delegateCustomEditorComponent);
        }
        return this.customEditor;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(listener);
        if (this.delegatePropertyEditor != null) {
            this.delegatePropertyEditor.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(listener);
        if (this.delegatePropertyEditor != null) {
            this.delegatePropertyEditor.removePropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void firePropertyChange() {
        Vector targets;
        ValueBindingPropertyEditor valueBindingPropertyEditor = this;
        synchronized (valueBindingPropertyEditor) {
            if (this.listeners == null) {
                return;
            }
            targets = (Vector)this.listeners.clone();
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, null, null, null);
        for (int i = 0; i < targets.size(); ++i) {
            PropertyChangeListener target = (PropertyChangeListener)targets.elementAt(i);
            target.propertyChange(evt);
        }
    }

    public Object getValue() {
        if (this.isUseDelegatePropertyEditor() && this.delegatePropertyEditor != null) {
            this.setValueInternal(this.delegatePropertyEditor.getValue());
            this.setUseDelegatePropertyEditor(!this.isValueBindingValue());
        }
        return this.getValueInternal();
    }

    public void setValue(Object newValue) {
        if (this.isPropertyBound()) {
            ValueBinding valueBinding = this.facesDesignProperty.getValueBinding();
            this.setValueInternal(valueBinding);
            this.setUseDelegatePropertyEditor(false);
        } else {
            this.setValueInternal(newValue);
            this.setUseDelegatePropertyEditor(true);
        }
        if (this.delegatePropertyEditor != null) {
            this.delegatePropertyEditor.setValue(newValue);
        }
    }

    public String getJavaInitializationString() {
        if (this.isUseDelegatePropertyEditor() && this.delegatePropertyEditor != null) {
            return this.delegatePropertyEditor.getJavaInitializationString();
        }
        if (this.isValueBindingValue()) {
            if (this.delegatePropertyEditor != null) {
                this.delegatePropertyEditor.setValue(this.getValueBindingValue());
                return this.delegatePropertyEditor.getJavaInitializationString();
            }
        } else if (this.delegatePropertyEditor != null) {
            this.delegatePropertyEditor.setValue(this.getValueInternal());
            return this.delegatePropertyEditor.getJavaInitializationString();
        }
        return "";
    }

    public String getAsText() {
        if (this.isUseDelegatePropertyEditor() && this.delegatePropertyEditor != null) {
            return this.delegatePropertyEditor.getAsText();
        }
        if (this.isValueBindingValue()) {
            return ((ValueBinding)this.getValueInternal()).getExpressionString();
        }
        if (this.delegatePropertyEditor != null) {
            this.delegatePropertyEditor.setValue(this.getValueInternal());
            return this.delegatePropertyEditor.getAsText();
        }
        if (this.getValueInternal() == null) {
            return "";
        }
        return String.valueOf(this.getValueInternal());
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (this.isUseDelegatePropertyEditor()) {
            if (this.delegatePropertyEditor != null) {
                this.delegatePropertyEditor.setAsText(text);
            }
        } else if ((text = text.trim()).startsWith("#{") && text.endsWith("}")) {
            FacesDesignContext fctx = (FacesDesignContext)this.designProperty.getDesignBean().getDesignContext();
            Application app = fctx.getFacesContext().getApplication();
            this.setValueInternal(app.createValueBinding(text));
        } else if (text.length() > 0) {
            if (this.delegatePropertyEditor != null) {
                this.delegatePropertyEditor.setAsText(text);
                this.setValueInternal(this.delegatePropertyEditor.getValue());
            }
        } else {
            this.setValueInternal(this.facesDesignProperty.getUnsetValue());
        }
    }

    public String[] getTags() {
        if (this.isUseDelegatePropertyEditor() && this.delegatePropertyEditor != null) {
            return this.delegatePropertyEditor.getTags();
        }
        if (this.isValueBindingValue()) {
            return null;
        }
        if (this.delegatePropertyEditor != null) {
            return this.delegatePropertyEditor.getTags();
        }
        return null;
    }

    public boolean isPaintable() {
        Class<?> c;
        if (this.isUseDelegatePropertyEditor() && this.delegatePropertyEditor != null) {
            return this.delegatePropertyEditor.isPaintable();
        }
        return this.isValueBindingValue() && ((c = this.designProperty.getPropertyDescriptor().getPropertyType()) == Boolean.class || c == Boolean.TYPE);
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        Class<?> c;
        if (!this.isPaintable()) {
            return;
        }
        if (this.isUseDelegatePropertyEditor()) {
            if (this.delegatePropertyEditor != null) {
                this.delegatePropertyEditor.paintValue(gfx, box);
            }
            return;
        }
        if (this.isValueBindingValue() && ((c = this.designProperty.getPropertyDescriptor().getPropertyType()) == Boolean.class || c == Boolean.TYPE)) {
            String text = this.getAsText();
            lbl.setText(text == null ? "" : text);
            lbl.setBounds(box);
            lbl.setForeground(gfx.getColor());
            lbl.paint(gfx);
        }
    }

    public void refresh() {
    }

    public void setNewExpressionText(String newExpr) {
        if (newExpr.startsWith("#{") && newExpr.endsWith("}")) {
            FacesDesignContext fctx = (FacesDesignContext)this.designProperty.getDesignBean().getDesignContext();
            Application app = fctx.getFacesContext().getApplication();
            this.setValueInternal(app.createValueBinding(newExpr));
            this.setUseDelegatePropertyEditor(false);
            if (this.delegatePropertyEditor != null) {
                this.delegatePropertyEditor.setValue(this.getValueBindingValue());
            }
        } else {
            this.setValueInternal(this.facesDesignProperty.getUnsetValue());
            this.setUseDelegatePropertyEditor(true);
            if (this.delegatePropertyEditor != null) {
                this.delegatePropertyEditor.setValue(this.facesDesignProperty.getUnsetValue());
            }
        }
    }

    public void attachEnv(PropertyEnv env) {
        if (this.delegatePropertyEditor instanceof ExPropertyEditor) {
            ((ExPropertyEditor)this.delegatePropertyEditor).attachEnv(env);
        }
    }

    private class TabbedDataBindingPanelWrapper
    extends JPanel
    implements EnhancedCustomPropertyEditor {
        private JRadioButton useValueButton;
        private JRadioButton useBindingButton;
        private ButtonGroup useValueUseBindingGroup;
        private static final String BINDING_CARD = "bindingCard";
        private static final String VALUE_CARD = "valueCard";
        private CardLayout cardLayout;
        private JPanel cardPanel;
        private TabbedDataBindingPanel tabbedDataBindingPanel;
        private Component delegateCustomEditorComponent;

        public TabbedDataBindingPanelWrapper(BindingTargetCallback callback, DesignProperty prop, Class[] bindingPanelClasses, boolean showExpr, Component delegateCustomEditor) {
            this.delegateCustomEditorComponent = delegateCustomEditor;
            this.setLayout(new GridBagLayout());
            this.useValueUseBindingGroup = new ButtonGroup();
            this.useBindingButton = new JRadioButton(bundle.getMessage("LBL_UseBindingRadionButton"));
            this.useBindingButton.setMnemonic(bundle.getMessage("LBL_UseBindingRadionButton_Mnemonic").charAt(0));
            this.useBindingButton.getAccessibleContext().setAccessibleName(bundle.getMessage("LBL_UseBindingRadionButton"));
            this.useBindingButton.getAccessibleContext().setAccessibleDescription(bundle.getMessage("LBL_UseBindingRadionButton_A11YDescription"));
            this.useValueUseBindingGroup.add(this.useBindingButton);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(12, 12, 0, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.useBindingButton, gridBagConstraints);
            this.useValueButton = new JRadioButton(bundle.getMessage("LBL_UseValueRadionButton"));
            this.useValueButton.setMnemonic(bundle.getMessage("LBL_UseValueRadionButton_Mnemonic").charAt(0));
            this.useValueButton.getAccessibleContext().setAccessibleName(bundle.getMessage("LBL_UseValueRadionButton"));
            this.useValueButton.getAccessibleContext().setAccessibleDescription(bundle.getMessage("LBL_UseValueRadionButton_A11YDescription"));
            this.useValueUseBindingGroup.add(this.useValueButton);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(12, 12, 0, 11);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.useValueButton, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(12, 12, 0, 11);
            this.add((Component)new JSeparator(), gridBagConstraints);
            this.cardLayout = new CardLayout();
            this.cardPanel = new JPanel(this.cardLayout);
            if (bindingPanelClasses == null || bindingPanelClasses.length == 1) {
                bindingPanelClasses = new Class[]{DataBindingHelper.BIND_VALUE_TO_DATAPROVIDER, DataBindingHelper.BIND_VALUE_TO_OBJECT};
            }
            this.tabbedDataBindingPanel = new TabbedDataBindingPanel(callback, prop, bindingPanelClasses, showExpr);
            this.cardPanel.add((Component)this.tabbedDataBindingPanel, BINDING_CARD);
            if (delegateCustomEditor == null) {
                JTextArea message = new JTextArea(bundle.getMessage("MSG_EditValueInPropertySheet"));
                message.setEditable(false);
                message.setLineWrap(true);
                message.setWrapStyleWord(true);
                message.setBorder(null);
                message.setBackground(UIManager.getColor("Label.background"));
                message.getAccessibleContext().setAccessibleName(bundle.getMessage("MSG_EditValueInPropertySheet"));
                message.getAccessibleContext().setAccessibleDescription(bundle.getMessage("MSG_EditValueInPropertySheet"));
                this.cardPanel.add((Component)message, VALUE_CARD);
            } else {
                this.cardPanel.add(delegateCustomEditor, VALUE_CARD);
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(12, 12, 12, 11);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)this.cardPanel, gridBagConstraints);
            if (ValueBindingPropertyEditor.this.isPropertyBound()) {
                this.useBindingButton.setSelected(true);
                this.cardLayout.show(this.cardPanel, BINDING_CARD);
            } else {
                this.useValueButton.setSelected(true);
                this.cardLayout.show(this.cardPanel, VALUE_CARD);
            }
            this.useBindingButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TabbedDataBindingPanelWrapper.this.adjustUseValueUseBinding();
                }
            });
            this.useValueButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TabbedDataBindingPanelWrapper.this.adjustUseValueUseBinding();
                }
            });
        }

        public void addNotify() {
            super.addNotify();
            this.cardPanel.requestFocus();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TabbedDataBindingPanelWrapper.this.cardPanel.transferFocus();
                }
            });
        }

        void adjustUseValueUseBinding() {
            if (this.useBindingButton.isSelected()) {
                ValueBindingPropertyEditor.this.setUseDelegatePropertyEditor(false);
                this.showBindingCard();
            } else if (this.useValueButton.isSelected()) {
                ValueBindingPropertyEditor.this.setUseDelegatePropertyEditor(true);
                this.showValueCard();
            }
        }

        void showBindingCard() {
            this.cardLayout.show(this.cardPanel, BINDING_CARD);
        }

        void showValueCard() {
            this.cardLayout.show(this.cardPanel, VALUE_CARD);
        }

        public Object getPropertyValue() throws IllegalStateException {
            if (ValueBindingPropertyEditor.this.isUseDelegatePropertyEditor() && this.delegateCustomEditorComponent instanceof EnhancedCustomPropertyEditor) {
                Object propertyValue = ((EnhancedCustomPropertyEditor)this.delegateCustomEditorComponent).getPropertyValue();
                ValueBindingPropertyEditor.this.setValueInternal(propertyValue);
                ValueBindingPropertyEditor.this.setUseDelegatePropertyEditor(!ValueBindingPropertyEditor.this.isValueBindingValue());
                return ValueBindingPropertyEditor.this.getValueInternal();
            }
            return ValueBindingPropertyEditor.this.getValue();
        }
    }

    private class TabbedDataBindingPanelAdapter
    extends JPanel
    implements EnhancedCustomPropertyEditor {
        private TabbedDataBindingPanel tabbedDataBindingPanel;

        public TabbedDataBindingPanelAdapter(BindingTargetCallback callback, DesignProperty prop, Class[] bindingPanelClasses, boolean showExpr) {
            this.setLayout(new BorderLayout(8, 8));
            this.tabbedDataBindingPanel = new TabbedDataBindingPanel(callback, prop, bindingPanelClasses, showExpr);
            this.add((Component)this.tabbedDataBindingPanel, "Center");
        }

        public Object getPropertyValue() throws IllegalStateException {
            return ValueBindingPropertyEditor.this.getValue();
        }
    }
}

