/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors.binding.data;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.Result;
import com.sun.rave.designtime.faces.FacesDesignProperty;
import com.sun.rave.designtime.impl.BasicCustomizer2;
import com.sun.rave.propertyeditors.binding.BindingTargetCallback;
import com.sun.rave.propertyeditors.binding.data.DataBindingHelper;
import com.sun.rave.propertyeditors.binding.data.TabbedDataBindingPanel;
import com.sun.rave.propertyeditors.util.Bundle;
import java.awt.Component;

public class DataBindingCustomizer
extends BasicCustomizer2
implements BindingTargetCallback {
    private static final Bundle bundle = Bundle.getBundle(DataBindingCustomizer.class);
    String propName;
    DesignProperty prop;
    FacesDesignProperty fprop;
    String newExpression = null;
    Class[] panelClasses = null;
    boolean showExpr = true;
    Object originalValue;
    String originalValueSource;
    protected TabbedDataBindingPanel tabbedPanel = null;

    public DataBindingCustomizer(String propName, Class[] panelClasses, boolean showExpr, String dialogTitle) {
        super(null, dialogTitle, null, null);
        this.propName = propName;
        this.panelClasses = panelClasses;
        this.showExpr = showExpr;
        if (panelClasses[0] == DataBindingHelper.BIND_OPTIONS_TO_DATAPROVIDER) {
            this.setHelpKey("projrave_ui_elements_dialogs_bindtodata_list_db");
        } else {
            this.setHelpKey("projrave_ui_elements_dialogs_bindtodata_simple_db");
        }
    }

    public DataBindingCustomizer(String propName, Class[] panelClasses, boolean showExpr) {
        this(propName, panelClasses, showExpr, bundle.getMessage("bindToData"));
    }

    public DataBindingCustomizer(String propName, Class[] panelClasses) {
        this(propName, panelClasses, false, bundle.getMessage("bindToData"));
    }

    public void refresh() {
    }

    public void setNewExpressionText(String newExpr) {
        this.newExpression = newExpr;
        if (this.newExpression != null) {
            if (!this.newExpression.trim().equals(this.originalValueSource)) {
                this.setModified(true);
            } else {
                this.setModified(false);
            }
        } else if (this.originalValueSource != null) {
            this.setModified(true);
        } else {
            this.setModified(false);
        }
    }

    public Component getCustomizerPanel(DesignBean designBean) {
        this.setDisplayName(bundle.getMessage("bindToData") + " - " + designBean.getInstanceName());
        this.designBean = designBean;
        this.prop = designBean.getProperty(this.propName);
        if (this.prop instanceof FacesDesignProperty) {
            this.fprop = (FacesDesignProperty)this.prop;
            if (this.fprop.isBound() && this.fprop.getValueBinding() != null) {
                this.newExpression = this.fprop.getValueBinding().getExpressionString();
            }
        }
        if (this.prop instanceof FacesDesignProperty) {
            FacesDesignProperty facesProp = (FacesDesignProperty)this.prop;
            if (facesProp.isBound()) {
                this.originalValueSource = facesProp.getValueSource();
                if (this.originalValueSource != null) {
                    this.originalValueSource = this.originalValueSource.trim();
                }
            } else {
                this.originalValue = facesProp.getValue();
            }
        }
        this.tabbedPanel = new TabbedDataBindingPanel(this, this.prop, this.panelClasses, this.showExpr);
        return this.tabbedPanel;
    }

    public boolean isApplyCapable() {
        return true;
    }

    public Result applyChanges() {
        if (this.isModified()) {
            if (this.newExpression == null || this.newExpression.trim().equals("")) {
                if (this.originalValueSource != this.originalValue) {
                    this.prop.unset();
                } else {
                    this.prop.setValue(this.originalValue);
                }
            } else {
                this.prop.setValueSource(this.newExpression);
            }
        }
        return super.applyChanges();
    }
}

