/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors.binding.data;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.FolderInstance;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DataProviderExplorerPanel
extends ExplorerPanel {
    private final TreeView view = new BeanTreeView();
    private final ServernavChildren children = new ServernavChildren();
    TopComponent tc = WindowManager.getDefault().findTopComponent("serverNavigator");
    static /* synthetic */ Class class$com$sun$rave$propertyeditors$binding$data$DataProviderExplorerPanel;

    public DataProviderExplorerPanel() {
        this.view.setDropTarget(false);
        this.view.setDragSource(false);
        this.view.setRootVisible(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.view, "Center");
        this.getExplorerManager().setRootContext((Node)new AbstractNode((Children)this.children));
        this.initialize();
    }

    public void initialize() {
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("ServerNavigator");
        if (fo != null) {
            DataFolder folder = DataFolder.findFolder((FileObject)fo);
            final ServerNavigatorFolder servNavFolder = new ServerNavigatorFolder(folder);
            servNavFolder.recreate();
            servNavFolder.instanceFinished();
            fo.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                public void fileDeleted(FileEvent evt) {
                    servNavFolder.recreate();
                }

                public void fileDataCreated(FileEvent evt) {
                    servNavFolder.recreate();
                }
            });
        }
        this.tc.requestActive();
    }

    public HelpCtx getHelpCtx() {
        Node[] selNodes = this.getExplorerManager().getSelectedNodes();
        if (selNodes != null && selNodes.length == 1) {
            return selNodes[0].getHelpCtx();
        }
        return HelpCtx.DEFAULT_HELP;
    }

    private class ServernavChildren
    extends Children.Keys {
        private ServernavChildren() {
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof Node) {
                final Node node = (Node)key;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (DataProviderExplorerPanel.this.view != null) {
                            DataProviderExplorerPanel.this.view.expandNode(node);
                        }
                    }
                });
                return new Node[]{node};
            }
            return new Node[0];
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        public void updateKeys(Collection keys) {
            this.setKeys(keys);
        }
    }

    private final class ServerNavigatorFolder
    extends FolderInstance {
        public ServerNavigatorFolder(DataFolder folder) {
            super(folder);
        }

        protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
            final ArrayList<Node> nodes = new ArrayList<Node>();
            for (int i = 0; i < cookies.length; ++i) {
                try {
                    Node node;
                    Object obj = cookies[i].instanceCreate();
                    if (!(obj instanceof Node) || !(node = ((Node)obj).cloneNode()).getName().equals(NbBundle.getMessage((Class)(class$com$sun$rave$propertyeditors$binding$data$DataProviderExplorerPanel == null ? DataProviderExplorerPanel.class$("com.sun.rave.propertyeditors.binding.data.DataProviderExplorerPanel") : class$com$sun$rave$propertyeditors$binding$data$DataProviderExplorerPanel), (String)"DATA_SOURCES"))) continue;
                    nodes.add(node);
                    DataProviderExplorerPanel.this.view.expandNode(node);
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                    continue;
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DataProviderExplorerPanel.this.children.updateKeys(nodes);
                }
            });
            return nodes;
        }
    }
}

