/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors.binding.nodes;

import com.sun.data.provider.DataProvider;
import com.sun.data.provider.FieldKey;
import com.sun.rave.designtime.DesignBean;
import com.sun.rave.propertyeditors.binding.BindingTargetNode;
import com.sun.rave.propertyeditors.binding.BindingTargetNodeFactory;
import com.sun.rave.propertyeditors.binding.PropertyBindingHelper;
import com.sun.rave.propertyeditors.binding.nodes.PropertyTargetNode;
import com.sun.rave.propertyeditors.util.Bundle;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;

public class DataProviderTargetNodeFactory
implements BindingTargetNodeFactory {
    private static final Bundle bundle = Bundle.getBundle(DataProviderTargetNodeFactory.class);
    static /* synthetic */ Class array$Ljavax$faces$model$SelectItem;

    public boolean supportsTargetClass(Class targetClass) {
        return DataProvider.class.isAssignableFrom(targetClass);
    }

    public BindingTargetNode createTargetNode(BindingTargetNode parent, DesignBean bean, PropertyDescriptor[] propPath, Object propInstance) {
        return new DataProviderTargetNode(parent, bean, propPath, propInstance);
    }

    public class DataProviderTargetNode
    extends PropertyTargetNode {
        public DataProviderTargetNode(BindingTargetNode parent, DesignBean bean, PropertyDescriptor[] propPath, Object propInstance) {
            super(parent, bean, propPath, propInstance);
        }

        public void lazyLoadCustomTargetNodes() {
            if (this.propInstance == null) {
                this.propInstance = PropertyBindingHelper.getPropInstance(this.bean, this.propPath);
            }
            if (this.propInstance instanceof DataProvider) {
                Thread dataProvideNodeThread = new Thread(new Runnable(){

                    public void run() {
                        final DataProvider dp = (DataProvider)DataProviderTargetNode.this.propInstance;
                        try {
                            final FieldKey[] keys = dp.getFieldKeys();
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    for (int i = 0; keys != null && i < keys.length; ++i) {
                                        DataProviderTargetNode.super.add(new FieldKeyNode(DataProviderTargetNode.this, (this).DataProviderTargetNode.this.bean, (this).DataProviderTargetNode.this.propPath, dp, keys[i]));
                                    }
                                    DataProviderTargetNode.super.add(new OptionsNode(DataProviderTargetNode.this, dp, keys));
                                    DataProviderTargetNode.super.add(new SelectItemsNode(DataProviderTargetNode.this, dp, keys));
                                }
                            });
                        }
                        catch (Exception exc) {
                            ErrorManager.getDefault().notify((Throwable)exc);
                        }
                    }
                });
                dataProvideNodeThread.setPriority(1);
                dataProvideNodeThread.start();
            }
        }

        public class ComboDisplayColumnRenderer
        extends DefaultListCellRenderer {
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof ComboDisplayColumn) {
                    ComboDisplayColumn cdc = (ComboDisplayColumn)value;
                    String tn = cdc.fieldType != null ? cdc.fieldType.getName() : "";
                    StringBuffer sb = new StringBuffer();
                    sb.append("<html><b>");
                    sb.append(cdc.fieldKey.getDisplayName());
                    sb.append("</b> &nbsp; <font size=\"-1\"><i>");
                    sb.append(tn);
                    sb.append("</i></font></html>");
                    this.setText(sb.toString());
                } else {
                    this.setText(bundle.getMessage("noneBrackets"));
                }
                return this;
            }
        }

        public class ComboDisplayColumn {
            public FieldKey fieldKey;
            public Class fieldType;

            public ComboDisplayColumn(FieldKey fieldKey, Class fieldType) {
                this.fieldKey = fieldKey;
                this.fieldType = fieldType;
            }
        }

        public class SelectItemsNode
        extends BindingTargetNode {
            protected DataProvider provider;
            FieldKey[] cols;
            protected String displayTextEnabled;
            protected String displayTextDisabled;
            JPanel pickerPanel;
            JLabel valueLabel;
            JLabel labelLabel;
            JLabel descrLabel;
            JComboBox valueCombo;
            JComboBox labelCombo;
            JComboBox descrCombo;
            ActionListener updateCallback;
            ActionListener updateAdapter;

            public SelectItemsNode(BindingTargetNode parent, DataProvider provider, FieldKey[] cols) {
                super(parent);
                this.displayTextEnabled = null;
                this.displayTextDisabled = null;
                this.pickerPanel = new JPanel();
                this.valueLabel = new JLabel(bundle.getMessage("valueField"));
                this.labelLabel = new JLabel(bundle.getMessage("displayField"));
                this.descrLabel = new JLabel(bundle.getMessage("tooltipField"));
                this.valueCombo = new JComboBox();
                this.labelCombo = new JComboBox();
                this.descrCombo = new JComboBox();
                this.updateCallback = null;
                this.updateAdapter = new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (SelectItemsNode.this.updateCallback != null) {
                            SelectItemsNode.this.updateCallback.actionPerformed(e);
                        }
                    }
                };
                this.provider = provider;
                this.cols = cols;
                this.initCustomPanel();
                this.displayTextEnabled = this.getDisplayText(true);
                this.displayTextDisabled = this.getDisplayText(false);
            }

            public String getNodeDisplayName() {
                return bundle.getMessage("selectItems");
            }

            public String getDisplayText(boolean enableNode) {
                if (enableNode && this.displayTextEnabled != null) {
                    return this.displayTextEnabled;
                }
                if (!enableNode && this.displayTextDisabled != null) {
                    return this.displayTextDisabled;
                }
                StringBuffer sb = new StringBuffer();
                sb.append("<html>");
                if (!enableNode) {
                    sb.append("<font color=\"gray\">");
                }
                if (enableNode) {
                    sb.append("<b>");
                }
                sb.append(this.getNodeDisplayName());
                if (enableNode) {
                    sb.append("</b>");
                }
                sb.append(" &nbsp; <font size=\"-1\"><i>");
                sb.append(bundle.getMessage("parenItemsForListBoxOr"));
                sb.append("</i></font>");
                if (!enableNode) {
                    sb.append("</font>");
                }
                sb.append("</html>");
                return sb.toString();
            }

            public int getChildCount() {
                return 0;
            }

            public boolean lazyLoad() {
                return true;
            }

            public Class getTargetTypeClass() {
                return array$Ljavax$faces$model$SelectItem == null ? (array$Ljavax$faces$model$SelectItem = DataProviderTargetNodeFactory.class$("[Ljavax.faces.model.SelectItem;")) : array$Ljavax$faces$model$SelectItem;
            }

            public boolean isValidBindingTarget() {
                return true;
            }

            public String getBindingExpressionPart() {
                return "selectItems['" + this.getColumnPicks() + "']";
            }

            String getColumnPicks() {
                StringBuffer sb = new StringBuffer();
                Object o = this.valueCombo.getSelectedItem();
                if (o instanceof ComboDisplayColumn) {
                    sb.append(((ComboDisplayColumn)o).fieldKey.getFieldId());
                }
                if ((o = this.labelCombo.getSelectedItem()) instanceof ComboDisplayColumn) {
                    sb.append(",");
                    sb.append(((ComboDisplayColumn)o).fieldKey.getFieldId());
                }
                if ((o = this.descrCombo.getSelectedItem()) instanceof ComboDisplayColumn) {
                    sb.append(",");
                    sb.append(((ComboDisplayColumn)o).fieldKey.getFieldId());
                }
                return sb.toString();
            }

            void initCustomPanel() {
                ComboDisplayColumnRenderer cdcr = new ComboDisplayColumnRenderer();
                this.valueCombo.setRenderer(cdcr);
                this.labelCombo.setRenderer(cdcr);
                this.descrCombo.setRenderer(cdcr);
                this.labelCombo.addItem(bundle.getMessage("noneBrackets"));
                this.descrCombo.addItem(bundle.getMessage("noneBrackets"));
                if (this.cols != null && this.cols.length > 0) {
                    for (int i = 0; i < this.cols.length; ++i) {
                        ComboDisplayColumn col = new ComboDisplayColumn(this.cols[i], this.provider.getType(this.cols[i]));
                        this.valueCombo.addItem(col);
                        this.labelCombo.addItem(col);
                        this.descrCombo.addItem(col);
                    }
                }
                this.pickerPanel.setLayout(new GridBagLayout());
                this.pickerPanel.add((Component)this.valueLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 2, 4), 0, 0));
                this.pickerPanel.add((Component)this.labelLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 2, 4), 0, 0));
                this.pickerPanel.add((Component)this.descrLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 2, 0), 0, 0));
                this.pickerPanel.add((Component)this.valueCombo, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 4), 0, 0));
                this.pickerPanel.add((Component)this.labelCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 4), 0, 0));
                this.pickerPanel.add((Component)this.descrCombo, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.valueCombo.addActionListener(this.updateAdapter);
                this.labelCombo.addActionListener(this.updateAdapter);
                this.descrCombo.addActionListener(this.updateAdapter);
            }

            public JComponent getCustomDisplayPanel(ActionListener updateCallback) {
                this.updateCallback = updateCallback;
                return this.pickerPanel;
            }
        }

        public class OptionsNode
        extends SelectItemsNode {
            public OptionsNode(BindingTargetNode parent, DataProvider provider, FieldKey[] cols) {
                super(parent, provider, cols);
            }

            public String getNodeDisplayName() {
                return bundle.getMessage("options");
            }

            public String getBindingExpressionPart() {
                return "options['" + this.getColumnPicks() + "']";
            }
        }

        public class FieldKeyNode
        extends BindingTargetNode {
            protected DesignBean bean;
            protected PropertyDescriptor[] propPath;
            protected DataProvider provider;
            protected FieldKey key;

            public FieldKeyNode(BindingTargetNode parent, DesignBean bean, PropertyDescriptor[] propPath, DataProvider provider, FieldKey key) {
                super(parent);
                this.bean = bean;
                this.propPath = propPath;
                this.provider = provider;
                this.key = key;
            }

            public boolean lazyLoad() {
                try {
                    BeanInfo bi = Introspector.getBeanInfo(this.getTargetTypeClass());
                    PropertyDescriptor[] pds = bi.getPropertyDescriptors();
                    for (int i = 0; pds != null && i < pds.length; ++i) {
                        if (pds[i].getReadMethod() == null) continue;
                        PropertyDescriptor[] newPath = new PropertyDescriptor[this.propPath.length + 1];
                        System.arraycopy(this.propPath, 0, newPath, 0, this.propPath.length);
                        newPath[newPath.length - 1] = pds[i];
                        super.add(FieldKeyNode._createTargetNode(this, this.bean, newPath, null));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }

            public boolean isValidBindingTarget() {
                return true;
            }

            public String getBindingExpressionPart() {
                return "value['" + this.key.getFieldId() + "']";
            }

            public Class getTargetTypeClass() {
                return this.provider.getType(this.key);
            }

            public String getDisplayText(boolean enableNode) {
                String tn = this.getTargetTypeDisplayName();
                StringBuffer sb = new StringBuffer();
                sb.append("<html>");
                if (!enableNode) {
                    sb.append("<font color=\"gray\">");
                }
                sb.append(bundle.getMessage("key"));
                sb.append(" ");
                if (enableNode) {
                    sb.append("<b>");
                }
                sb.append(this.key.getDisplayName());
                if (enableNode) {
                    sb.append("</b>");
                }
                sb.append(" &nbsp; <font size=\"-1\"><i>");
                sb.append(tn);
                sb.append("</i></font>");
                if (!enableNode) {
                    sb.append("</font>");
                }
                sb.append("</html>");
                return sb.toString();
            }
        }
    }
}

