/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.propertyeditors.binding.nodes;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.propertyeditors.binding.BindingTargetNode;
import com.sun.rave.propertyeditors.binding.BindingTargetNodeFactory;
import com.sun.rave.propertyeditors.binding.PropertyBindingHelper;
import com.sun.rave.propertyeditors.binding.nodes.PropertyTargetNode;
import com.sun.rave.propertyeditors.util.Bundle;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Map;

public class MapTargetNodeFactory
implements BindingTargetNodeFactory {
    private static final Bundle bundle = Bundle.getBundle(MapTargetNodeFactory.class);

    public boolean supportsTargetClass(Class targetClass) {
        return Map.class.isAssignableFrom(targetClass);
    }

    public BindingTargetNode createTargetNode(BindingTargetNode parent, DesignBean bean, PropertyDescriptor[] propPath, Object propInstance) {
        return new MapTargetNode(parent, bean, propPath, propInstance);
    }

    public class MapTargetNode
    extends PropertyTargetNode {
        public MapTargetNode(BindingTargetNode parent, DesignBean bean, PropertyDescriptor[] propPath, Object propInstance) {
            super(parent, bean, propPath, propInstance);
        }

        public void lazyLoadCustomTargetNodes() {
            if (this.propInstance == null) {
                this.propInstance = PropertyBindingHelper.getPropInstance(this.bean, this.propPath);
            }
            if (this.propInstance instanceof Map) {
                Map map = (Map)this.propInstance;
                Object[] keys = map.keySet().toArray();
                for (int i = 0; i < keys.length; ++i) {
                    if (!(keys[i] instanceof String)) continue;
                    super.add(new KeyNode(this, this.bean, this.propPath, map, keys[i]));
                }
            }
        }

        public class KeyNode
        extends BindingTargetNode {
            protected DesignBean bean;
            protected PropertyDescriptor[] propPath;
            protected Map map;
            protected Object key;

            public KeyNode(BindingTargetNode parent, DesignBean bean, PropertyDescriptor[] propPath, Map map, Object key) {
                super(parent);
                this.bean = bean;
                this.propPath = propPath;
                this.map = map;
                this.key = key;
            }

            public boolean lazyLoad() {
                try {
                    BeanInfo bi = Introspector.getBeanInfo(this.getTargetTypeClass());
                    PropertyDescriptor[] pds = bi.getPropertyDescriptors();
                    for (int i = 0; pds != null && i < pds.length; ++i) {
                        if (pds[i].getReadMethod() == null) continue;
                        PropertyDescriptor[] newPath = new PropertyDescriptor[this.propPath.length + 1];
                        System.arraycopy(this.propPath, 0, newPath, 0, this.propPath.length);
                        newPath[newPath.length - 1] = pds[i];
                        super.add(KeyNode._createTargetNode(this, this.bean, newPath, null));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }

            public boolean isValidBindingTarget() {
                return true;
            }

            public String getBindingExpressionPart() {
                return "" + this.key;
            }

            public Class getTargetTypeClass() {
                return this.map.get(this.key).getClass();
            }

            public String getDisplayText(boolean enableNode) {
                String tn = this.getTargetTypeDisplayName();
                StringBuffer sb = new StringBuffer();
                sb.append("<html>");
                if (!enableNode) {
                    sb.append("<font color=\"gray\">");
                }
                sb.append(bundle.getMessage("key"));
                sb.append(" ");
                if (enableNode) {
                    sb.append("<b>");
                }
                sb.append(this.key);
                if (enableNode) {
                    sb.append("</b>");
                }
                sb.append(" &nbsp; <font size=\"-1\"><i>");
                sb.append(tn);
                sb.append("</i></font>");
                if (!enableNode) {
                    sb.append("</font>");
                }
                sb.append("</html>");
                return sb.toString();
            }
        }
    }
}

