/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop;

import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.util.I18n;
import com.sun.portal.desktop.util.PIParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;

public class DesktopRequest
implements HttpServletRequest {
    private HttpServletRequest req;
    private Hashtable parameterTable = null;
    private String charset = null;
    private boolean isReadInputStream = false;
    private DesktopAppContext dac = null;

    public DesktopRequest(HttpServletRequest request, DesktopAppContext dac, boolean readFromParameters) {
        this.req = request;
        this.dac = dac;
        this.parseParameters(request, readFromParameters);
    }

    protected void parseParameters(HttpServletRequest req, boolean readFromParameters) {
        Map piMap;
        Map dtMap;
        if (readFromParameters) {
            this.parameterTable = new Hashtable();
            Enumeration e = req.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String[] val = new String[]{req.getParameter(name)};
                this.parameterTable.put(name, val);
            }
        } else if (req.getMethod().equalsIgnoreCase("GET") || this.getContentType() == null || this.getContentType().indexOf("application/x-www-form-urlencoded") == -1) {
            String query = req.getQueryString();
            if (query == null) {
                query = "";
            } else {
                this.parameterTable = HttpUtils.parseQueryString((String)query);
            }
        } else if (req.getMethod().equalsIgnoreCase("POST")) {
            Hashtable queryParamTable = null;
            Hashtable formParamTable = null;
            String query = req.getQueryString();
            ServletInputStream is = null;
            try {
                is = req.getInputStream();
                formParamTable = HttpUtils.parsePostData((int)req.getContentLength(), (ServletInputStream)is);
                if (query != null) {
                    queryParamTable = HttpUtils.parseQueryString((String)query);
                    this.parameterTable = this.mergeParams(queryParamTable, formParamTable);
                }
                this.parameterTable = formParamTable;
            }
            catch (IOException ioe) {
                this.dac.debugError("DesktopRequest.parseParameters(): caught IOException:" + ioe);
            }
        }
        String pathInfo = this.getPathInfoValue(req);
        if (pathInfo != null && pathInfo.length() != 0 && (dtMap = (Map)(piMap = PIParser.parse(pathInfo)).get("desktop.args")) != null && !dtMap.isEmpty()) {
            Map arrayDTMap = this.getArrayDTMap(dtMap);
            this.parameterTable = this.mergeParams(this.parameterTable, arrayDTMap);
        }
        if (this.parameterTable == null) {
            this.parameterTable = new Hashtable();
        }
    }

    private Map getArrayDTMap(Map dtMap) {
        HashMap<String, String[]> arrayDTMap = new HashMap<String, String[]>();
        Set entry = dtMap.entrySet();
        Iterator i = entry.iterator();
        while (i.hasNext()) {
            String value;
            Map.Entry me = i.next();
            String Key = (String)me.getKey();
            if (Key == null || Key.length() == 0 || (value = (String)me.getValue()) == null || value.length() == 0) continue;
            String[] newval = new String[]{value};
            arrayDTMap.put(Key, newval);
        }
        return arrayDTMap;
    }

    private String getPathInfoValue(HttpServletRequest req) {
        String pi = req.getPathInfo();
        if (pi != null && pi.equals(req.getServletPath())) {
            pi = null;
        }
        return pi;
    }

    private Hashtable mergeParams(Map target, Map source) {
        Hashtable<String, String[]> result = null;
        if (target != null) {
            result = new Hashtable<String, String[]>(target);
        }
        if (target != null && source != null) {
            Set srcEntry = source.entrySet();
            Iterator i = srcEntry.iterator();
            while (i.hasNext()) {
                Map.Entry me = i.next();
                String fromKey = (String)me.getKey();
                if (fromKey == null || fromKey.length() == 0) continue;
                String[] fromVal = (String[])me.getValue();
                String[] toVal = (String[])target.get(fromKey);
                if (toVal != null && toVal.length > 0) {
                    if (fromVal == null || fromVal.length <= 0) continue;
                    int len = toVal.length + fromVal.length;
                    String[] newval = new String[len];
                    System.arraycopy(toVal, 0, newval, 0, toVal.length);
                    System.arraycopy(fromVal, 0, newval, toVal.length, fromVal.length);
                    result.put(fromKey, newval);
                    continue;
                }
                result.put(fromKey, fromVal);
            }
        } else if (source != null) {
            result = new Hashtable(source);
        }
        if (result == null) {
            result = new Hashtable();
        }
        return result;
    }

    public void decodeParams(String charset) {
        this.charset = charset;
        if (this.parameterTable != null) {
            Enumeration e = this.parameterTable.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object o = this.parameterTable.get(key);
                String decodedkey = I18n.decodeCharset(key, charset);
                this.parameterTable.remove(key);
                if (o instanceof String[]) {
                    String[] vals = (String[])o;
                    for (int j = 0; j < vals.length; ++j) {
                        vals[j] = I18n.decodeCharset(vals[j], charset);
                    }
                    this.parameterTable.put(decodedkey, vals);
                    continue;
                }
                String val = (String)o;
                val = I18n.decodeCharset(val, charset);
                this.parameterTable.put(decodedkey, val);
            }
        }
    }

    public Hashtable getParameterMap() {
        return this.parameterTable;
    }

    public String getAuthType() {
        return this.req.getAuthType();
    }

    public String getContextPath() {
        return this.req.getContextPath();
    }

    public Cookie[] getCookies() {
        return this.req.getCookies();
    }

    public long getDateHeader(String name) {
        return this.req.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.req.getHeader(name);
    }

    public Enumeration getHeaderNames() {
        return this.req.getHeaderNames();
    }

    public Enumeration getHeaders(String name) {
        return this.req.getHeaders(name);
    }

    public int getIntHeader(String name) {
        return this.getIntHeader(name);
    }

    public String getMethod() {
        return this.req.getMethod();
    }

    public String getPathInfo() {
        return this.req.getPathInfo();
    }

    public String getPathTranslated() {
        return this.req.getPathTranslated();
    }

    public String getQueryString() {
        return this.req.getQueryString();
    }

    public String getRemoteUser() {
        return this.req.getRemoteUser();
    }

    public String getRequestedSessionId() {
        throw new UnsupportedOperationException("Use iPS session API to get session information");
    }

    public String getRequestURI() {
        String uri = this.req.getRequestURI();
        return uri;
    }

    public String getServletPath() {
        return this.req.getServletPath();
    }

    public HttpSession getSession() {
        throw new UnsupportedOperationException("Use iPS session API to get session information");
    }

    public HttpSession getSession(boolean create) {
        throw new UnsupportedOperationException("Use iPS session API to get session information");
    }

    public Principal getUserPrincipal() {
        return this.req.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException("Use iPS session API to get session information");
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException("Use iPS session API to get session information");
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException("Use iPS session API to get session information");
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException("Use iPS session API to get session information");
    }

    public boolean isUserInRole(String role) {
        return this.req.isUserInRole(role);
    }

    public Object getAttribute(String name) {
        return this.req.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.req.getAttributeNames();
    }

    public String getCharacterEncoding() {
        if (this.charset == null) {
            return this.req.getCharacterEncoding();
        }
        return this.charset;
    }

    public int getContentLength() {
        if (this.getContentType() != null && this.getContentType().indexOf("application/x-www-form-urlencoded") == -1) {
            return this.req.getContentLength();
        }
        return -1;
    }

    public String getContentType() {
        return this.req.getContentType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServletInputStream getInputStream() throws IOException {
        if (this.getContentType() != null && this.getContentType().indexOf("application/x-www-form-urlencoded") == -1 && !this.isReadInputStream) {
            DesktopRequest desktopRequest = this;
            synchronized (desktopRequest) {
                this.isReadInputStream = true;
            }
            return this.req.getInputStream();
        }
        throw new UnsupportedOperationException("Request input is not available to providers");
    }

    public Locale getLocale() {
        return this.req.getLocale();
    }

    public Enumeration getLocales() {
        return this.req.getLocales();
    }

    public String getParameter(String name) {
        String[] values = (String[])this.parameterTable.get(name);
        if (values != null && values.length >= 1) {
            return values[0];
        }
        return null;
    }

    public Enumeration getParameterNames() {
        return this.parameterTable.keys();
    }

    public String[] getParameterValues(String name) {
        return (String[])this.parameterTable.get(name);
    }

    public String getProtocol() {
        return this.req.getProtocol();
    }

    public synchronized BufferedReader getReader() throws IOException {
        if (this.getContentType() != null && this.getContentType().indexOf("application/x-www-form-urlencoded") == -1) {
            return this.req.getReader();
        }
        throw new UnsupportedOperationException("Request input is not available to providers");
    }

    public String getRealPath(String path) {
        throw new UnsupportedOperationException("getRealPath is deprecated");
    }

    public String getRemoteAddr() {
        return this.req.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.req.getRemoteHost();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException("RequestDispatcher is not available to providers");
    }

    public String getScheme() {
        return this.req.getScheme();
    }

    public String getServerName() {
        return this.req.getServerName();
    }

    public int getServerPort() {
        return this.req.getServerPort();
    }

    public boolean isSecure() {
        return this.req.isSecure();
    }

    public void removeAttribute(String name) {
        this.req.removeAttribute(name);
    }

    public void setAttribute(String name, Object o) {
        this.req.setAttribute(name, o);
    }
}

