/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.admin.model;

import com.sun.portal.desktop.admin.model.DAConsoleException;
import com.sun.portal.desktop.admin.model.DADPModelImpl;
import com.sun.portal.desktop.admin.model.DAEditPropertiesModel;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPCollection;
import com.sun.portal.desktop.dp.DPProperties;
import com.sun.portal.desktop.dp.DPProperty;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.xml.XMLDPCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class DAEditPropertiesModelImpl
extends DADPModelImpl
implements DAEditPropertiesModel {
    private String fqcn = null;
    private String rpn = null;
    private Map propertiesMap = null;
    private Set providerPropertyNames = null;
    protected List channelCollections = null;
    private List providerCollections = null;
    private boolean allUnNamed = true;
    private String providerName = null;

    public DAEditPropertiesModelImpl(HttpServletRequest req, String rbName, Map map) throws DAConsoleException {
        super(req, rbName, map);
        this.fqcn = (String)map.get("com.sun.portal.desktop.admin.fqcn");
        this.rpn = (String)map.get("com.sun.portal.desktop.admin.rpn");
    }

    public void initData() throws DAConsoleException {
        this.propertiesMap = new HashMap(5);
        this.providerPropertyNames = Collections.EMPTY_SET;
        this.channelCollections = new ArrayList();
        this.providerCollections = new ArrayList();
        if (this.rpn != null && this.rpn.length() == 0) {
            this.rpn = null;
        }
        if (this.fqcn == null || this.fqcn.length() == 0) {
            this.initDP_rootProperties();
        } else {
            this.initChannelProperties();
        }
    }

    private void initDP_rootProperties() {
        DPProperties dpProperties = this.dpRoot.getProperties();
        Map dpPropertyMap = this.getNestedProperties(dpProperties, this.rpn, this.channelCollections);
        this.providerPropertyNames = Collections.EMPTY_SET;
        this.propertiesMap.putAll(dpPropertyMap);
        this.message("DAEditPropertiesModelImpl.initDP_rootProperties: Number of properties = " + this.propertiesMap.size());
    }

    private void initChannelProperties() throws DAConsoleException {
        DPChannel channel = this.dpRoot.getChannel(this.fqcn);
        if (channel == null) {
            this.error("DAEditPropertiesModelImpl.initChannelProperties: Channel " + this.fqcn + " is null.");
            throw new DAConsoleException(1, "Channel null");
        }
        DPProperties channelProperties = channel.getProperties();
        DPProvider provider = channel.getProvider();
        if (provider == null) {
            this.error("DAEditPropertiesModelImpl.initChannelProperties: Provider is null for " + this.fqcn + "channel.");
            throw new DAConsoleException(2, "Provider null");
        }
        this.providerName = provider.getName();
        DPProperties providerProperties = provider.getProperties();
        Map channelPropertyMap = this.getNestedProperties(channelProperties, this.rpn, this.channelCollections);
        Map providerPropertyMap = this.getNestedProperties(providerProperties, this.rpn, this.providerCollections);
        Set channelPropertyNames = channelPropertyMap.keySet();
        this.providerPropertyNames = providerPropertyMap.keySet();
        Iterator iter = this.providerPropertyNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!channelPropertyNames.contains(name)) continue;
            iter.remove();
            providerPropertyMap.remove(name);
        }
        this.propertiesMap.putAll(channelPropertyMap);
        this.propertiesMap.putAll(providerPropertyMap);
        this.message("DAEditPropertiesModelImpl.initChannelProperties: Number of channel properties = " + channelPropertyMap.size());
        this.message("DAEditPropertiesModelImpl.initChannelProperties: Number of provider properties = " + providerPropertyMap.size());
    }

    private boolean isDisplayable(String name, DPProperty property) {
        boolean display = true;
        short type = property.getType();
        if (type == -1) {
            display = false;
        } else if (name.startsWith("_conditional_") && type == 16) {
            display = true;
        } else if (name.startsWith("_") || type == 15) {
            display = false;
        } else if (this.rpn == null && !property.isNamed()) {
            display = false;
        }
        if (!display) {
            this.message("DAEditPropertiesModelImpl.isDisplayable: Property " + name + " is not displayable.");
        }
        return display;
    }

    private Map buildPropertyMap(DPCollection collection) {
        Set names = null;
        boolean dpPropertiesObject = collection instanceof DPProperties;
        names = dpPropertiesObject ? ((DPProperties)collection).getNames(false) : collection.getNames();
        names = names == null ? Collections.EMPTY_SET : names;
        HashMap<String, DPProperty> map = new HashMap<String, DPProperty>(names.size());
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            DPProperty prop = null;
            prop = dpPropertiesObject ? ((DPProperties)collection).get(name, false) : collection.get(name);
            if (prop == null || !this.isDisplayable(name, prop)) continue;
            map.put(name, prop);
            if (prop.isNamed()) {
                this.allUnNamed = false;
                continue;
            }
            if (prop.getType() != 16) continue;
            this.allUnNamed = false;
        }
        this.message("DAEditProperties.buildPropertyMap: Map contains " + map.size() + " properties.");
        return map;
    }

    private Map getNestedProperties(DPCollection collection, String rpn, List hierarchy) {
        if (collection == null) {
            return Collections.EMPTY_MAP;
        }
        hierarchy.add(collection);
        if (rpn == null) {
            return this.buildPropertyMap(collection);
        }
        String name = this.getHead(rpn);
        collection = collection instanceof DPProperties ? (DPCollection)((DPProperties)collection).get(name, false) : (DPCollection)collection.get(name);
        return this.getNestedProperties(collection, this.getFollowing(rpn, name), hierarchy);
    }

    public String getChannelName() {
        return this.getTail(this.fqcn);
    }

    public String getProviderName() {
        return this.providerName;
    }

    public Set getPropertyNames() {
        return this.propertiesMap.keySet();
    }

    public Set getBasicPropertyNames() {
        Set names = this.propertiesMap.keySet();
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!this.isAdvanced(name)) continue;
            iter.remove();
        }
        return names;
    }

    public Set getAdvancePropertyNames() {
        Set names = this.propertiesMap.keySet();
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (this.isAdvanced(name)) continue;
            iter.remove();
        }
        return names;
    }

    public void setProperties(Map nameVals) throws DAConsoleException {
        Set names = nameVals.keySet();
        Iterator iter = names.iterator();
        Set allNames = this.getPropertyNames();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            String stringValue = (String)nameVals.get(name);
            Object value = null;
            short type = this.getType(name);
            switch (type) {
                case 1: {
                    value = stringValue;
                    break;
                }
                case 3: {
                    try {
                        value = new Integer(stringValue);
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        throw new DAConsoleException(3, (Throwable)nfe);
                    }
                }
                case 4: {
                    value = new Boolean(stringValue);
                    break;
                }
                default: {
                    throw new DAConsoleException(4, "Unknown type");
                }
            }
            DPProperty property = (DPProperty)this.propertiesMap.get(name);
            if (!property.isNamed() && allNames.contains(stringValue)) {
                throw new DAConsoleException(15, "Invalid value for unnamed property");
            }
            if (this.isDefault(name)) {
                DPCollection collection = this.customizeCollectionsTree();
                if (collection == null) {
                    this.error("DAEditPropertiesModelImpl.setProperties: customizeCollectionsTree returned null.");
                    throw new DAConsoleException(0, "Default collection could not be customized.");
                }
                boolean advanced = property.isAdvanced();
                if ((property = collection.add(property)) == null) {
                    this.error("DAEditPropertiesModelImpl.setProperties: collection.add returned null property.");
                    throw new DAConsoleException(0, "Property could not be added to customized collection");
                }
                if (advanced) {
                    property.setAdvanced(true);
                }
                this.providerPropertyNames.remove(name);
                this.propertiesMap.remove(name);
                this.propertiesMap.put(name, property);
                this.message("DAEditPropertiesModelImpl.setProperties: Customized the default property " + name);
            }
            if (property.isAdvanced()) {
                property.setAdvanced(true);
            }
            property.setValue(value);
            this.message("DAEditPropertiesModelImpl.setProperties: Set property " + name + " = " + stringValue);
        }
        this.store();
    }

    protected DPCollection customizeCollectionsTree() {
        int i = this.channelCollections.size() - 1;
        int j = this.providerCollections.size() - 1;
        DPCollection cCollection = (DPCollection)this.channelCollections.get(i);
        for (int k = i; k < j; ++k) {
            cCollection = (DPCollection)this.channelCollections.get(k);
            DPCollection pCollection = (DPCollection)this.providerCollections.get(k + 1);
            if (pCollection.isAdvanced()) {
                pCollection.setAdvanced(true);
            }
            if (!pCollection.isDummy()) {
                pCollection = (DPCollection)((XMLDPCollection)pCollection).createDummy(this.dpRoot);
            }
            cCollection = (DPCollection)cCollection.add(pCollection);
            this.channelCollections.add(cCollection);
        }
        return cCollection;
    }

    public void removeProperties(Set names) throws DAConsoleException {
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            DPCollection collection = (DPCollection)this.channelCollections.get(this.channelCollections.size() - 1);
            collection.remove(name);
            this.message("DAEditPropertiesModelImpl.removeProperties: Removed property " + name);
        }
        this.store();
        this.initData();
    }

    public String getValue(String name) {
        DPProperty property = (DPProperty)this.propertiesMap.get(name);
        Object value = property == null ? null : property.getValue();
        return value == null ? null : value.toString();
    }

    public short getType(String name) {
        DPProperty property = (DPProperty)this.propertiesMap.get(name);
        return property == null ? (short)-1 : (short)property.getType();
    }

    public boolean isAdvanced(String name) {
        DPProperty property = (DPProperty)this.propertiesMap.get(name);
        return property == null ? false : property.isAdvanced();
    }

    public boolean isNamed(String name) {
        DPProperty property = (DPProperty)this.propertiesMap.get(name);
        return property == null ? false : property.isNamed();
    }

    public boolean isEveryPropertyUnNamed() {
        return this.allUnNamed;
    }

    public boolean isCustomized(String name) {
        DPProperty property = (DPProperty)this.propertiesMap.get(name);
        return !this.isDefault(name) && property != null && !property.isDummy();
    }

    public boolean isInherited(String name) {
        return !this.isDefault(name) && !this.isCustomized(name);
    }

    public boolean isDefault(String name) {
        return this.providerPropertyNames.contains(name);
    }

    public boolean isNested() {
        return this.rpn != null;
    }

    public String[][] getCollectionPath(String fqcn, String rpn) {
        StringTokenizer st = new StringTokenizer(rpn == null ? "" : rpn, "/");
        int nTokens = st.countTokens();
        String[][] tokens = new String[nTokens + 1][2 * (nTokens + 1)];
        tokens[0][0] = this.getTail(fqcn);
        tokens[0][1] = "";
        int i = 1;
        while (st.hasMoreTokens()) {
            String label = st.nextToken();
            tokens[i][0] = this.getNestedPropertyName(label);
            String value = this.getPreceding(rpn, label);
            value = value == null ? label : value + "/" + label;
            tokens[i][1] = value;
            ++i;
        }
        return tokens;
    }

    public String getNestedPropertyName(String name) {
        if (name != null && name.startsWith("_conditional_")) {
            name = name.substring("_conditional_".length());
            name = name.replace('_', '=');
        }
        return name;
    }

    public String getShortName(String fqcn) {
        return this.getTail(fqcn);
    }
}

