/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.PerfThreadLocalizer;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.desktop.context.DesktopContext;
import com.sun.portal.desktop.context.DesktopContextFactory;
import com.sun.portal.desktop.context.DesktopContextThreadLocalizer;
import com.sun.portal.desktop.context.PSContextConstants;
import com.sun.portal.desktop.context.ProviderContextThreadLocalizer;
import com.sun.portal.desktop.context.SessionEvent;
import com.sun.portal.desktop.context.SessionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class PSDesktopContextFactory
implements DesktopContextFactory,
SessionListener,
PSContextConstants {
    private static final long REAP_INTERVAL = 300000L;
    private HashMap desktopContexts = new HashMap();
    private DesktopContextReaper dcReaper = null;
    protected DesktopAppContext desktopAppContext = null;
    protected ServletContext initConfig = null;

    public void init(ServletContext sc) {
        this.initConfig = sc;
        this.initDesktopAppContext();
        this.dcReaper = new DesktopContextReaper(this.desktopContexts, 300000L);
    }

    public DesktopAppContext getDesktopAppContext() {
        if (this.desktopAppContext == null) {
            throw new ContextError("PSDesktopContextFactory.getDesktopAppContext(): not initialized");
        }
        DesktopAppContextThreadLocalizer.set(this.desktopAppContext);
        return this.desktopAppContext;
    }

    protected synchronized void initDesktopAppContext() {
        String desktopAppContextClassName = this.initConfig.getInitParameter("desktop.appContextClassName");
        if (desktopAppContextClassName == null) {
            throw new ContextError("PSDesktopContextFactory.getDesktopAppContext(): could not get desktop app context class name");
        }
        try {
            this.desktopAppContext = (DesktopAppContext)Class.forName(desktopAppContextClassName).newInstance();
            this.desktopAppContext.init(this.initConfig);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ContextError("PSDesktopContextFactory.getDesktopAppContext(): ", cnfe);
        }
        catch (NoClassDefFoundError ncdfe) {
            throw new ContextError("PSDesktopContextFactory.getDesktopAppContext(): ", ncdfe);
        }
        catch (IllegalAccessException iae) {
            throw new ContextError("PSDesktopContextFactory.getDesktopAppContext(): ", iae);
        }
        catch (ClassCastException cce) {
            throw new ContextError("PSDesktopContextFactory.getDesktopAppContext(): ", cce);
        }
        catch (InstantiationException ie) {
            throw new ContextError("PSDesktopContextFactory.getDesktopAppContext(): ", ie);
        }
        catch (SecurityException se) {
            throw new ContextError("PSDesktopContextFactory.getDesktopAppContext(): ", se);
        }
    }

    public synchronized void releaseDesktopContexts(Set sessionIDs) {
        Iterator i = sessionIDs.iterator();
        while (i.hasNext()) {
            String sid = (String)i.next();
            if (!this.desktopContexts.containsKey(sid)) continue;
            this.desktopContexts.remove(sid);
        }
    }

    public DesktopContext getDesktopContext(HttpServletRequest req) {
        return this.getDesktopContext(req, -1);
    }

    public synchronized DesktopContext getDesktopContext(HttpServletRequest req, int expires) {
        return this.getDesktopContext(req, expires, true);
    }

    public synchronized DesktopContext getDesktopContext(HttpServletRequest req, int expires, boolean create) {
        this.dcReaper.reap();
        DesktopContext context = null;
        int i = PerfThreadLocalizer.mark();
        String sid = this.desktopAppContext.getSessionID(req);
        DesktopContextCacheElement dcce = (DesktopContextCacheElement)this.desktopContexts.get(sid);
        if (dcce != null) {
            if (dcce.getDesktopContext().getIsStale()) {
                this.desktopContexts.remove(sid);
            } else {
                context = dcce.getDesktopContext();
            }
        }
        if (context == null && create) {
            String desktopContextClassName = this.desktopAppContext.getDesktopContextClassName();
            try {
                context = (DesktopContext)Class.forName(desktopContextClassName).newInstance();
                context.init(req);
                context.addSessionListener(this);
                dcce = new DesktopContextCacheElement(context, expires);
                this.desktopContexts.put(sid, dcce);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ContextError("PSDesktopContextFactory.getDesktopContext(): ", cnfe);
            }
            catch (NoClassDefFoundError ncdfe) {
                throw new ContextError("PSDesktopContextFactory.getDesktopContext(): ", ncdfe);
            }
            catch (IllegalAccessException iae) {
                throw new ContextError("PSDesktopContextFactory.getDesktopContext(): ", iae);
            }
            catch (ClassCastException cce) {
                throw new ContextError("PSDesktopContextFactory.getDesktopContext(): ", cce);
            }
            catch (InstantiationException ie) {
                throw new ContextError("PSDesktopContextFactory.getDesktopContext(): ", ie);
            }
            catch (SecurityException se) {
                throw new ContextError("PSDesktopContextFactory.getDesktopContext(): ", se);
            }
        }
        if (context != null) {
            context.setLastAccess(System.currentTimeMillis());
            DesktopContextThreadLocalizer.set(context);
            ProviderContextThreadLocalizer.set(context.getContainerProviderContext());
        }
        PerfThreadLocalizer.add(i, "PSDesktopContextFactory.getDesktopContext()");
        return context;
    }

    public synchronized void sessionDestroyed(SessionEvent se) {
        String sid = se.getSessionID();
        this.desktopContexts.remove(sid);
    }

    private class DesktopContextReaper {
        private Map desktopContexts = null;
        private long reapInterval;
        private long lastReap = -1L;

        public DesktopContextReaper(Map desktopContexts, long reapInterval) {
            this.desktopContexts = desktopContexts;
            this.reapInterval = reapInterval;
        }

        public void reap() {
            long now = System.currentTimeMillis();
            if (now > this.lastReap + this.reapInterval) {
                String sid;
                this.lastReap = now;
                PSDesktopContextFactory.this.getDesktopAppContext().debugMessage("DesktopContextReaper.reap(): reaping ...");
                HashSet<String> removeKeys = new HashSet<String>();
                Iterator<Object> i = this.desktopContexts.keySet().iterator();
                while (i.hasNext()) {
                    sid = (String)i.next();
                    DesktopContextCacheElement dcce = (DesktopContextCacheElement)this.desktopContexts.get(sid);
                    if (dcce.getExpiresTime() == -1L || now <= dcce.getExpiresTime()) continue;
                    removeKeys.add(sid);
                }
                i = removeKeys.iterator();
                while (i.hasNext()) {
                    sid = (String)i.next();
                    this.desktopContexts.remove(sid);
                    PSDesktopContextFactory.this.getDesktopAppContext().debugMessage("DesktopContextReaper.reap(): removed sid=" + sid);
                }
            }
        }
    }

    private static class DesktopContextCacheElement {
        private DesktopContext desktopContext = null;
        private long expiresTime = -1L;

        private DesktopContextCacheElement() {
        }

        public DesktopContextCacheElement(DesktopContext desktopContext, int expires) {
            this.desktopContext = desktopContext;
            if (expires != -1) {
                this.expiresTime = System.currentTimeMillis() + (long)(expires * 1000);
            }
        }

        public DesktopContextCacheElement(DesktopContext desktopContext) {
            this(desktopContext, -1);
        }

        public DesktopContext getDesktopContext() {
            return this.desktopContext;
        }

        public long getExpiresTime() {
            return this.expiresTime;
        }
    }
}

