/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.context.ClientContext;
import com.sun.portal.desktop.context.ContextError;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class PropertiesClientContext
implements ClientContext {
    protected Properties properties = new Properties();
    protected static final String DEFAULTCLIENTTYPE_KEY = "defaultClientType";
    protected static final String CONTENTTYPE_KEY = "contentType";
    protected static final String CLIENTPATH_KEY = "clientPath";
    protected static final String CLIENTTYPE_KEY = "clientType";
    protected static final String CHARSET_KEY = "charset";
    protected static final String AUTHLESSSTATE_KEY = "authlessState";
    protected static final String ENCODERCLASSNAME_KEY = "encoderClassName";
    private static final String PROPS_KEY_COOKIE_SUPPORT = "cookieSupport";
    private static final String PROPS_COOKIE_SUPPORT_TRUE = "true";
    private static final String PROPS_COOKIE_SUPPORT_FALSE = "false";
    protected static final String DEFAULT_FILENAME = "/etc/opt/SUNWps/client-context.properties";
    private static Map AUTHLESS_STATES = null;

    public PropertiesClientContext() {
        this(DEFAULT_FILENAME);
    }

    public PropertiesClientContext(String filename) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(filename));
            this.properties.load(fis);
        }
        catch (IOException ioe) {
            throw new ContextError("PropertiesClientContext(): ", ioe);
        }
    }

    public void init() {
    }

    public String getContentType(String clientType) {
        return this.properties.getProperty(CONTENTTYPE_KEY);
    }

    public String getClientPath(String clientType) {
        return this.properties.getProperty(CLIENTPATH_KEY);
    }

    public String getClientType(HttpServletRequest req) {
        return this.properties.getProperty(CLIENTTYPE_KEY);
    }

    public String getDefaultClientType() {
        return this.properties.getProperty(DEFAULTCLIENTTYPE_KEY);
    }

    public String getClientTypeProperty(String clientType, String key) {
        return this.properties.getProperty(key);
    }

    public Set getClientTypeProperties(String clientType, String key) {
        HashSet<String> p = new HashSet<String>();
        p.add(this.properties.getProperty(key));
        return p;
    }

    public String getCharset(String clientType, Locale locale) {
        return this.properties.getProperty(CHARSET_KEY);
    }

    public short getCookieSupport(String clientType) {
        String cookieSupport = this.properties.getProperty(PROPS_KEY_COOKIE_SUPPORT);
        int retval = 2;
        if (cookieSupport != null) {
            retval = cookieSupport.equalsIgnoreCase(PROPS_COOKIE_SUPPORT_TRUE) ? 1 : (cookieSupport.equalsIgnoreCase(PROPS_COOKIE_SUPPORT_FALSE) ? 0 : 2);
        }
        return (short)retval;
    }

    public String getEncoderClassName(String clientType) {
        String cn = this.properties.getProperty(ENCODERCLASSNAME_KEY);
        if (cn != null && cn.length() != 0) {
            return cn;
        }
        return "com.sun.portal.desktop.encode.HTMLEncoder";
    }

    private short getDefaultAuthlessState(String clientType) {
        boolean genericHTML = false;
        String property = this.getClientTypeProperty(clientType, "genericHTML");
        if (property != null) {
            genericHTML = property.equals(PROPS_COOKIE_SUPPORT_TRUE);
        } else if (clientType.equals("genericHTML")) {
            genericHTML = true;
        }
        if (genericHTML) {
            return 2;
        }
        return 3;
    }

    public short getAuthlessState(String clientType) {
        String authlessState = this.properties.getProperty(AUTHLESSSTATE_KEY);
        if (authlessState == null || authlessState.length() == 0) {
            return this.getDefaultAuthlessState(clientType);
        }
        Short as = (Short)AUTHLESS_STATES.get(authlessState);
        if (as == null) {
            return this.getDefaultAuthlessState(clientType);
        }
        return as;
    }

    static {
        AUTHLESS_STATES = new HashMap();
        AUTHLESS_STATES.put("none", new Short(3));
        AUTHLESS_STATES.put("server", new Short(1));
        AUTHLESS_STATES.put("client", new Short(2));
    }
}

