/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mirror;

import com.sun.faces.mirror.DeclaredClassInfo;
import com.sun.mirror.declaration.ClassDeclaration;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclaredComponentInfo
extends DeclaredClassInfo {
    static final String TYPE = "type";
    static final String FAMILY = "family";
    static final String DISPLAY_NAME = "displayName";
    static final String INSTANCE_NAME = "instanceName";
    static final String TAG_NAME = "tagName";
    static final String TAG_RENDERER_TYPE = "tagRendererType";
    static final String SHORT_DESCRIPTION = "shortDescription";
    static final String HELP_KEY = "helpKey";
    static final String IS_CONTAINER = "isContainer";
    static final String IS_TAG = "isTag";
    static final String PROPERTIES_HELP_KEY = "propertiesHelpKey";
    Map<String, Object> annotationValueMap;
    private String tagRendererType;
    private ClassDeclaration tagClassDeclaration;
    private String tagDescription;

    DeclaredComponentInfo(Map<String, Object> annotationValueMap, ClassDeclaration decl) {
        super(decl);
        this.annotationValueMap = annotationValueMap;
    }

    public String getType() {
        String type = (String)this.annotationValueMap.get(TYPE);
        if (type == null) {
            type = this.decl.getQualifiedName();
        }
        return type;
    }

    public String getFamily() {
        String family = (String)this.annotationValueMap.get(FAMILY);
        if (family == null) {
            family = this.getType();
        }
        return family;
    }

    public String getShortDescription() {
        String shortDescription = (String)this.annotationValueMap.get(SHORT_DESCRIPTION);
        if (shortDescription == null) {
            String comment = this.getDocComment();
            if (comment == null || comment.trim().length() == 0) {
                shortDescription = this.getDisplayName();
            } else {
                int index;
                char[] chars = comment.toCharArray();
                StringBuffer buffer = new StringBuffer();
                for (index = 0; index < chars.length && Character.isSpaceChar(chars[index]); ++index) {
                }
                while (index < chars.length) {
                    if (chars[index] == '<') {
                        ++index;
                        while (index < chars.length && chars[index] != '>') {
                            ++index;
                        }
                    } else if (chars[index] == '\n') {
                        buffer.append(" ");
                    } else if (chars[index] == '\"') {
                        buffer.append("&quot;");
                    } else if (chars[index] == '.') {
                        if (index == chars.length - 1 || Character.isSpaceChar(chars[index + 1])) break;
                        buffer.append('.');
                    } else {
                        buffer.append(chars[index]);
                    }
                    ++index;
                }
                shortDescription = buffer.toString();
            }
        }
        return shortDescription;
    }

    public String getDisplayName() {
        String displayName = (String)this.annotationValueMap.get(DISPLAY_NAME);
        if (displayName == null) {
            displayName = this.decl.getSimpleName();
        }
        return displayName;
    }

    public String getInstanceName() {
        String instanceName = (String)this.annotationValueMap.get(INSTANCE_NAME);
        if (instanceName == null) {
            String name = this.decl.getSimpleName();
            instanceName = name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return instanceName;
    }

    public boolean isTag() {
        Boolean isTag = (Boolean)this.annotationValueMap.get(IS_TAG);
        if (isTag == null) {
            return true;
        }
        return isTag;
    }

    public String getTagName() {
        String tagName = (String)this.annotationValueMap.get(TAG_NAME);
        if (tagName == null) {
            tagName = this.getInstanceName();
        }
        return tagName;
    }

    public String getTagRendererType() {
        if (this.tagRendererType == null) {
            return (String)this.annotationValueMap.get(TAG_RENDERER_TYPE);
        }
        return this.tagRendererType;
    }

    void setTagRendererType(String tagRendererType) {
        this.tagRendererType = tagRendererType;
    }

    public ClassDeclaration getTagClassDeclaration() {
        return this.tagClassDeclaration;
    }

    void setTagClassDeclaration(ClassDeclaration tagClassDeclaration) {
        this.tagClassDeclaration = tagClassDeclaration;
    }

    public String getTagClassQualifiedName() {
        ClassDeclaration tagClassDecl = this.getTagClassDeclaration();
        if (tagClassDecl == null) {
            return this.getQualifiedName() + "Tag";
        }
        return tagClassDecl.getQualifiedName();
    }

    public String getTagDescription() {
        if (this.tagDescription == null) {
            return this.getDocComment();
        }
        return this.tagDescription;
    }

    void setTagDescription(String tagDescription) {
        this.tagDescription = tagDescription;
    }

    public String getHelpKey() {
        String helpKey = (String)this.annotationValueMap.get(HELP_KEY);
        return helpKey == null ? "" : helpKey;
    }

    public String getPropertiesHelpKey() {
        String propertiesHelpKey = (String)this.annotationValueMap.get(PROPERTIES_HELP_KEY);
        return propertiesHelpKey == null ? "" : propertiesHelpKey;
    }

    public Boolean isContainer() {
        return Boolean.TRUE.equals(this.annotationValueMap.get(IS_CONTAINER)) ? Boolean.TRUE : Boolean.FALSE;
    }
}

