/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mirror;

import com.sun.faces.mirror.AttributeInfo;
import com.sun.faces.mirror.CategoryInfo;
import com.sun.faces.mirror.DeclaredAttributeInfo;
import com.sun.faces.mirror.PropertyInfo;
import com.sun.mirror.declaration.Declaration;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclaredPropertyInfo
extends PropertyInfo {
    static final String NAME = "name";
    static final String DISPLAY_NAME = "displayName";
    static final String SHORT_DESCRIPTION = "shortDescription";
    static final String EDITOR_CLASS_NAME = "editorClassName";
    static final String HELP_KEY = "helpKey";
    static final String CATEGORY = "category";
    static final String IS_DEFAULT = "isDefault";
    static final String IS_ATTRIBUTE = "isAttribute";
    static final String IS_HIDDEN = "isHidden";
    static final String ATTRIBUTE = "attribute";
    static final String READ_METHOD_NAME = "readMethodName";
    static final String WRITE_METHOD_NAME = "writeMethodName";
    Declaration decl;
    Map<String, Object> annotationValueMap;
    private String name;
    private String type;
    private String writeMethodName;
    private String readMethodName;
    private CategoryInfo categoryInfo;
    private AttributeInfo attributeInfo;

    DeclaredPropertyInfo(Map<String, Object> annotationValueMap, Declaration decl) {
        this.annotationValueMap = annotationValueMap;
        this.decl = decl;
    }

    public Declaration getDeclaration() {
        return this.decl;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    @Override
    public String getInstanceName() {
        String name = this.getName();
        if (PropertyInfo.JAVA_KEYWORD_PATTERN.matcher(name).matches()) {
            return "_" + name;
        }
        return name;
    }

    @Override
    public String getDisplayName() {
        String displayName = (String)this.annotationValueMap.get(DISPLAY_NAME);
        if (displayName == null) {
            displayName = this.getName();
        }
        return displayName;
    }

    @Override
    public String getShortDescription() {
        String shortDescription = (String)this.annotationValueMap.get(SHORT_DESCRIPTION);
        if (shortDescription == null) {
            String comment = this.getDocComment();
            if (comment == null || comment.trim().length() == 0) {
                shortDescription = this.getDisplayName();
            } else {
                int index;
                char[] chars = comment.toCharArray();
                StringBuffer buffer = new StringBuffer();
                for (index = 0; index < chars.length && Character.isSpaceChar(chars[index]); ++index) {
                }
                while (index < chars.length) {
                    if (chars[index] == '<') {
                        ++index;
                        while (index < chars.length && chars[index] != '>') {
                            ++index;
                        }
                    } else if (chars[index] == '\n') {
                        buffer.append(" ");
                    } else if (chars[index] == '\"') {
                        buffer.append("&quot;");
                    } else if (chars[index] == '.') {
                        if (index == chars.length - 1 || Character.isSpaceChar(chars[index + 1])) break;
                        buffer.append('.');
                    } else {
                        buffer.append(chars[index]);
                    }
                    ++index;
                }
                shortDescription = buffer.toString();
            }
        }
        return shortDescription;
    }

    @Override
    public String getType() {
        return this.type;
    }

    void setType(String type) {
        this.type = type;
    }

    @Override
    public String getWriteMethodName() {
        String methodName = this.writeMethodName;
        if (methodName == null) {
            methodName = (String)this.annotationValueMap.get(WRITE_METHOD_NAME);
        }
        return methodName;
    }

    void setWriteMethodName(String writeMethodName) {
        this.writeMethodName = writeMethodName;
    }

    @Override
    public String getReadMethodName() {
        String methodName = this.readMethodName;
        if (methodName == null) {
            methodName = (String)this.annotationValueMap.get(READ_METHOD_NAME);
        }
        return methodName;
    }

    void setReadMethodName(String readMethodName) {
        this.readMethodName = readMethodName;
    }

    @Override
    public String getEditorClassName() {
        return (String)this.annotationValueMap.get(EDITOR_CLASS_NAME);
    }

    @Override
    public boolean isHidden() {
        if (this.annotationValueMap.containsKey(IS_HIDDEN)) {
            return (Boolean)this.annotationValueMap.get(IS_HIDDEN);
        }
        return false;
    }

    @Override
    public CategoryInfo getCategoryInfo() {
        return this.categoryInfo;
    }

    void setCategoryInfo(CategoryInfo categoryInfo) {
        this.categoryInfo = categoryInfo;
    }

    @Override
    String getCategoryReferenceName() {
        return (String)this.annotationValueMap.get(CATEGORY);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PropertyInfo)) {
            return false;
        }
        PropertyInfo that = (PropertyInfo)obj;
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        String thisReadName = this.getReadMethodName();
        String thatReadName = that.getReadMethodName();
        if (!(thisReadName == null || thatReadName != null && thatReadName.equals(thisReadName))) {
            return false;
        }
        if (thatReadName == null && thatReadName != null) {
            return false;
        }
        String thisWriteName = this.getReadMethodName();
        String thatWriteName = that.getReadMethodName();
        if (!(thisWriteName == null || thatWriteName != null && thatWriteName.equals(thisWriteName))) {
            return false;
        }
        return thatWriteName != null || thatWriteName == null;
    }

    @Override
    public AttributeInfo getAttributeInfo() {
        if (this.attributeInfo == null) {
            if (Boolean.FALSE.equals(this.annotationValueMap.get(IS_ATTRIBUTE))) {
                return null;
            }
            this.attributeInfo = this.annotationValueMap.containsKey(ATTRIBUTE) ? new DeclaredAttributeInfo((Map)this.annotationValueMap.get(ATTRIBUTE), this) : new DeclaredAttributeInfo(this);
        }
        return this.attributeInfo;
    }

    void setAttributeInfo(AttributeInfo attributeInfo) {
        this.attributeInfo = attributeInfo;
    }

    void updateInheritedValues(PropertyInfo propertyInfo) {
        if (!this.annotationValueMap.containsKey(DISPLAY_NAME)) {
            this.annotationValueMap.put(DISPLAY_NAME, propertyInfo.getDisplayName());
        }
        if (!this.annotationValueMap.containsKey(SHORT_DESCRIPTION) && this.getDocComment() == null) {
            this.annotationValueMap.put(SHORT_DESCRIPTION, propertyInfo.getShortDescription());
        }
        if (!this.annotationValueMap.containsKey(EDITOR_CLASS_NAME)) {
            this.annotationValueMap.put(EDITOR_CLASS_NAME, propertyInfo.getEditorClassName());
        }
        if (!this.annotationValueMap.containsKey(IS_HIDDEN)) {
            this.annotationValueMap.put(IS_HIDDEN, propertyInfo.isHidden());
        }
        if (!this.annotationValueMap.containsKey(CATEGORY)) {
            this.annotationValueMap.put(CATEGORY, propertyInfo.getCategoryReferenceName());
        }
        if (!this.annotationValueMap.containsKey(IS_ATTRIBUTE)) {
            AttributeInfo attributeInfo = propertyInfo.getAttributeInfo();
            if (attributeInfo == null) {
                this.annotationValueMap.put(IS_ATTRIBUTE, Boolean.FALSE);
                this.attributeInfo = null;
            } else {
                this.annotationValueMap.put(IS_ATTRIBUTE, Boolean.TRUE);
                this.attributeInfo = new DeclaredAttributeInfo(attributeInfo);
                if (this.getDocComment() != null) {
                    ((DeclaredAttributeInfo)this.attributeInfo).setDescription(this.getDocComment());
                }
            }
        }
        if (this.getReadMethodName() == null) {
            this.setReadMethodName(propertyInfo.getReadMethodName());
        }
        if (this.getWriteMethodName() == null) {
            this.setWriteMethodName(propertyInfo.getWriteMethodName());
        }
        if (this.getCategoryInfo() == null && this.getCategoryReferenceName() != null) {
            this.setCategoryInfo(propertyInfo.getCategoryInfo());
        }
    }

    public String getDocComment() {
        return this.getDeclaration().getDocComment();
    }
}

