/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mirror;

import com.sun.faces.mirror.ClassInfo;
import com.sun.faces.mirror.DeclaredEventInfo;
import com.sun.faces.mirror.DeclaredPropertyInfo;
import com.sun.faces.mirror.EventInfo;
import com.sun.faces.mirror.PropertyInfo;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.InterfaceType;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeclaredTypeInfo
extends ClassInfo {
    TypeDeclaration decl;
    private String className;
    private String packageName;
    private ClassInfo superClassInfo;
    Map<String, PropertyInfo> propertyInfoMap;
    Map<String, EventInfo> eventInfoMap;
    private PropertyInfo defaultPropertyInfo;
    private EventInfo defaultEventInfo;
    Set<String> methodNameSet;

    DeclaredTypeInfo(TypeDeclaration decl) {
        this.decl = decl;
        String qualifiedName = this.decl.getQualifiedName();
        int index = qualifiedName.lastIndexOf(46);
        if (index >= 0) {
            this.className = qualifiedName.substring(index + 1);
            this.packageName = qualifiedName.substring(0, index);
        } else {
            this.className = qualifiedName;
            this.packageName = null;
        }
    }

    public TypeDeclaration getDeclaration() {
        return this.decl;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public ClassInfo getSuperClassInfo() {
        return this.superClassInfo;
    }

    void setSuperClassInfo(ClassInfo classInfo) {
        this.superClassInfo = classInfo;
    }

    @Override
    public boolean isAssignableTo(String qualifiedName) {
        TypeDeclaration decl = this.getDeclaration();
        if (decl.getQualifiedName().equals(qualifiedName)) {
            return true;
        }
        for (InterfaceType interfaceType : decl.getSuperinterfaces()) {
            if (!interfaceType.getDeclaration().getQualifiedName().equals(qualifiedName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, PropertyInfo> getPropertyInfoMap() {
        return this.propertyInfoMap;
    }

    void setPropertyInfoMap(Map<String, PropertyInfo> propertyInfoMap) {
        this.propertyInfoMap = propertyInfoMap;
        for (PropertyInfo propertyInfo : propertyInfoMap.values()) {
            DeclaredPropertyInfo declaredPropertyInfo = (DeclaredPropertyInfo)propertyInfo;
            declaredPropertyInfo.setDeclaringClassInfo(this);
            if (!Boolean.TRUE.equals(declaredPropertyInfo.annotationValueMap.get("isDefault"))) continue;
            this.setDefaultPropertyInfo(declaredPropertyInfo);
        }
    }

    @Override
    public Map<String, EventInfo> getEventInfoMap() {
        return this.eventInfoMap;
    }

    void setEventInfoMap(Map<String, EventInfo> eventInfoMap) {
        this.eventInfoMap = eventInfoMap;
        for (EventInfo eventInfo : eventInfoMap.values()) {
            DeclaredEventInfo declaredEventInfo = (DeclaredEventInfo)eventInfo;
            declaredEventInfo.setDeclaringClassInfo(this);
            if (!Boolean.TRUE.equals(declaredEventInfo.annotationValueMap.get("isDefault"))) continue;
            this.setDefaultEventInfo(declaredEventInfo);
        }
    }

    @Override
    public PropertyInfo getDefaultPropertyInfo() {
        return this.defaultPropertyInfo;
    }

    void setDefaultPropertyInfo(PropertyInfo defaultPropertyInfo) {
        this.defaultPropertyInfo = defaultPropertyInfo;
    }

    @Override
    public EventInfo getDefaultEventInfo() {
        return this.defaultEventInfo;
    }

    void setDefaultEventInfo(EventInfo defaultEventInfo) {
        this.defaultEventInfo = defaultEventInfo;
    }

    @Override
    Set<String> getMethodNameSet() {
        if (this.methodNameSet == null) {
            this.methodNameSet = new HashSet<String>();
            for (MethodDeclaration decl : this.decl.getMethods()) {
                this.methodNameSet.add(decl.getSimpleName());
            }
        }
        return this.methodNameSet;
    }

    public String getDocComment() {
        return this.getDeclaration().getDocComment();
    }
}

