/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mirror.generator;

import com.sun.faces.mirror.CategoryInfo;
import com.sun.faces.mirror.ClassInfo;
import com.sun.faces.mirror.DeclaredComponentInfo;
import com.sun.faces.mirror.EventInfo;
import com.sun.faces.mirror.PropertyBundleMap;
import com.sun.faces.mirror.PropertyInfo;
import com.sun.faces.mirror.generator.BeanInfoSourceGenerator;
import com.sun.faces.mirror.generator.GeneratorException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TreeSet;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

class BeanInfoSourceGeneratorImpl
extends BeanInfoSourceGenerator {
    static final String TEMPLATE = "com/sun/faces/mirror/generator/BeanInfoSource.template";
    VelocityEngine velocityEngine;

    public BeanInfoSourceGeneratorImpl(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public void generate() throws GeneratorException {
        try {
            DeclaredComponentInfo componentInfo = this.getDeclaredComponentInfo();
            String namespace = this.getNamespace();
            String namespacePrefix = this.getNamespacePrefix();
            VelocityContext velocityContext = new VelocityContext();
            ClassInfo superClassInfo = componentInfo.getSuperClassInfo();
            ArrayList<PropertyInfo> propertyInfos = new ArrayList<PropertyInfo>();
            propertyInfos.addAll(componentInfo.getPropertyInfoMap().values());
            ArrayList<EventInfo> eventInfos = new ArrayList<EventInfo>();
            eventInfos.addAll(componentInfo.getEventInfoMap().values());
            if (superClassInfo != null) {
                if (DeclaredComponentInfo.class.isAssignableFrom(superClassInfo.getClass())) {
                    DeclaredComponentInfo declaredSuperClassInfo = (DeclaredComponentInfo)superClassInfo;
                    if (declaredSuperClassInfo.getPropertyInfoMap().size() > 0 || declaredSuperClassInfo.getInheritedPropertyInfoMap().size() > 0) {
                        velocityContext.put("fetchSuperClassPropertyInfo", (Object)Boolean.TRUE);
                    }
                    if (declaredSuperClassInfo.getEventInfoMap().size() > 0 || declaredSuperClassInfo.getInheritedEventInfoMap().size() > 0) {
                        velocityContext.put("fetchSuperClassEventInfo", (Object)Boolean.TRUE);
                    }
                } else {
                    propertyInfos.addAll(componentInfo.getInheritedPropertyInfoMap().values());
                    eventInfos.addAll(componentInfo.getInheritedEventInfoMap().values());
                }
            }
            TreeSet<CategoryInfo> categoryInfoSet = new TreeSet<CategoryInfo>();
            for (ClassInfo classInfo = componentInfo; classInfo != null; classInfo = ((ClassInfo)classInfo).getSuperClassInfo()) {
                for (PropertyInfo propertyInfo : ((ClassInfo)classInfo).getPropertyInfoMap().values()) {
                    CategoryInfo categoryInfo = propertyInfo.getCategoryInfo();
                    if (categoryInfo == null) continue;
                    categoryInfoSet.add(categoryInfo);
                }
            }
            if (this.getPropertyBundleMap() != null) {
                PropertyBundleMap propertyBundleMap = this.getPropertyBundleMap();
                propertyBundleMap.put(componentInfo.getKey("displayName"), componentInfo.getDisplayName());
                propertyBundleMap.put(componentInfo.getKey("shortDescription"), componentInfo.getShortDescription());
                for (PropertyInfo propertyInfo : componentInfo.getPropertyInfoMap().values()) {
                    propertyBundleMap.put(propertyInfo.getKey("displayName"), propertyInfo.getDisplayName());
                    propertyBundleMap.put(propertyInfo.getKey("shortDescription"), propertyInfo.getShortDescription());
                }
                for (PropertyInfo propertyInfo : componentInfo.getInheritedPropertyInfoMap().values()) {
                    if (propertyInfo.getDeclaringClassInfo() instanceof DeclaredComponentInfo) continue;
                    propertyBundleMap.put(propertyInfo.getKey("displayName"), propertyInfo.getDisplayName());
                    propertyBundleMap.put(propertyInfo.getKey("shortDescription"), propertyInfo.getShortDescription());
                }
                velocityContext.put("resourceBundle", (Object)propertyBundleMap.getQualifiedName());
            }
            velocityContext.put("date", (Object)DateFormat.getDateInstance(2).format(new Date()));
            velocityContext.put("beanInfoPackage", (Object)this.getPackageName());
            velocityContext.put("beanInfoClass", (Object)this.getClassName());
            velocityContext.put("componentInfo", (Object)componentInfo);
            velocityContext.put("propertyInfoSet", propertyInfos);
            velocityContext.put("categoryInfoSet", categoryInfoSet);
            velocityContext.put("eventInfoSet", eventInfos);
            velocityContext.put("namespace", (Object)(namespace == null ? "" : namespace));
            velocityContext.put("namespacePrefix", (Object)(namespacePrefix == null ? "" : namespacePrefix));
            Template template = this.velocityEngine.getTemplate(TEMPLATE);
            PrintWriter printWriter = this.getPrintWriter();
            template.merge((Context)velocityContext, (Writer)printWriter);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GeneratorException(e);
        }
    }

    public String getPackageName() {
        return this.getDeclaredComponentInfo().getPackageName();
    }

    public String getClassName() {
        return this.getDeclaredComponentInfo().getClassName() + "BeanInfoBase";
    }
}

