/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mirror.generator;

import com.sun.faces.mirror.ClassInfo;
import com.sun.faces.mirror.DeclaredComponentInfo;
import com.sun.faces.mirror.DeclaredRendererInfo;
import com.sun.faces.mirror.generator.Generator;
import com.sun.faces.mirror.generator.GeneratorException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugGenerator
extends Generator {
    static final String TEMPLATE = "com/sun/faces/mirror/generator/Debug.template";
    VelocityEngine velocityEngine;
    private String namespace;
    private String namespacePrefix;
    private Set<DeclaredComponentInfo> declaredComponentInfoSet;
    private Set<DeclaredRendererInfo> declaredRendererInfoSet;
    private Set<String> packageNameSet;

    public DebugGenerator(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    @Override
    public void generate() throws GeneratorException {
        try {
            VelocityContext velocityContext = new VelocityContext();
            String namespace = this.getNamespace();
            String namespacePrefix = this.getNamespacePrefix();
            velocityContext.put("packageNameSet", this.getPackageNameSet());
            velocityContext.put("componentInfoSet", this.getDeclaredComponentInfoSet());
            velocityContext.put("rendererInfoSet", this.getDeclaredRendererInfoSet());
            velocityContext.put("namespace", (Object)(namespace == null ? "" : namespace));
            velocityContext.put("namespacePrefix", (Object)(namespacePrefix == null ? "" : namespacePrefix));
            Template template = this.velocityEngine.getTemplate(TEMPLATE);
            PrintWriter printWriter = this.getPrintWriter();
            template.merge((Context)velocityContext, (Writer)printWriter);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GeneratorException(e);
        }
    }

    protected String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    protected String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public void setNamespacePrefix(String namespacePrefix) {
        this.namespacePrefix = namespacePrefix;
    }

    protected Set<DeclaredComponentInfo> getDeclaredComponentInfoSet() {
        TreeSet<DeclaredComponentInfo> sortedSet = new TreeSet<DeclaredComponentInfo>(new ClassInfoComparator());
        sortedSet.addAll(this.declaredComponentInfoSet);
        return sortedSet;
    }

    public void setDeclaredComponentInfoSet(Set<DeclaredComponentInfo> declaredComponentInfoSet) {
        this.declaredComponentInfoSet = declaredComponentInfoSet;
    }

    protected Set<DeclaredRendererInfo> getDeclaredRendererInfoSet() {
        TreeSet<DeclaredRendererInfo> sortedSet = new TreeSet<DeclaredRendererInfo>(new ClassInfoComparator());
        sortedSet.addAll(this.declaredRendererInfoSet);
        return sortedSet;
    }

    public void setDeclaredRendererInfoSet(Set<DeclaredRendererInfo> declaredRendererInfoSet) {
        this.declaredRendererInfoSet = declaredRendererInfoSet;
    }

    protected Set<String> getPackageNameSet() {
        TreeSet<String> sortedSet = new TreeSet<String>();
        sortedSet.addAll(this.packageNameSet);
        return sortedSet;
    }

    public void setPackageNameSet(Set<String> packageNameSet) {
        this.packageNameSet = packageNameSet;
    }

    static class ClassInfoComparator
    implements Comparator {
        ClassInfoComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            return ((ClassInfo)obj1).getQualifiedName().compareTo(((ClassInfo)obj2).getClassName());
        }
    }
}

