/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mirror.generator;

import com.sun.faces.mirror.DeclaredComponentInfo;
import com.sun.faces.mirror.generator.GeneratorException;
import com.sun.faces.mirror.generator.TagLibFileGenerator;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.TreeSet;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

class TagLibFileGeneratorImpl
extends TagLibFileGenerator {
    static final String TEMPLATE = "com/sun/faces/mirror/generator/TagLib.template";
    VelocityEngine velocityEngine;

    TagLibFileGeneratorImpl(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public void generate() throws GeneratorException {
        try {
            TreeSet<DeclaredComponentInfo> componentInfoSet = new TreeSet<DeclaredComponentInfo>(new Comparator(){

                public int compare(Object obj1, Object obj2) {
                    String tag1 = ((DeclaredComponentInfo)obj1).getTagName();
                    String tag2 = ((DeclaredComponentInfo)obj2).getTagName();
                    if (tag1 == null) {
                        if (tag2 == null) {
                            return 0;
                        }
                        return -1;
                    }
                    return tag1.compareTo(tag2);
                }
            });
            componentInfoSet.addAll(this.getDeclaredComponentInfoSet());
            String namespace = this.getNamespace();
            String namespacePrefix = this.getNamespacePrefix();
            PrintWriter printWriter = this.getPrintWriter();
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("date", (Object)DateFormat.getDateInstance(2).format(new Date()));
            velocityContext.put("componentInfoSet", componentInfoSet);
            velocityContext.put("namespace", (Object)(namespace == null ? "" : namespace));
            velocityContext.put("namespacePrefix", (Object)(namespacePrefix == null ? "" : namespacePrefix));
            Template template = this.velocityEngine.getTemplate(TEMPLATE);
            template.merge((Context)velocityContext, (Writer)printWriter);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GeneratorException(e);
        }
    }

    public String getFileName() {
        return "taglib.xml";
    }

    public String getDirectoryName() {
        return "META-INF";
    }
}

