/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.BrokenDataShadow;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.DataShadow;
import org.openide.loaders.DefaultDataObject;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.FileEntry;
import org.openide.loaders.InstanceDataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.OperationListener;
import org.openide.loaders.ShadowChangeAdapter;
import org.openide.loaders.UniFileLoader;
import org.openide.loaders.XMLDataObject;
import org.openide.modules.ModuleInfo;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

public abstract class DataLoaderPool
implements Serializable {
    static final long serialVersionUID = -360141823874889956L;
    private static MultiFileLoader[] systemLoaders;
    private static MultiFileLoader[] defaultLoaders;
    private static DataLoaderPool DEFAULT;
    private transient DataLoader[] loaderArray;
    private transient EventListenerList listeners;
    private transient DataLoader preferredLoader;
    private static final DataLoader.RecognizedFiles emptyDataLoaderRecognized;
    static /* synthetic */ Class class$org$openide$loaders$DataLoader;
    static /* synthetic */ Class class$org$openide$actions$OpenAction;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$RenameAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$openide$actions$SaveAsTemplateAction;

    public static synchronized DataLoaderPool getDefault() {
        if (DEFAULT == null && (DEFAULT = (DataLoaderPool)Lookup.getDefault().lookup(DataLoaderPool.class)) == null) {
            DEFAULT = new DefaultPool();
        }
        return DEFAULT;
    }

    protected DataLoaderPool() {
    }

    protected DataLoaderPool(DataLoader loader) {
        this.preferredLoader = loader;
    }

    protected abstract Enumeration loaders();

    public final synchronized void addChangeListener(ChangeListener chl) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(ChangeListener.class, chl);
    }

    public final synchronized void removeChangeListener(ChangeListener chl) {
        if (this.listeners != null) {
            this.listeners.remove(ChangeListener.class, chl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent(ChangeEvent che) {
        Object[] list;
        this.loaderArray = null;
        DataLoaderPool dataLoaderPool = this;
        synchronized (dataLoaderPool) {
            if (this.listeners == null) {
                return;
            }
            list = this.listeners.getListenerList();
        }
        for (int i = list.length - 2; i >= 0; i -= 2) {
            if (list[i] != (class$javax$swing$event$ChangeListener == null ? DataLoaderPool.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ChangeListener l = (ChangeListener)list[i + 1];
            l.stateChanged(che);
        }
    }

    public static OperationListener createWeakOperationListener(OperationListener l, Object s) {
        return (OperationListener)WeakListeners.create((Class)OperationListener.class, (EventListener)l, (Object)s);
    }

    public final synchronized void addOperationListener(OperationListener l) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(OperationListener.class, l);
    }

    public final synchronized void removeOperationListener(OperationListener l) {
        if (this.listeners != null) {
            this.listeners.remove(OperationListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void fireOperationEvent(OperationEvent ev, int type) {
        Object[] list;
        DataLoaderPool dataLoaderPool = this;
        synchronized (dataLoaderPool) {
            if (this.listeners == null) {
                return;
            }
            list = this.listeners.getListenerList();
        }
        block12: for (int i = list.length - 2; i >= 0; i -= 2) {
            if (list[i] != (class$org$openide$loaders$OperationListener == null ? DataLoaderPool.class$("org.openide.loaders.OperationListener") : class$org$openide$loaders$OperationListener)) continue;
            OperationListener l = (OperationListener)list[i + 1];
            switch (type) {
                case 1: {
                    l.operationCopy((OperationEvent.Copy)ev);
                    continue block12;
                }
                case 2: {
                    l.operationMove((OperationEvent.Move)ev);
                    continue block12;
                }
                case 3: {
                    l.operationDelete(ev);
                    continue block12;
                }
                case 4: {
                    l.operationRename((OperationEvent.Rename)ev);
                    continue block12;
                }
                case 5: {
                    l.operationCreateShadow((OperationEvent.Copy)ev);
                    continue block12;
                }
                case 6: {
                    l.operationCreateFromTemplate((OperationEvent.Copy)ev);
                    continue block12;
                }
                case 7: {
                    l.operationPostCreate(ev);
                }
            }
        }
    }

    public final Enumeration allLoaders() {
        if (this.preferredLoader == null) {
            return Enumerations.concat((Enumeration)Enumerations.array((Object[])new Enumeration[]{Enumerations.array((Object[])DataLoaderPool.getSystemLoaders()), this.loaders(), Enumerations.array((Object[])DataLoaderPool.getDefaultLoaders())}));
        }
        return Enumerations.concat((Enumeration)Enumerations.array((Object[])new Enumeration[]{Enumerations.singleton((Object)((Object)this.preferredLoader)), Enumerations.array((Object[])DataLoaderPool.getSystemLoaders()), this.loaders(), Enumerations.array((Object[])DataLoaderPool.getDefaultLoaders())}));
    }

    public DataLoader[] toArray() {
        DataLoader[] localArray = this.loaderArray;
        if (localArray != null) {
            return localArray;
        }
        ArrayList loaders = new ArrayList();
        Enumeration en = this.loaders();
        while (en.hasMoreElements()) {
            loaders.add(en.nextElement());
        }
        localArray = new DataLoader[loaders.size()];
        localArray = loaders.toArray(localArray);
        this.loaderArray = localArray;
        return localArray;
    }

    public final DataLoader firstProducerOf(Class clazz) {
        Enumeration en = this.allLoaders();
        while (en.hasMoreElements()) {
            DataLoader dl = (DataLoader)((Object)en.nextElement());
            if (!dl.getRepresentationClass().isAssignableFrom(clazz)) continue;
            return dl;
        }
        return null;
    }

    public final Enumeration producersOf(Class clazz) {
        class ProducerOf
        implements Enumerations.Processor {
            private final /* synthetic */ Class val$clazz;

            ProducerOf(Class val$clazz) {
                this.val$clazz = val$clazz;
            }

            public Object process(Object o, Collection ignore) {
                DataLoader dl = (DataLoader)((Object)o);
                return this.val$clazz.isAssignableFrom(dl.getRepresentationClass()) ? o : null;
            }
        }
        return Enumerations.filter((Enumeration)this.allLoaders(), (Enumerations.Processor)new ProducerOf(clazz));
    }

    public DataObject findDataObject(FileObject fo) throws IOException {
        return this.findDataObject(fo, emptyDataLoaderRecognized);
    }

    public DataObject findDataObject(FileObject fo, DataLoader.RecognizedFiles r) throws IOException {
        DataObject obj;
        DataLoader pref = DataLoaderPool.getPreferredLoader(fo);
        if (pref != null && (obj = pref.findDataObject(fo, r)) != null) {
            return obj;
        }
        Enumeration en = this.allLoaders();
        while (en.hasMoreElements()) {
            DataLoader l = (DataLoader)((Object)en.nextElement());
            DataObject obj2 = l.findDataObject(fo, r);
            if (obj2 == null) continue;
            return obj2;
        }
        return null;
    }

    public static void setPreferredLoader(FileObject fo, DataLoader loader) throws IOException {
        DataLoader prev = DataLoaderPool.getPreferredLoader(fo);
        if (prev == loader) {
            return;
        }
        if (loader == null) {
            fo.setAttribute("NetBeansAttrAssignedLoader", null);
        } else {
            Class<?> c = ((Object)((Object)loader)).getClass();
            Iterator modules = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class)).allInstances().iterator();
            String modulename = null;
            while (modules.hasNext()) {
                ModuleInfo module = (ModuleInfo)modules.next();
                if (!module.owns(c)) continue;
                modulename = module.getCodeNameBase();
                break;
            }
            fo.setAttribute("NetBeansAttrAssignedLoader", (Object)c.getName());
            fo.setAttribute("NetBeansAttrAssignedLoaderModule", modulename);
        }
        HashSet<FileObject> single = new HashSet<FileObject>();
        single.add(fo);
        if (!DataObjectPool.getPOOL().revalidate(single).isEmpty()) {
            ErrorManager.getDefault().log(1, "It was not possible to invalidate data object: " + fo);
        }
    }

    public static DataLoader getPreferredLoader(FileObject fo) {
        String assignedLoaderName = (String)fo.getAttribute("NetBeansAttrAssignedLoader");
        if (assignedLoaderName != null) {
            String modulename = (String)fo.getAttribute("NetBeansAttrAssignedLoaderModule");
            if (modulename != null) {
                Iterator modules = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class)).allInstances().iterator();
                boolean ok = false;
                while (modules.hasNext()) {
                    ModuleInfo module = (ModuleInfo)modules.next();
                    if (!module.getCodeNameBase().equals(modulename)) continue;
                    if (module.isEnabled()) {
                        ok = true;
                        break;
                    }
                    return null;
                }
                if (!ok) {
                    return null;
                }
            }
            try {
                ClassLoader load = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                if (load == null) {
                    load = DataLoaderPool.class.getClassLoader();
                }
                Class<?> loaderClass = Class.forName(assignedLoaderName, true, load);
                return DataLoader.getLoader(loaderClass);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        return null;
    }

    private static MultiFileLoader[] getSystemLoaders() {
        if (systemLoaders == null) {
            systemLoaders = new MultiFileLoader[]{(MultiFileLoader)DataLoader.getLoader(ShadowLoader.class), (MultiFileLoader)DataLoader.getLoader(InstanceLoaderSystem.class)};
        }
        return systemLoaders;
    }

    private static MultiFileLoader[] getDefaultLoaders() {
        if (defaultLoaders == null) {
            defaultLoaders = new MultiFileLoader[]{(MultiFileLoader)DataLoader.getLoader(FolderLoader.class), (MultiFileLoader)DataLoader.getLoader(XMLDataObject.Loader.class), (MultiFileLoader)DataLoader.getLoader(InstanceLoader.class), (MultiFileLoader)DataLoader.getLoader(DefaultLoader.class)};
        }
        return defaultLoaders;
    }

    static MultiFileLoader getDefaultFileLoader() {
        return DataLoaderPool.getDefaultLoaders()[3];
    }

    static MultiFileLoader getFolderLoader() {
        return DataLoaderPool.getDefaultLoaders()[0];
    }

    static MultiFileLoader getShadowLoader() {
        return DataLoaderPool.getSystemLoaders()[0];
    }

    static {
        emptyDataLoaderRecognized = new DataLoader.RecognizedFiles(){

            public void markRecognized(FileObject fo) {
            }
        };
    }

    static final class FolderLoader
    extends UniFileLoader {
        static final long serialVersionUID = -8325525104047820255L;

        public FolderLoader() {
            super("org.openide.loaders.DataFolder");
        }

        protected String actionsContext() {
            return "Loaders/folder/any/Actions";
        }

        protected String defaultDisplayName() {
            return NbBundle.getMessage((Class)(class$org$openide$loaders$DataLoaderPool == null ? (class$org$openide$loaders$DataLoaderPool = DataLoaderPool.class$("org.openide.loaders.DataLoaderPool")) : class$org$openide$loaders$DataLoaderPool), (String)"LBL_folder_loader_display_name");
        }

        protected FileObject findPrimaryFile(FileObject fo) {
            if (fo.isFolder()) {
                return fo;
            }
            return null;
        }

        protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
            return new FileEntry.Folder(obj, primaryFile);
        }

        protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
            return new DataFolder(primaryFile);
        }

        MultiDataObject createMultiObject(FileObject primaryFile, DataFolder original) throws DataObjectExistsException, IOException {
            class NodeSharingDataFolder
            extends DataFolder {
                private final /* synthetic */ DataFolder val$original;
                private final /* synthetic */ FolderLoader this$0;

                public NodeSharingDataFolder(FolderLoader this$0, FileObject fo, DataFolder val$original) throws DataObjectExistsException, IllegalArgumentException {
                    this.this$0 = this$0;
                    this.val$original = val$original;
                    super(fo);
                }

                protected Node createNodeDelegate() {
                    return new FilterNode(this.val$original.getNodeDelegate());
                }

                Node getClonedNodeDelegate(DataFilter filter) {
                    return new FilterNode(this.val$original.getClonedNodeDelegate(filter));
                }
            }
            return new NodeSharingDataFolder(this, primaryFile, original);
        }

        public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
            try {
                super.readExternal(oi);
            }
            catch (OptionalDataException optionalDataException) {
                // empty catch block
            }
        }
    }

    private static final class ShadowLoader
    extends UniFileLoader {
        static final long serialVersionUID = -11013405787959120L;
        private static ShadowChangeAdapter changeAdapter = new ShadowChangeAdapter();

        public ShadowLoader() {
            super("org.openide.loaders.DataShadow");
        }

        protected String defaultDisplayName() {
            return NbBundle.getMessage((Class)(class$org$openide$loaders$DataLoaderPool == null ? (class$org$openide$loaders$DataLoaderPool = DataLoaderPool.class$("org.openide.loaders.DataLoaderPool")) : class$org$openide$loaders$DataLoaderPool), (String)"LBL_shadow_loader_display_name");
        }

        protected FileObject findPrimaryFile(FileObject fo) {
            if (fo.hasExt("shadow")) {
                return fo;
            }
            return null;
        }

        protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
            return new FileEntry(obj, primaryFile);
        }

        protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
            try {
                DataObject d = DataShadow.deserialize(primaryFile);
                if (d != null) {
                    return new DataShadow(primaryFile, d, this);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new BrokenDataShadow(primaryFile, this);
        }

        public void writeExternal(ObjectOutput oo) throws IOException {
        }

        public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        }
    }

    private static final class DefaultLoader
    extends MultiFileLoader {
        static final long serialVersionUID = -6761887227412396555L;

        public DefaultLoader() {
            super("org.openide.loaders.DefaultDataObject");
        }

        protected SystemAction[] defaultActions() {
            return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$OpenAction == null ? (class$org$openide$actions$OpenAction = DataLoaderPool.class$("org.openide.actions.OpenAction")) : class$org$openide$actions$OpenAction)), null, SystemAction.get((Class)(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = DataLoaderPool.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction)), null, SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = DataLoaderPool.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = DataLoaderPool.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = DataLoaderPool.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = DataLoaderPool.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = DataLoaderPool.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = DataLoaderPool.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$SaveAsTemplateAction == null ? (class$org$openide$actions$SaveAsTemplateAction = DataLoaderPool.class$("org.openide.actions.SaveAsTemplateAction")) : class$org$openide$actions$SaveAsTemplateAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = DataLoaderPool.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }

        protected String defaultDisplayName() {
            return NbBundle.getMessage((Class)(class$org$openide$loaders$DataLoaderPool == null ? (class$org$openide$loaders$DataLoaderPool = DataLoaderPool.class$("org.openide.loaders.DataLoaderPool")) : class$org$openide$loaders$DataLoaderPool), (String)"LBL_default_loader_display_name");
        }

        protected FileObject findPrimaryFile(FileObject fo) {
            if (fo.isFolder()) {
                return null;
            }
            return fo;
        }

        protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
            return new DefaultDataObject(primaryFile, this);
        }

        protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
            return new FileEntry(obj, primaryFile);
        }

        protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject obj, FileObject secondaryFile) {
            throw new UnsupportedOperationException();
        }

        void checkFiles(MultiDataObject obj) {
        }
    }

    private static class InstanceLoader
    extends UniFileLoader {
        static final long serialVersionUID = -3462727693843631328L;

        public InstanceLoader() {
            super("org.openide.loaders.InstanceDataObject");
        }

        protected void initialize() {
            super.initialize();
            this.setExtensions(null);
        }

        protected SystemAction[] defaultActions() {
            return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$OpenAction == null ? (class$org$openide$actions$OpenAction = DataLoaderPool.class$("org.openide.actions.OpenAction")) : class$org$openide$actions$OpenAction)), SystemAction.get((Class)(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = DataLoaderPool.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction)), null, SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = DataLoaderPool.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = DataLoaderPool.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = DataLoaderPool.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = DataLoaderPool.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = DataLoaderPool.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = DataLoaderPool.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = DataLoaderPool.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }

        protected String defaultDisplayName() {
            return NbBundle.getMessage((Class)(class$org$openide$loaders$DataLoaderPool == null ? (class$org$openide$loaders$DataLoaderPool = DataLoaderPool.class$("org.openide.loaders.DataLoaderPool")) : class$org$openide$loaders$DataLoaderPool), (String)"LBL_instance_loader_display_name");
        }

        protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
            InstanceDataObject obj = new InstanceDataObject(primaryFile, this);
            return obj;
        }

        public void writeExternal(ObjectOutput oo) throws IOException {
            oo.writeObject((Object)this);
            super.writeExternal(oo);
        }

        public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
            Object o = oi.readObject();
            if (o instanceof SystemAction[]) {
                this.setActions((SystemAction[])o);
                this.setExtensions(this.getExtensions());
            } else if (o instanceof ExtensionList) {
                ExtensionList list = (ExtensionList)o;
                this.setExtensions(list);
            } else {
                super.readExternal(oi);
                this.setExtensions(this.getExtensions());
            }
        }

        public void setExtensions(ExtensionList ext) {
            super.setExtensions(this.initExtensions(ext));
        }

        private ExtensionList initExtensions(ExtensionList ext) {
            String[] rqext = this.getRequiredExt();
            if (ext == null) {
                ext = new ExtensionList();
            }
            for (int i = 0; i < rqext.length; ++i) {
                ext.addExtension(rqext[i]);
            }
            return ext;
        }

        protected FileObject findPrimaryFile(FileObject fo) {
            FileObject r = super.findPrimaryFile(fo);
            if (r != null && r.getPath().equals("loaders.ser")) {
                try {
                    if (r.getFileSystem().isDefault()) {
                        return null;
                    }
                }
                catch (FileStateInvalidException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            return r;
        }

        protected String[] getRequiredExt() {
            return new String[]{"instance", "ser", "settings"};
        }
    }

    private static class InstanceLoaderSystem
    extends InstanceLoader {
        private static final long serialVersionUID = -935749906623354837L;

        protected FileObject findPrimaryFile(FileObject fo) {
            FileSystem fs = null;
            try {
                fs = fo.getFileSystem();
            }
            catch (FileStateInvalidException e) {
                return null;
            }
            if (fs != Repository.getDefault().getDefaultFileSystem()) {
                return null;
            }
            return super.findPrimaryFile(fo);
        }

        protected String[] getRequiredExt() {
            return new String[]{"instance", "settings"};
        }
    }

    private static final class DefaultPool
    extends DataLoaderPool
    implements LookupListener {
        private final Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$loaders$DataLoader == null ? (class$org$openide$loaders$DataLoader = DataLoaderPool.class$("org.openide.loaders.DataLoader")) : class$org$openide$loaders$DataLoader));

        protected Enumeration loaders() {
            return Collections.enumeration(this.result.allInstances());
        }

        public void resultChanged(LookupEvent e) {
            this.fireChangeEvent(new ChangeEvent(this));
        }
    }
}

