/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.DefaultDataObject;
import org.openide.loaders.LoaderTransfer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

public class DataNode
extends AbstractNode {
    static final long serialVersionUID = -7882925922830244768L;
    private DataObject obj;
    private PropL propL;
    private static boolean showFileExtensions = true;
    private static RequestProcessor.Task refreshNamesIconsTask = null;
    private static Set refreshNameNodes = null;
    private static Set refreshIconNodes = null;
    private static boolean refreshNamesIconsRunning = false;
    private static final Object refreshNameIconLock = "DataNode.refreshNameIconLock";
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$util$Date;

    public DataNode(DataObject obj, Children ch) {
        super(ch);
        this.obj = obj;
        this.propL = new PropL();
        obj.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propL, (Object)obj));
        super.setName(obj.getName());
        this.updateDisplayName();
    }

    private void updateDisplayName() {
        String newDisplayName;
        FileObject prim = this.obj.getPrimaryFile();
        if (prim.isRoot()) {
            FileObject archiveFile;
            File f = FileUtil.toFile((FileObject)prim);
            if (f == null && (archiveFile = FileUtil.getArchiveFile((FileObject)prim)) != null) {
                f = FileUtil.toFile((FileObject)archiveFile);
            }
            if (f != null) {
                newDisplayName = f.getAbsolutePath();
            } else {
                try {
                    newDisplayName = prim.getURL().toExternalForm();
                }
                catch (FileStateInvalidException e) {
                    newDisplayName = "???";
                }
            }
        } else {
            newDisplayName = showFileExtensions || this.obj instanceof DataFolder || this.obj instanceof DefaultDataObject ? prim.getNameExt() : prim.getName();
        }
        if (this.displayFormat != null) {
            this.setDisplayName(this.displayFormat.format(new Object[]{newDisplayName}));
        } else {
            this.setDisplayName(newDisplayName);
        }
    }

    public DataObject getDataObject() {
        return this.obj;
    }

    public void setName(String name, boolean rename) {
        try {
            if (rename) {
                this.obj.rename(name);
            }
            super.setName(name);
            this.updateDisplayName();
        }
        catch (IOException ex) {
            String msg = null;
            msg = ex.getLocalizedMessage() == null || ex.getLocalizedMessage().equals(ex.getMessage()) ? NbBundle.getMessage((Class)DataNode.class, (String)"MSG_renameError", (Object)this.getName(), (Object)name) : ex.getLocalizedMessage();
            IllegalArgumentException e = new IllegalArgumentException();
            ErrorManager.getDefault().copyAnnotation((Throwable)e, (Throwable)ex);
            ErrorManager.getDefault().annotate((Throwable)e, 256, null, msg, null, null);
            throw e;
        }
    }

    public void setName(String name) {
        this.setName(name, true);
    }

    public String getDisplayName() {
        String s = super.getDisplayName();
        try {
            s = this.obj.getPrimaryFile().getFileSystem().getStatus().annotateName(s, (Set)new LazyFilesSet());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return s;
    }

    public String getHtmlDisplayName() {
        try {
            FileSystem.Status stat = this.obj.getPrimaryFile().getFileSystem().getStatus();
            if (stat instanceof FileSystem.HtmlStatus) {
                FileSystem.HtmlStatus hstat = (FileSystem.HtmlStatus)stat;
                String result = hstat.annotateNameHtml(super.getDisplayName(), (Set)new LazyFilesSet());
                if (!super.getDisplayName().equals(result)) {
                    return result;
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return super.getHtmlDisplayName();
    }

    public Image getIcon(int type) {
        Image img = super.getIcon(type);
        try {
            img = this.obj.getPrimaryFile().getFileSystem().getStatus().annotateIcon(img, type, (Set)new LazyFilesSet());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return img;
    }

    public Image getOpenedIcon(int type) {
        Image img = super.getOpenedIcon(type);
        try {
            img = this.obj.getPrimaryFile().getFileSystem().getStatus().annotateIcon(img, type, (Set)new LazyFilesSet());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return img;
    }

    public HelpCtx getHelpCtx() {
        return this.obj.getHelpCtx();
    }

    public boolean canRename() {
        return this.obj.isRenameAllowed();
    }

    public boolean canDestroy() {
        return this.obj.isDeleteAllowed();
    }

    public void destroy() throws IOException {
        if (this.obj.isDeleteAllowed()) {
            this.obj.delete();
        }
        super.destroy();
    }

    public boolean canCopy() {
        return this.obj.isCopyAllowed();
    }

    public boolean canCut() {
        return this.obj.isMoveAllowed();
    }

    protected SystemAction[] createActions() {
        return null;
    }

    public Action[] getActions(boolean context) {
        if (this.systemActions == null) {
            this.systemActions = this.createActions();
        }
        if (this.systemActions != null) {
            return this.systemActions;
        }
        return this.obj.getLoader().getSwingActions();
    }

    public SystemAction[] getActions() {
        if (this.systemActions == null) {
            this.systemActions = this.createActions();
        }
        if (this.systemActions != null) {
            return this.systemActions;
        }
        return this.obj.getLoader().getActions();
    }

    public Action getPreferredAction() {
        if (this.obj.isTemplate()) {
            return null;
        }
        Action action = super.getPreferredAction();
        if (action != null) {
            return action;
        }
        Action[] arr = this.getActions(false);
        if (arr != null && arr.length > 0) {
            return arr[0];
        }
        return null;
    }

    public Node.Cookie getCookie(Class cl) {
        Node.Cookie c = this.obj.getCookie(cl);
        if (c != null) {
            return c;
        }
        return super.getCookie(cl);
    }

    protected Sheet createSheet() {
        Sheet s = Sheet.createDefault();
        Sheet.Set ss = s.get("properties");
        Node.Property p = DataNode.createNameProperty(this.obj);
        ss.put(p);
        FileObject fo = this.getDataObject().getPrimaryFile();
        if (DataNode.couldBeTemplate(fo) && !fo.isReadOnly()) {
            try {
                p = new PropertySupport.Reflection((Object)this.obj, Boolean.TYPE, "isTemplate", "setTemplate");
                p.setName("template");
                p.setDisplayName(DataObject.getString("PROP_template"));
                p.setShortDescription(DataObject.getString("HINT_template"));
                ss.put(p);
            }
            catch (Exception ex) {
                throw new InternalError();
            }
        }
        if (fo.isData()) {
            ss.put((Node.Property)new AllFilesProperty());
            ss.put((Node.Property)new SizeProperty());
            ss.put((Node.Property)new LastModifiedProperty());
        }
        return s;
    }

    private static boolean couldBeTemplate(FileObject fo) {
        FileSystem fs;
        try {
            fs = fo.getFileSystem();
        }
        catch (FileStateInvalidException e) {
            return false;
        }
        return fs.isDefault() && fo.getPath().startsWith("Templates/");
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable t = ExTransferable.create((Transferable)super.clipboardCopy());
        t.put(LoaderTransfer.transferable(this.getDataObject(), 1));
        return t;
    }

    public Transferable clipboardCut() throws IOException {
        ExTransferable t = ExTransferable.create((Transferable)super.clipboardCut());
        t.put(LoaderTransfer.transferable(this.getDataObject(), 4));
        return t;
    }

    static Node.Property createNameProperty(final DataObject obj) {
        PropertySupport.ReadWrite p = new PropertySupport.ReadWrite("name", String.class, DataObject.getString("PROP_name"), DataObject.getString("HINT_name")){

            public Object getValue() {
                return obj.getName();
            }

            public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                if (!this.canWrite()) {
                    throw new IllegalAccessException();
                }
                if (!(val instanceof String)) {
                    throw new IllegalArgumentException();
                }
                try {
                    obj.rename((String)val);
                }
                catch (IOException ex) {
                    String msg = null;
                    msg = ex.getLocalizedMessage() == null || ex.getLocalizedMessage().equals(ex.getMessage()) ? NbBundle.getMessage((Class)(class$org$openide$loaders$DataNode == null ? (class$org$openide$loaders$DataNode = DataNode.class$("org.openide.loaders.DataNode")) : class$org$openide$loaders$DataNode), (String)"MSG_renameError", (Object)obj.getName(), (Object)val) : ex.getLocalizedMessage();
                    ErrorManager.getDefault().annotate((Throwable)ex, 256, null, msg, null, null);
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean canWrite() {
                return obj.isRenameAllowed();
            }

            public Object getValue(String key) {
                if ("suppressCustomEditor".equals(key)) {
                    return Boolean.TRUE;
                }
                return super.getValue(key);
            }
        };
        return p;
    }

    void fireChange(final PropertyChangeEvent ev) {
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                if ("children".equals(ev.getPropertyName())) {
                    return;
                }
                if ("primaryFile".equals(ev.getPropertyName())) {
                    DataNode.this.propL.updateStatusListener();
                    DataNode.this.setName(DataNode.this.obj.getName(), false);
                    return;
                }
                if ("name".equals(ev.getPropertyName())) {
                    DataNode.super.setName(DataNode.this.obj.getName());
                    DataNode.this.updateDisplayName();
                    return;
                }
                if ("cookie".equals(ev.getPropertyName())) {
                    DataNode.this.fireCookieChange();
                }
                if ("valid".equals(ev.getPropertyName())) {
                    Object newVal = ev.getNewValue();
                    if (newVal instanceof Boolean && !((Boolean)newVal).booleanValue()) {
                        DataNode.this.fireNodeDestroyed();
                    }
                    return;
                }
                List<String> transmitProperties = Arrays.asList("name", "files", "template");
                if (transmitProperties.contains(ev.getPropertyName())) {
                    DataNode.this.firePropertyChange(ev.getPropertyName(), ev.getOldValue(), ev.getNewValue());
                }
            }
        });
    }

    public Node.Handle getHandle() {
        return new ObjectHandle(this.obj, this.obj.isValid() ? this != this.obj.getNodeDelegate() : true);
    }

    final void fireChangeAccess(boolean icon, boolean name) {
        if (name) {
            this.fireDisplayNameChange(null, null);
        }
        if (icon) {
            this.fireIconChange();
        }
    }

    public static boolean getShowFileExtensions() {
        return showFileExtensions;
    }

    public static void setShowFileExtensions(boolean s) {
        boolean refresh = showFileExtensions != s;
        showFileExtensions = s;
        if (refresh) {
            RequestProcessor.postRequest((Runnable)new Runnable(){

                public void run() {
                    Iterator it = DataObjectPool.getPOOL().getActiveDataObjects();
                    while (it.hasNext()) {
                        DataObject obj = ((DataObjectPool.Item)it.next()).getDataObjectOrNull();
                        if (obj == null || !(obj.getNodeDelegate() instanceof DataNode)) continue;
                        ((DataNode)obj.getNodeDelegate()).updateDisplayName();
                    }
                }
            }, (int)300, (int)1);
        }
    }

    private class LazyFilesSet
    implements Set {
        private Set obj_files;

        private LazyFilesSet() {
        }

        private synchronized void lazyInitialization() {
            this.obj_files = DataNode.this.obj.files();
        }

        public boolean add(Object o) {
            this.lazyInitialization();
            return this.obj_files.add(o);
        }

        public boolean addAll(Collection c) {
            this.lazyInitialization();
            return this.obj_files.addAll(c);
        }

        public void clear() {
            this.lazyInitialization();
            this.obj_files.clear();
        }

        public boolean contains(Object o) {
            this.lazyInitialization();
            return this.obj_files.contains(o);
        }

        public boolean containsAll(Collection c) {
            this.lazyInitialization();
            return this.obj_files.containsAll(c);
        }

        public boolean isEmpty() {
            this.lazyInitialization();
            return this.obj_files.isEmpty();
        }

        public Iterator iterator() {
            return new FilesIterator();
        }

        public boolean remove(Object o) {
            this.lazyInitialization();
            return this.obj_files.remove(o);
        }

        public boolean removeAll(Collection c) {
            this.lazyInitialization();
            return this.obj_files.removeAll(c);
        }

        public boolean retainAll(Collection c) {
            this.lazyInitialization();
            return this.obj_files.retainAll(c);
        }

        public int size() {
            this.lazyInitialization();
            return this.obj_files.size();
        }

        public Object[] toArray() {
            this.lazyInitialization();
            return this.obj_files.toArray();
        }

        public Object[] toArray(Object[] a) {
            this.lazyInitialization();
            return this.obj_files.toArray(a);
        }

        private final class FilesIterator
        implements Iterator {
            private boolean first = true;
            private Iterator itDelegate = null;

            FilesIterator() {
            }

            public boolean hasNext() {
                return this.first ? true : this.getIteratorDelegate().hasNext();
            }

            public Object next() {
                if (this.first) {
                    this.first = false;
                    return DataNode.this.obj.getPrimaryFile();
                }
                return this.getIteratorDelegate().next();
            }

            public void remove() {
                this.getIteratorDelegate().remove();
            }

            private Iterator getIteratorDelegate() {
                if (this.itDelegate == null) {
                    LazyFilesSet.this.lazyInitialization();
                    this.itDelegate = LazyFilesSet.this.obj_files.iterator();
                    this.itDelegate.next();
                }
                return this.itDelegate;
            }
        }
    }

    private static class ObjectHandle
    implements Node.Handle {
        private FileObject obj;
        private boolean clone;
        static final long serialVersionUID = 6616060729084681518L;

        public ObjectHandle(DataObject obj, boolean clone) {
            this.obj = obj.getPrimaryFile();
            this.clone = clone;
        }

        public Node getNode() throws IOException {
            if (this.obj == null) {
                throw new IOException("File could not be restored");
            }
            Node n = DataObject.find(this.obj).getNodeDelegate();
            return this.clone ? n.cloneNode() : n;
        }
    }

    private class PropL
    implements PropertyChangeListener,
    FileStatusListener,
    Runnable {
        private FileStatusListener weakL;
        private FileSystem previous;

        public PropL() {
            this.updateStatusListener();
        }

        public void propertyChange(PropertyChangeEvent ev) {
            DataNode.this.fireChange(ev);
        }

        private void updateStatusListener() {
            if (this.previous != null) {
                this.previous.removeFileStatusListener(this.weakL);
            }
            try {
                this.previous = DataNode.this.obj.getPrimaryFile().getFileSystem();
                if (this.weakL == null) {
                    this.weakL = FileUtil.weakFileStatusListener((FileStatusListener)this, null);
                }
                this.previous.addFileStatusListener(this.weakL);
            }
            catch (FileStateInvalidException ex) {
                this.previous = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void annotationChanged(FileStatusEvent ev) {
            boolean thisChanged = false;
            Iterator it = DataNode.this.obj.files().iterator();
            while (it.hasNext()) {
                FileObject fo = (FileObject)it.next();
                if (!ev.hasChanged(fo)) continue;
                thisChanged = true;
                break;
            }
            if (thisChanged) {
                Object object = refreshNameIconLock;
                synchronized (object) {
                    boolean post = false;
                    if (ev.isNameChange()) {
                        if (refreshNameNodes == null) {
                            refreshNameNodes = new HashSet();
                        }
                        post |= refreshNameNodes.add(DataNode.this);
                    }
                    if (ev.isIconChange()) {
                        if (refreshIconNodes == null) {
                            refreshIconNodes = new HashSet();
                        }
                        post |= refreshIconNodes.add(DataNode.this);
                    }
                    if (post && !refreshNamesIconsRunning) {
                        refreshNamesIconsRunning = true;
                        if (refreshNamesIconsTask == null) {
                            refreshNamesIconsTask = RequestProcessor.postRequest((Runnable)this);
                        } else {
                            refreshNamesIconsTask.schedule(0);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int i;
            DataNode[] _refreshIconNodes;
            DataNode[] _refreshNameNodes;
            Object object = refreshNameIconLock;
            synchronized (object) {
                if (refreshNameNodes != null) {
                    _refreshNameNodes = refreshNameNodes.toArray(new DataNode[refreshNameNodes.size()]);
                    refreshNameNodes.clear();
                } else {
                    _refreshNameNodes = new DataNode[]{};
                }
                if (refreshIconNodes != null) {
                    _refreshIconNodes = refreshIconNodes.toArray(new DataNode[refreshIconNodes.size()]);
                    refreshIconNodes.clear();
                } else {
                    _refreshIconNodes = new DataNode[]{};
                }
                refreshNamesIconsRunning = false;
            }
            for (i = 0; i < _refreshNameNodes.length; ++i) {
                _refreshNameNodes[i].fireChangeAccess(false, true);
            }
            for (i = 0; i < _refreshIconNodes.length; ++i) {
                _refreshIconNodes[i].fireChangeAccess(true, false);
            }
        }
    }

    private final class LastModifiedProperty
    extends PropertySupport.ReadOnly {
        public LastModifiedProperty() {
            super("lastModified", class$java$util$Date == null ? (class$java$util$Date = DataNode.class$("java.util.Date")) : class$java$util$Date, DataObject.getString("PROP_lastModified"), DataObject.getString("HINT_lastModified"));
        }

        public Object getValue() {
            return DataNode.this.getDataObject().getPrimaryFile().lastModified();
        }
    }

    private final class SizeProperty
    extends PropertySupport.ReadOnly {
        public SizeProperty() {
            super("size", Long.TYPE, DataObject.getString("PROP_size"), DataObject.getString("HINT_size"));
        }

        public Object getValue() {
            return new Long(DataNode.this.getDataObject().getPrimaryFile().getSize());
        }
    }

    private final class AllFilesProperty
    extends PropertySupport.ReadOnly {
        public AllFilesProperty() {
            super("files", array$Ljava$lang$String == null ? (array$Ljava$lang$String = DataNode.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, DataObject.getString("PROP_files"), DataObject.getString("HINT_files"));
        }

        public Object getValue() {
            Set files = DataNode.this.obj.files();
            String[] toret = new String[files.size()];
            int i = 0;
            Iterator it = files.iterator();
            while (it.hasNext()) {
                toret[i] = this.name((FileObject)it.next());
                ++i;
            }
            final String pfilename = this.name(DataNode.this.obj.getPrimaryFile());
            Arrays.sort(toret, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String fname1 = (String)o1;
                    String fname2 = (String)o2;
                    if (fname1.equals(pfilename)) {
                        return -1;
                    }
                    if (fname2.equals(pfilename)) {
                        return 1;
                    }
                    return fname1.compareTo(fname2);
                }
            });
            return toret;
        }

        private String name(FileObject fo) {
            return FileUtil.getFileDisplayName((FileObject)fo);
        }
    }
}

