/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FolderList;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.ShadowChangeAdapter;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;

final class DataObjectPool
implements ChangeListener {
    private static final ThreadLocal FIND = new ThreadLocal();
    private static final Validator VALIDATOR = new Validator();
    private static final List TOKEN = Collections.unmodifiableList(new ArrayList());
    private HashMap map = new HashMap(512);
    private WeakSet knownFileSystems = new WeakSet();
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.openide.loaders.DataObject.find");
    private static final boolean errLog = err.isLoggable(1);
    private static DataObjectPool POOL;
    private static Object lockPOOL;
    private Thread atomic;
    private RequestProcessor priviledged;
    private FileObject blocked;
    private HashSet toNotify = new HashSet();
    private static final Integer ONE;
    private final Map registrationCounts = new WeakHashMap();
    private static final DataLoaderPool lp;
    private static final ErrorManager LISTENER;
    private static final boolean WILL_LOG_LISTENER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DataObjectPool getPOOL() {
        Object object = lockPOOL;
        synchronized (object) {
            if (POOL != null) {
                return POOL;
            }
            POOL = new DataObjectPool();
        }
        lp.addChangeListener(POOL);
        return POOL;
    }

    private static Collection enterAllowContructor() {
        Collection prev = (Collection)FIND.get();
        FIND.set(TOKEN);
        return prev;
    }

    private static void exitAllowConstructor(Collection previous) {
        List l = (List)FIND.get();
        FIND.set(previous);
        if (l != TOKEN) {
            DataObjectPool.getPOOL().notifyCreationAll(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataObject handleFindDataObject(DataLoader loader, FileObject fo, DataLoader.RecognizedFiles rec) throws IOException {
        DataObject ret;
        Collection prev = DataObjectPool.enterAllowContructor();
        try {
            DataObjectPool.getPOOL().enterRecognition(fo);
            ret = loader.handleFindDataObject(fo, rec);
        }
        finally {
            DataObjectPool.exitAllowConstructor(prev);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiDataObject createMultiObject(MultiFileLoader loader, FileObject fo) throws IOException {
        MultiDataObject ret;
        Collection prev = DataObjectPool.enterAllowContructor();
        try {
            ret = loader.createMultiObject(fo);
        }
        finally {
            DataObjectPool.exitAllowConstructor(prev);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiDataObject createMultiObject(DataLoaderPool.FolderLoader loader, FileObject fo, DataFolder original) throws IOException {
        MultiDataObject ret;
        Collection prev = DataObjectPool.enterAllowContructor();
        try {
            ret = loader.createMultiObject(fo, original);
        }
        finally {
            DataObjectPool.exitAllowConstructor(prev);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAtomicActionSimple(FileObject fo, FileSystem.AtomicAction action) throws IOException {
        Collection prev = DataObjectPool.enterAllowContructor();
        try {
            fo.getFileSystem().runAtomicAction(action);
        }
        finally {
            DataObjectPool.exitAllowConstructor(prev);
        }
    }

    public void runAtomicAction(FileObject target, FileSystem.AtomicAction action) throws IOException {
        class WrapAtomicAction
        implements FileSystem.AtomicAction {
            private final /* synthetic */ FileObject val$target;
            private final /* synthetic */ FileSystem.AtomicAction val$action;

            WrapAtomicAction(FileObject val$target, FileSystem.AtomicAction val$action) {
                this.val$target = val$target;
                this.val$action = val$action;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                DataObjectPool dataObjectPool;
                FileObject prevBlocked;
                Thread prev;
                DataObjectPool dataObjectPool2 = DataObjectPool.this;
                synchronized (dataObjectPool2) {
                    DataObjectPool.this.enterRecognition(null);
                    prev = DataObjectPool.this.atomic;
                    prevBlocked = DataObjectPool.this.blocked;
                    DataObjectPool.this.atomic = Thread.currentThread();
                    DataObjectPool.this.blocked = this.val$target;
                }
                Collection findPrev = DataObjectPool.enterAllowContructor();
                try {
                    this.val$action.run();
                    Object var6_5 = null;
                    dataObjectPool = DataObjectPool.this;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    DataObjectPool dataObjectPool3 = DataObjectPool.this;
                    synchronized (dataObjectPool3) {
                        DataObjectPool.this.atomic = prev;
                        DataObjectPool.this.blocked = prevBlocked;
                        DataObjectPool.this.notifyAll();
                    }
                    DataObjectPool.exitAllowConstructor(findPrev);
                    throw throwable;
                }
                synchronized (dataObjectPool) {
                    DataObjectPool.this.atomic = prev;
                    DataObjectPool.this.blocked = prevBlocked;
                    DataObjectPool.this.notifyAll();
                }
                DataObjectPool.exitAllowConstructor(findPrev);
            }
        }
        target.getFileSystem().runAtomicAction((FileSystem.AtomicAction)new WrapAtomicAction(target, action));
    }

    public synchronized void enterPriviledgedProcessor(RequestProcessor delegate) {
        if (this.atomic == Thread.currentThread()) {
            if (this.priviledged != null) {
                throw new IllegalStateException("Previous priviledged is not null: " + this.priviledged + " now: " + delegate);
            }
            this.priviledged = delegate;
        }
        this.notifyAll();
    }

    public synchronized void exitPriviledgedProcessor(RequestProcessor delegate) {
        if (this.atomic == Thread.currentThread()) {
            if (this.priviledged != delegate) {
                throw new IllegalStateException("Trying to unregister wrong priviledged. Prev: " + this.priviledged + " now: " + delegate);
            }
            this.priviledged = null;
        }
        this.notifyAll();
    }

    private synchronized void enterRecognition(FileObject fo) {
        while (!(this.atomic == null || this.atomic == Thread.currentThread() || this.priviledged != null && this.priviledged.isRequestProcessorThread() || fo != null && this.blocked != null && !this.blocked.equals(fo.getParent()))) {
            if (errLog) {
                err.log(1, "Enter recognition block: " + Thread.currentThread());
                err.log(1, "            waiting for: " + fo);
                err.log(1, "        blocking thread: " + this.atomic);
                err.log(1, "             blocked on: " + this.blocked);
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private DataObjectPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject find(FileObject fo) {
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            List l;
            Item doh = (Item)this.map.get(fo);
            if (doh == null) {
                return null;
            }
            if (this.toNotify.contains(doh) && ((l = (List)FIND.get()) == null || !l.contains(doh))) {
                return null;
            }
            return doh.getDataObjectOrNull();
        }
    }

    void countRegistration(FileObject fo) {
        Integer i = (Integer)this.registrationCounts.get(fo);
        Integer i2 = i == null ? ONE : new Integer(i + 1);
        this.registrationCounts.put(fo, i2);
    }

    int registrationCount(FileObject fo) {
        Integer i = (Integer)this.registrationCounts.get(fo);
        if (i == null) {
            return 0;
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshAllFolders() {
        HashSet files;
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            files = new HashSet(this.map.keySet());
        }
        Iterator it = files.iterator();
        while (it.hasNext()) {
            DataObject obj;
            FileObject fo = (FileObject)it.next();
            if (!fo.isFolder() || !((obj = this.find(fo)) instanceof DataFolder)) continue;
            DataFolder df = (DataFolder)obj;
            FileObject file = df.getPrimaryFile();
            DataObjectPool dataObjectPool2 = this;
            synchronized (dataObjectPool2) {
                if (this.toNotify.isEmpty() || !this.toNotify.contains((Item)this.map.get(file))) {
                    FolderList.changedDataSystem(file);
                }
            }
        }
    }

    public Set revalidate(Set s) {
        return VALIDATOR.revalidate(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set revalidate() {
        Set files;
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            files = DataObjectPool.createSetOfAllFiles(this.map.values());
        }
        return this.revalidate(files);
    }

    public void notifyCreation(DataObject obj) {
        this.notifyCreation(obj.item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCreation(Item item) {
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            if (errLog) {
                err.log(1, "Notify created: " + item + " by " + Thread.currentThread());
            }
            if (this.toNotify.isEmpty()) {
                if (errLog) {
                    err.log(1, "  but toNotify is empty");
                }
                return;
            }
            if (!this.toNotify.remove(item)) {
                if (errLog) {
                    err.log(1, "  the item is not there: " + this.toNotify);
                }
                return;
            }
            this.notifyAll();
        }
        DataObject obj = item.getDataObjectOrNull();
        if (obj != null) {
            lp.fireOperationEvent(new OperationEvent(obj), 7);
        }
    }

    private void notifyCreationAll(List l) {
        if (l.isEmpty()) {
            return;
        }
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            Item i = (Item)iter.next();
            this.notifyCreation(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitNotified(DataObject obj) {
        while (true) {
            try {
                while (true) {
                    DataObjectPool dataObjectPool = this;
                    synchronized (dataObjectPool) {
                        this.enterRecognition(obj.getPrimaryFile().getParent());
                        if (this.toNotify.isEmpty()) {
                            return;
                        }
                        List l = (List)FIND.get();
                        if (l != null && l.contains(obj.item)) {
                            return;
                        }
                        if (!this.toNotify.contains(obj.item)) {
                            return;
                        }
                        if (errLog) {
                            err.log(1, "waitTillNotified: " + Thread.currentThread());
                            err.log(1, "      waitingFor: " + obj.getPrimaryFile().getPath());
                        }
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private void notifyAdd(Item item) {
        this.toNotify.add(item);
        ArrayList<Item> l = (ArrayList<Item>)FIND.get();
        if (l == TOKEN) {
            l = new ArrayList<Item>();
            FIND.set(l);
        }
        l.add(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item register(FileObject fo, DataLoader loader) throws DataObjectExistsException {
        DataObject obj;
        Item doh;
        if (FIND.get() == null) {
            throw new IllegalStateException("DataObject constructor can be called only thru DataObject.find - use that method");
        }
        try {
            FileSystem fs = fo.getFileSystem();
            WeakSet weakSet = this.knownFileSystems;
            synchronized (weakSet) {
                if (!this.knownFileSystems.contains((Object)fs)) {
                    fs.addFileChangeListener((FileChangeListener)new FSListener());
                    this.knownFileSystems.add((Object)fs);
                }
            }
        }
        catch (FileStateInvalidException e) {
            // empty catch block
        }
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            doh = (Item)this.map.get(fo);
            if (doh == null) {
                doh = new Item(fo);
                this.map.put(fo, doh);
                this.countRegistration(fo);
                this.notifyAdd(doh);
                VALIDATOR.notifyRegistered(fo);
                return doh;
            }
            obj = doh.getDataObjectOrNull();
            if (obj == null) {
                doh = new Item(fo);
                this.map.put(fo, doh);
                this.countRegistration(fo);
                this.notifyAdd(doh);
                return doh;
            }
            if (!VALIDATOR.reregister(obj, loader)) {
                throw new DataObjectExistsException(obj);
            }
        }
        try {
            obj.setValid(false);
            dataObjectPool = this;
            synchronized (dataObjectPool) {
                Item doh2 = (Item)this.map.get(fo);
                if (doh2 == null) {
                    doh = new Item(fo);
                    this.map.put(fo, doh);
                    this.countRegistration(fo);
                    this.notifyAdd(doh);
                    return doh;
                }
            }
        }
        catch (PropertyVetoException ex) {
            VALIDATOR.refusingObjects.add(obj);
        }
        throw new DataObjectExistsException(obj);
    }

    private synchronized void deregister(Item item, boolean refresh) {
        DataFolder df;
        Item item2;
        FileObject fo = item.primaryFile;
        Item previous = (Item)this.map.remove(fo);
        if (previous != null && previous != item) {
            this.map.put(fo, previous);
            this.countRegistration(fo);
            if (this.toNotify.remove(item)) {
                this.notifyAll();
            }
            return;
        }
        if (refresh && (fo = fo.getParent()) != null && (item2 = (Item)this.map.get(fo)) != null && (df = (DataFolder)item2.getDataObjectOrNull()) != null) {
            VALIDATOR.refreshFolderOf(df);
        }
    }

    private synchronized void changePrimaryFile(Item item, FileObject newFile) {
        this.map.remove(item.primaryFile);
        item.primaryFile = newFile;
        this.map.put(newFile, item);
        this.countRegistration(newFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(ChangeEvent ev) {
        Set<Object> set;
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            set = new HashSet(this.map.values());
        }
        set = DataObjectPool.createSetOfAllFiles(set);
        this.revalidate(set);
    }

    private static Set createSetOfAllFiles(Collection c) {
        HashSet set = new HashSet(c.size() * 7);
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Item item = (Item)it.next();
            DataObject obj = item.getDataObjectOrNull();
            if (obj == null) continue;
            DataObjectPool.getPOOL().waitNotified(obj);
            set.addAll(obj.files());
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator getActiveDataObjects() {
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            ArrayList alist = new ArrayList(this.map.values());
            return alist.iterator();
        }
    }

    static {
        lockPOOL = new Object();
        ONE = new Integer(1);
        lp = DataLoaderPool.getDefault();
        LISTENER = ErrorManager.getDefault().getInstance("org.openide.loaders.DataObjectPool.Listener");
        WILL_LOG_LISTENER = LISTENER.isLoggable(1);
    }

    private static final class Validator
    implements DataLoader.RecognizedFiles {
        private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.openide.loaders.DataObject.Validator");
        private static final boolean errLog = err.isLoggable(1);
        private Set files;
        private Thread current;
        private int waiters;
        private int reenterCount;
        private HashSet recognizedFiles;
        private HashSet refusingObjects;
        private HashSet createdFiles;

        Validator() {
        }

        private synchronized Set enter(Set set) {
            boolean log = err.isLoggable(1);
            if (log) {
                err.log("enter: " + set + " on thread: " + Thread.currentThread());
            }
            if (this.current == Thread.currentThread()) {
                ++this.reenterCount;
                if (log) {
                    err.log("current thread, rentered: " + this.reenterCount);
                }
            } else {
                ++this.waiters;
                if (log) {
                    err.log("Waiting as waiter: " + this.waiters);
                }
                while (this.current != null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.current = Thread.currentThread();
                --this.waiters;
                if (log) {
                    err.log("Wait finished, waiters: " + this.waiters + " new current: " + this.current);
                }
            }
            if (this.files == null) {
                if (log) {
                    err.log("New files: " + set);
                }
                this.files = set;
            } else {
                this.files.addAll(set);
                if (log) {
                    err.log("Added files: " + set);
                    err.log("So they are: " + this.files);
                }
            }
            return this.files;
        }

        private synchronized void exit() {
            boolean log = err.isLoggable(1);
            if (this.reenterCount == 0) {
                this.current = null;
                if (this.waiters == 0) {
                    this.files = null;
                }
                this.notify();
                if (log) {
                    err.log("Exit and notify from " + Thread.currentThread());
                }
            } else {
                --this.reenterCount;
                if (log) {
                    err.log("Exit reentrant: " + this.reenterCount);
                }
            }
        }

        private synchronized boolean goOn() {
            return this.waiters == 0;
        }

        public void refreshFolderOf(DataFolder df) {
            if (this.createdFiles == null) {
                FolderList.changedDataSystem(df.getPrimaryFile());
            }
        }

        public void markRecognized(FileObject fo) {
            this.recognizedFiles.add(fo);
        }

        public void notifyRegistered(FileObject fo) {
            if (this.createdFiles != null) {
                this.createdFiles.add(fo);
            }
        }

        public boolean reregister(DataObject obj, DataLoader loader) {
            if (this.recognizedFiles == null) {
                return false;
            }
            if (obj.getLoader() == loader) {
                return false;
            }
            if (this.createdFiles.contains(obj.getPrimaryFile())) {
                return false;
            }
            return !this.refusingObjects.contains(obj);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set revalidate(Set s) {
            HashSet hashSet;
            block15: {
                if (s.size() == 1 && this.current == Thread.currentThread() && this.files != null && this.files.contains(s.iterator().next())) {
                    return new HashSet();
                }
                LinkedList<DataObject> createObjects = new LinkedList<DataObject>();
                boolean log = err.isLoggable(1);
                try {
                    s = this.enter(s);
                    this.recognizedFiles = new HashSet();
                    this.refusingObjects = new HashSet();
                    this.createdFiles = new HashSet();
                    DataLoaderPool pool = lp;
                    Iterator it = s.iterator();
                    while (it.hasNext() && this.goOn()) {
                        try {
                            FileObject fo = (FileObject)it.next();
                            if (log) {
                                err.log("Iterate: " + fo);
                            }
                            if (this.recognizedFiles.contains(fo)) continue;
                            boolean invalidate = false;
                            DataObject orig = DataObjectPool.getPOOL().find(fo);
                            if (log) {
                                err.log("Original: " + orig);
                            }
                            if (orig == null) continue;
                            DataObject obj = pool.findDataObject(fo, this);
                            createObjects.add(obj);
                            invalidate = obj != orig;
                            if (!invalidate) continue;
                            if (log) {
                                err.log("Invalidate: " + obj);
                            }
                            it.remove();
                            try {
                                orig.setValid(false);
                            }
                            catch (PropertyVetoException ex) {
                                this.refusingObjects.add(orig);
                                if (!log) continue;
                                err.log("  Refusing: " + orig);
                            }
                        }
                        catch (DataObjectExistsException ex) {
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().notify(1, (Throwable)ioe);
                        }
                        catch (ConcurrentModificationException cme) {
                            it = s.iterator();
                            if (!log) continue;
                            err.notify(1, (Throwable)cme);
                            err.log("New iterator over: " + s);
                        }
                    }
                    hashSet = this.refusingObjects;
                    Object var12_14 = null;
                    this.recognizedFiles = null;
                    this.refusingObjects = null;
                    this.createdFiles = null;
                    this.exit();
                    if (!log) break block15;
                }
                catch (Throwable throwable) {
                    block16: {
                        Object var12_15 = null;
                        this.recognizedFiles = null;
                        this.refusingObjects = null;
                        this.createdFiles = null;
                        this.exit();
                        if (log) {
                            err.log("will do refreshAllFolders: " + s.size());
                        }
                        if (s.size() <= 1) break block16;
                        DataObjectPool.getPOOL().refreshAllFolders();
                    }
                    throw throwable;
                }
                err.log("will do refreshAllFolders: " + s.size());
            }
            if (s.size() > 1) {
                DataObjectPool.getPOOL().refreshAllFolders();
            }
            return hashSet;
        }
    }

    static final class ItemReference
    extends WeakReference
    implements Runnable {
        private Item item;

        ItemReference(DataObject dobject, Item item) {
            super(dobject, Utilities.activeReferenceQueue());
            this.item = item;
        }

        public void run() {
            this.item.deregister(false);
            this.item = null;
        }
    }

    static final class Item {
        private static final Reference REFERENCE_NOT_SET = new WeakReference<Object>(null);
        private Reference obj = REFERENCE_NOT_SET;
        FileObject primaryFile;

        public Item(FileObject fo) {
            this.primaryFile = fo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDataObject(DataObject obj) {
            this.obj = new ItemReference(obj, this);
            if (obj != null && !obj.getPrimaryFile().isValid()) {
                this.deregister(false);
            }
            DataObjectPool dataObjectPool = DataObjectPool.getPOOL();
            synchronized (dataObjectPool) {
                DataObjectPool.getPOOL().notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DataObject getDataObjectOrNull() {
            DataObjectPool dataObjectPool = DataObjectPool.getPOOL();
            synchronized (dataObjectPool) {
                while (this.obj == REFERENCE_NOT_SET) {
                    try {
                        DataObjectPool.getPOOL().wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            return this.obj == null ? null : (DataObject)this.obj.get();
        }

        public DataObject getDataObject() {
            DataObject obj = this.getDataObjectOrNull();
            if (obj == null) {
                throw new IllegalStateException();
            }
            return obj;
        }

        public void deregister(boolean refresh) {
            DataObjectPool.getPOOL().deregister(this, refresh);
        }

        public void changePrimaryFile(FileObject newFile) {
            DataObjectPool.getPOOL().changePrimaryFile(this, newFile);
        }

        public boolean isValid() {
            if (DataObjectPool.getPOOL().map.get(this.primaryFile) == this) {
                return this.primaryFile.isValid();
            }
            return false;
        }

        public String toString() {
            DataObject obj = (DataObject)this.obj.get();
            if (obj == null) {
                return "nothing[" + this.primaryFile + "]";
            }
            return obj.toString();
        }
    }

    private final class FSListener
    extends FileChangeAdapter {
        FSListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Iterator getTargets(FileEvent fe) {
            FileObject fo = fe.getFile();
            LinkedList<Item> toNotify = new LinkedList<Item>();
            DataObjectPool dataObjectPool = DataObjectPool.this;
            synchronized (dataObjectPool) {
                Item itm = (Item)DataObjectPool.this.map.get(fo);
                if (itm != null) {
                    toNotify.add(itm);
                } else {
                    FileObject parent = fo.getParent();
                    if (parent != null) {
                        FileObject[] siblings = parent.getChildren();
                        for (int i = 0; i < siblings.length; ++i) {
                            itm = (Item)DataObjectPool.this.map.get(siblings[i]);
                            if (itm == null) continue;
                            toNotify.add(itm);
                        }
                    }
                }
            }
            return toNotify.iterator();
        }

        public void fileChanged(FileEvent fe) {
            if (WILL_LOG_LISTENER) {
                LISTENER.log("fileChanged: " + fe);
            }
            Iterator it = this.getTargets(fe);
            while (it.hasNext()) {
                DataObject dobj = ((Item)it.next()).getDataObjectOrNull();
                if (WILL_LOG_LISTENER) {
                    LISTENER.log("  to: " + dobj);
                }
                if (dobj == null) continue;
                dobj.notifyFileChanged(fe);
            }
        }

        public void fileRenamed(FileRenameEvent fe) {
            if (WILL_LOG_LISTENER) {
                LISTENER.log("fileRenamed: " + fe);
            }
            Iterator it = this.getTargets((FileEvent)fe);
            while (it.hasNext()) {
                DataObject dobj = ((Item)it.next()).getDataObjectOrNull();
                if (WILL_LOG_LISTENER) {
                    LISTENER.log("  to: " + dobj);
                }
                if (dobj == null) continue;
                dobj.notifyFileRenamed(fe);
            }
        }

        public void fileDeleted(FileEvent fe) {
            if (WILL_LOG_LISTENER) {
                LISTENER.log("fileDeleted: " + fe);
            }
            Iterator it = this.getTargets(fe);
            while (it.hasNext()) {
                DataObject dobj = ((Item)it.next()).getDataObjectOrNull();
                if (WILL_LOG_LISTENER) {
                    LISTENER.log("  to: " + dobj);
                }
                if (dobj == null) continue;
                dobj.notifyFileDeleted(fe);
            }
        }

        public void fileDataCreated(FileEvent fe) {
            if (WILL_LOG_LISTENER) {
                LISTENER.log("fileDataCreated: " + fe);
            }
            Iterator it = this.getTargets(fe);
            while (it.hasNext()) {
                DataObject dobj = ((Item)it.next()).getDataObjectOrNull();
                if (WILL_LOG_LISTENER) {
                    LISTENER.log("  to: " + dobj);
                }
                if (dobj == null) continue;
                dobj.notifyFileDataCreated(fe);
            }
            ShadowChangeAdapter.checkBrokenDataShadows((EventObject)fe);
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
            if (WILL_LOG_LISTENER) {
                LISTENER.log("fileAttributeChanged: " + fe);
            }
            Iterator it = this.getTargets((FileEvent)fe);
            while (it.hasNext()) {
                DataObject dobj = ((Item)it.next()).getDataObjectOrNull();
                if (WILL_LOG_LISTENER) {
                    LISTENER.log("  to: " + dobj);
                }
                if (dobj == null) continue;
                dobj.notifyAttributeChanged(fe);
            }
        }

        public void fileFolderCreated(FileEvent fe) {
            if (WILL_LOG_LISTENER) {
                LISTENER.log("fileFolderCreated: " + fe);
            }
            ShadowChangeAdapter.checkBrokenDataShadows((EventObject)fe);
        }
    }
}

