/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Date;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.OpenSupport;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeOp;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.SimpleES;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.UserQuestionException;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.CloneableOpenSupport;

public class DataEditorSupport
extends CloneableEditorSupport {
    private final DataObject obj;
    private NodeListener nodeL;

    public DataEditorSupport(DataObject obj, CloneableEditorSupport.Env env) {
        super(env, DataEditorSupport.createLookup(obj));
        this.obj = obj;
    }

    public static CloneableEditorSupport create(DataObject obj, MultiDataObject.Entry entry, CookieSet set) {
        return new SimpleES(obj, entry, set);
    }

    public final DataObject getDataObject() {
        return this.obj;
    }

    protected String messageOpening() {
        return NbBundle.getMessage((Class)DataObject.class, (String)"CTL_ObjectOpen", (Object)this.obj.getPrimaryFile().getNameExt(), (Object)FileUtil.getFileDisplayName((FileObject)this.obj.getPrimaryFile()));
    }

    protected String messageOpened() {
        return NbBundle.getMessage((Class)DataObject.class, (String)"CTL_ObjectOpened", (Object)this.obj.getPrimaryFile().getNameExt(), (Object)FileUtil.getFileDisplayName((FileObject)this.obj.getPrimaryFile()));
    }

    protected String messageSave() {
        return NbBundle.getMessage((Class)DataObject.class, (String)"MSG_SaveFile", (Object)this.obj.getPrimaryFile().getNameExt());
    }

    protected String messageName() {
        if (!this.obj.isValid()) {
            return "";
        }
        String name = DataNode.getShowFileExtensions() ? this.obj.getPrimaryFile().getNameExt() : this.obj.getPrimaryFile().getName();
        return this.addFlagsToName(name);
    }

    private String addFlagsToName(String name) {
        int version = 3;
        if (this.isModified()) {
            version = this.obj.getPrimaryFile().isReadOnly() ? 2 : 1;
        } else if (this.obj.getPrimaryFile().isReadOnly()) {
            version = 0;
        }
        return NbBundle.getMessage((Class)DataObject.class, (String)"LAB_EditorName", (Object)new Integer(version), (Object)name);
    }

    protected String documentID() {
        if (!this.obj.isValid()) {
            return "";
        }
        return this.obj.getPrimaryFile().getName();
    }

    protected String messageToolTip() {
        return FileUtil.getFileDisplayName((FileObject)this.obj.getPrimaryFile());
    }

    protected String messageLine(Line line) {
        return NbBundle.getMessage((Class)DataObject.class, (String)"FMT_LineDisplayName2", (Object)this.obj.getPrimaryFile().getNameExt(), (Object)FileUtil.getFileDisplayName((FileObject)this.obj.getPrimaryFile()), (Object)new Integer(line.getLineNumber() + 1));
    }

    protected void initializeCloneableEditor(CloneableEditor editor) {
        if (this.obj.isValid()) {
            Node ourNode = this.obj.getNodeDelegate();
            editor.setActivatedNodes(new Node[]{ourNode});
            editor.setIcon(ourNode.getIcon(1));
            DataNodeListener nl = new DataNodeListener(editor);
            ourNode.addNodeListener(NodeOp.weakNodeListener((NodeListener)nl, (Object)ourNode));
            this.nodeL = nl;
        }
    }

    protected void notifyClosed() {
        this.nodeL = null;
        super.notifyClosed();
    }

    protected StyledDocument createStyledDocument(EditorKit kit) {
        StyledDocument doc = super.createStyledDocument(kit);
        doc.putProperty("title", FileUtil.getFileDisplayName((FileObject)this.obj.getPrimaryFile()));
        doc.putProperty("stream", this.obj);
        return doc;
    }

    protected boolean canClose() {
        if (this.env().isModified() && this.isEnvReadOnly()) {
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)DataObject.class, (String)"MSG_FileReadOnlyClosing", (Object[])new Object[]{((Env)this.env).getFileImpl().getNameExt()}), 2, 2));
            return result == NotifyDescriptor.OK_OPTION;
        }
        return super.canClose();
    }

    public void saveDocument() throws IOException {
        if (this.env().isModified() && this.isEnvReadOnly()) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)DataObject.class, (String)"MSG_FileReadOnlySaving", (Object[])new Object[]{((Env)this.env).getFileImpl().getNameExt()}), 2));
            return;
        }
        super.saveDocument();
    }

    boolean isEnvReadOnly() {
        CloneableEditorSupport.Env env = this.env();
        return env instanceof Env && ((Env)env).getFileImpl().isReadOnly();
    }

    final DataObject getDataObjectHack2() {
        return this.obj;
    }

    public static DataObject findDataObject(Line l) {
        if (l == null) {
            throw new NullPointerException();
        }
        return (DataObject)l.getLookup().lookup(DataObject.class);
    }

    private static Lookup createLookup(final DataObject dobj) {
        final InstanceContent ic = new InstanceContent();
        AbstractLookup l = new AbstractLookup((AbstractLookup.Content)ic);
        dobj.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent ev) {
                String propName = ev.getPropertyName();
                if (propName == null || propName == "primaryFile") {
                    DataEditorSupport.updateLookup(dobj, ic);
                }
            }
        });
        DataEditorSupport.updateLookup(dobj, ic);
        return l;
    }

    private static void updateLookup(DataObject d, InstanceContent ic) {
        ic.set(Arrays.asList(d, d.getPrimaryFile()), null);
    }

    static /* synthetic */ DataObject access$500(DataEditorSupport x0) {
        return x0.obj;
    }

    private final class DataNodeListener
    extends NodeAdapter {
        CloneableEditor editor;

        DataNodeListener(CloneableEditor editor) {
            this.editor = editor;
        }

        public void propertyChange(PropertyChangeEvent ev) {
            Mutex.EVENT.writeAccess(new Runnable(this, ev){
                private final /* synthetic */ PropertyChangeEvent val$ev;
                private final /* synthetic */ DataNodeListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$ev = val$ev;
                }

                public void run() {
                    if ("displayName".equals(this.val$ev.getPropertyName())) {
                        DataNodeListener.access$400(this.this$1).updateTitles();
                    }
                    if ("icon".equals(this.val$ev.getPropertyName()) && DataEditorSupport.access$500(DataNodeListener.access$400(this.this$1)).isValid()) {
                        this.this$1.editor.setIcon(DataEditorSupport.access$500(DataNodeListener.access$400(this.this$1)).getNodeDelegate().getIcon(1));
                    }
                }
            });
        }

        static /* synthetic */ DataEditorSupport access$400(DataNodeListener x0) {
            return x0.DataEditorSupport.this;
        }
    }

    private static final class EnvListener
    extends FileChangeAdapter {
        private Reference env;

        public EnvListener(Env env) {
            this.env = new WeakReference<Env>(env);
        }

        public void fileDeleted(FileEvent fe) {
            Env env = (Env)this.env.get();
            FileObject fo = fe.getFile();
            if (env == null || env.getFileImpl() != fo) {
                fo.removeFileChangeListener((FileChangeListener)this);
                return;
            }
            fo.removeFileChangeListener((FileChangeListener)this);
            env.fileRemoved(false);
            fo.addFileChangeListener((FileChangeListener)this);
        }

        public void fileChanged(FileEvent fe) {
            Env env = (Env)this.env.get();
            if (env == null || env.getFileImpl() != fe.getFile()) {
                fe.getFile().removeFileChangeListener((FileChangeListener)this);
                return;
            }
            if (fe.getFile().isVirtual()) {
                fe.getFile().removeFileChangeListener((FileChangeListener)this);
                env.fileRemoved(true);
                fe.getFile().addFileChangeListener((FileChangeListener)this);
            } else {
                env.fileChanged(fe.isExpected(), fe.getTime());
            }
        }
    }

    public static abstract class Env
    extends OpenSupport.Env
    implements CloneableEditorSupport.Env,
    Serializable,
    PropertyChangeListener,
    VetoableChangeListener {
        static final long serialVersionUID = -2945098431098324441L;
        private transient FileObject fileObject;
        private transient FileLock fileLock;
        private transient boolean warned;

        public Env(DataObject obj) {
            super(obj);
        }

        private FileObject getFileImpl() {
            this.changeFile();
            return this.fileObject;
        }

        protected abstract FileObject getFile();

        protected abstract FileLock takeLock() throws IOException;

        protected final void changeFile() {
            boolean lockAgain;
            FileObject newFile = this.getFile();
            if (newFile.equals(this.fileObject)) {
                return;
            }
            if (this.fileLock != null) {
                if (this.fileLock.isValid()) {
                    this.fileLock.releaseLock();
                    lockAgain = true;
                } else {
                    this.fileLock = null;
                    lockAgain = false;
                }
            } else {
                lockAgain = false;
            }
            this.fileObject = newFile;
            this.fileObject.addFileChangeListener((FileChangeListener)new EnvListener(this));
            if (lockAgain) {
                try {
                    this.fileLock = this.takeLock();
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
        }

        public InputStream inputStream() throws IOException {
            FileObject fo = this.getFileImpl();
            if (!this.warned && fo.getSize() > 0x100000L) {
                class ME
                extends UserQuestionException {
                    private long size;
                    private final /* synthetic */ FileObject val$fo;
                    private final /* synthetic */ Env this$0;

                    public ME(Env this$0, long size, FileObject val$fo) {
                        this.this$0 = this$0;
                        this.val$fo = val$fo;
                        super("The file is too big. " + size + " bytes.");
                        this.size = size;
                    }

                    public String getLocalizedMessage() {
                        Object[] arr = new Object[]{this.val$fo.getPath(), this.val$fo.getNameExt(), new Long(this.size), new Long(this.size / 1024L + 1L), new Long(this.size / 0x100000L), new Long(this.size / 0x40000000L)};
                        return NbBundle.getMessage((Class)(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataEditorSupport.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject), (String)"MSG_ObjectIsTooBig", (Object[])arr);
                    }

                    public void confirmed() {
                        Env.access$102(this.this$0, true);
                    }
                }
                throw new ME(this, fo.getSize(), fo);
            }
            InputStream is = this.getFileImpl().getInputStream();
            return is;
        }

        public OutputStream outputStream() throws IOException {
            if (this.fileLock == null || !this.fileLock.isValid()) {
                this.fileLock = this.takeLock();
            }
            try {
                return this.getFileImpl().getOutputStream(this.fileLock);
            }
            catch (IOException fse) {
                if (this.fileLock == null || !this.fileLock.isValid()) {
                    this.fileLock = this.takeLock();
                }
                return this.getFileImpl().getOutputStream(this.fileLock);
            }
        }

        public Date getTime() {
            this.getFileImpl().refresh(false);
            return this.getFileImpl().lastModified();
        }

        public String getMimeType() {
            return this.getFileImpl().getMIMEType();
        }

        public void markModified() throws IOException {
            if (this.fileLock == null || !this.fileLock.isValid()) {
                this.fileLock = this.takeLock();
            }
            if (this.getFileImpl().isReadOnly()) {
                if (this.fileLock != null && this.fileLock.isValid()) {
                    this.fileLock.releaseLock();
                }
                throw new IOException("File " + this.getFileImpl().getNameExt() + " is read-only!");
            }
            this.getDataObject().setModified(true);
        }

        public void unmarkModified() {
            if (this.fileLock != null && this.fileLock.isValid()) {
                this.fileLock.releaseLock();
            }
            this.getDataObject().setModified(false);
        }

        final void fileChanged(boolean expected, long time) {
            if (expected) {
                this.firePropertyChange("time", null, null);
            } else {
                this.firePropertyChange("time", null, new Date(time));
            }
        }

        private void fileRemoved(boolean canBeVetoed) {
            if (canBeVetoed) {
                try {
                    this.fireVetoableChange("valid", Boolean.TRUE, Boolean.FALSE);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            this.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            CloneableOpenSupport.Env o;
            CloneableOpenSupport cos = super.findCloneableOpenSupport();
            if (cos instanceof DataEditorSupport && (o = ((DataEditorSupport)cos).env) != this && o instanceof Env) {
                ((Env)o).warned = this.warned;
            }
            return cos;
        }

        private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
            ois.defaultReadObject();
            this.warned = true;
        }

        static /* synthetic */ boolean access$102(Env x0, boolean x1) {
            x0.warned = x1;
            return x0.warned;
        }
    }
}

