/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.j2ee;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.j2ee.BeanMethodChecker;
import com.puppycrawl.tools.checkstyle.checks.j2ee.SessionBeanCheck;
import com.puppycrawl.tools.checkstyle.checks.j2ee.Utils;

public class SessionBeanMethodChecker
extends BeanMethodChecker {
    private boolean mHasEjbCreate;

    public SessionBeanMethodChecker(SessionBeanCheck aCheck) {
        super(aCheck);
    }

    public void checkMethods(DetailAST aAST) {
        this.mHasEjbCreate = false;
        super.checkMethods(aAST);
        if (!this.mHasEjbCreate) {
            DetailAST nameAST = aAST.findFirstToken(58);
            String name = nameAST.getText();
            String arg = "Session bean '" + name + "'";
            this.log(aAST, "missingmethod.bean", new Object[]{arg, "ejbCreate<METHOD>(...)"});
        }
    }

    protected void checkCreateMethod(DetailAST aMethodAST) {
        super.checkCreateMethod(aMethodAST);
        if (Utils.isPublic(aMethodAST) && !Utils.isStatic(aMethodAST) && !Utils.isFinal(aMethodAST) && Utils.isVoid(aMethodAST)) {
            this.mHasEjbCreate = true;
        }
        if (!Utils.isVoid(aMethodAST)) {
            this.log(aMethodAST, "nonvoidmethod.bean", new Object[0]);
        }
    }
}

