/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.checks.usage.AbstractUsageCheck;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ASTManager;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Definition;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Reference;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymTabAST;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class OneMethodPrivateFieldCheck
extends AbstractUsageCheck {
    public int[] getDefaultTokens() {
        return new int[]{10};
    }

    public String getErrorKey() {
        return "one.method.private.field";
    }

    public boolean mustCheckReferenceCount(DetailAST aAST) {
        DetailAST mods = aAST.findFirstToken(5);
        return mods != null && ScopeUtils.getScopeFromMods((DetailAST)mods) == Scope.PRIVATE;
    }

    public void applyTo(Set aNodes) {
        HashSet<DetailAST> methods = new HashSet<DetailAST>();
        Iterator it = aNodes.iterator();
        while (it.hasNext()) {
            methods.clear();
            DetailAST nameAST = (DetailAST)it.next();
            Iterator refIt = this.getReferences(nameAST);
            block1: while (refIt.hasNext()) {
                Reference ref = (Reference)refIt.next();
                SymTabAST refNode = ref.getTreeNode();
                DetailAST refDetail = refNode.getDetailNode();
                if (refDetail == nameAST) continue;
                for (DetailAST parent = refDetail.getParent(); parent != null; parent = parent.getParent()) {
                    int type = parent.getType();
                    if (type == 9 || type == 8 || type == 11 || type == 12) {
                        methods.add(parent);
                        continue block1;
                    }
                    if (type == 14) continue block1;
                }
            }
            if (methods.size() != 1) continue;
            this.log(nameAST.getLineNo(), nameAST.getColumnNo(), this.getErrorKey(), nameAST.getText());
        }
    }

    private Iterator getReferences(DetailAST aAST) {
        SymTabAST ident = ASTManager.getInstance().get((AST)aAST);
        Definition definition = (Definition)ident.getDefinition();
        if (definition != null) {
            return definition.getReferences();
        }
        HashSet dummy = new HashSet();
        return dummy.iterator();
    }
}

