/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.usage.AbstractUsageCheck;

public class UnusedParameterCheck
extends AbstractUsageCheck {
    private boolean mIgnoreCatch = true;
    private boolean mIgnoreNonLocal;

    public int[] getDefaultTokens() {
        return new int[]{21};
    }

    public String getErrorKey() {
        return "unused.parameter";
    }

    public boolean mustCheckReferenceCount(DetailAST aAST) {
        boolean result = false;
        DetailAST parent = aAST.getParent();
        if (parent != null) {
            if (parent.getType() == 20) {
                DetailAST grandparent = parent.getParent();
                if (grandparent != null) {
                    result = this.hasBody(grandparent) && (!this.mIgnoreNonLocal || this.isLocal(grandparent));
                }
            } else if (parent.getType() == 96) {
                result = !this.mIgnoreCatch;
            }
        }
        return result;
    }

    private boolean hasBody(DetailAST aAST) {
        if (aAST.getType() == 9) {
            return aAST.branchContains(7);
        }
        return aAST.getType() == 8;
    }

    private boolean isLocal(DetailAST aAST) {
        if (aAST.getType() == 9) {
            DetailAST modifiers = aAST.findFirstToken(5);
            return modifiers == null || modifiers.branchContains(64) || modifiers.branchContains(61);
        }
        return true;
    }

    public void setIgnoreCatch(boolean aIgnoreCatch) {
        this.mIgnoreCatch = aIgnoreCatch;
    }

    public void setIgnoreNonLocal(boolean aIgnoreNonLocal) {
        this.mIgnoreNonLocal = aIgnoreNonLocal;
    }
}

