/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage.transmogrify;

import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ASTUtil;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.BaseScope;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ClassDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IDefinition;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IPackage;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Occurrence;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Reference;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.Scope;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymTabAST;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class Definition
implements IDefinition,
Comparable {
    private String _name = null;
    private Scope _parentScope = null;
    private SymTabAST _node = null;
    private SortedSet _references;
    private Occurrence _occurrence = null;

    public Definition(String name, Scope parentScope, SymTabAST node) {
        this._name = name;
        this._parentScope = parentScope;
        this._node = node;
        this._references = new TreeSet();
        if (node != null) {
            this._occurrence = new Occurrence(this._node.getFile(), ASTUtil.getLine(this._node), ASTUtil.getColumn(this._node));
        }
    }

    public boolean isSourced() {
        return true;
    }

    public String getName() {
        return this._name;
    }

    public SymTabAST getTreeNode() {
        return this._node;
    }

    public void addReference(Reference reference) {
        this._references.add(reference);
    }

    public Iterator getReferences() {
        return this._references.iterator();
    }

    public int getNumReferences() {
        return this._references.size();
    }

    public Scope getParentScope() {
        return this._parentScope;
    }

    public String getQualifiedName() {
        String nameToUse = this._name;
        if (this._name == null) {
            nameToUse = "~NO NAME~";
        }
        String result = this.getParentScope() != null && !(this.getParentScope() instanceof BaseScope) ? this.getParentScope().getQualifiedName() + "." + nameToUse : nameToUse;
        return result;
    }

    public Occurrence getOccurrence() {
        return this._occurrence;
    }

    public ClassDef getEnclosingClass() {
        ClassDef result = null;
        if (this.getParentScope() != null) {
            result = this.getParentScope().getEnclosingClass();
        }
        return result;
    }

    public IPackage getEnclosingPackage() {
        IPackage result = null;
        if (this.getParentScope() != null) {
            result = this.getParentScope().getEnclosingPackage();
        }
        return result;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getQualifiedName() + "]";
    }

    public int compareTo(Object o) {
        int result = 0;
        if (!(o instanceof Definition)) {
            throw new ClassCastException(o.getClass().getName());
        }
        result = this.getQualifiedName().compareTo(((Definition)o).getQualifiedName());
        return result;
    }
}

