/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage.transmogrify;

import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ExternalClass;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IClass;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymTabAST;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymTabASTFactory;
import java.util.HashMap;
import java.util.Map;

public class LiteralResolver {
    private static Map intMap;
    private static Map nameMap;
    private static Map classMap;

    public static LiteralResolver getResolver() {
        return new LiteralResolver();
    }

    public static IClass getDefinition(int literalType) {
        Integer key = new Integer(literalType);
        return (IClass)intMap.get(key);
    }

    public static IClass getDefinition(String name) {
        return (IClass)nameMap.get(name);
    }

    public static SymTabAST getASTNode(IClass primitive) {
        return (SymTabAST)((Object)classMap.get(primitive));
    }

    static {
        nameMap = new HashMap();
        nameMap.put("boolean", new ExternalClass(Boolean.TYPE));
        nameMap.put("byte", new ExternalClass(Byte.TYPE));
        nameMap.put("char", new ExternalClass(Character.TYPE));
        nameMap.put("short", new ExternalClass(Short.TYPE));
        nameMap.put("int", new ExternalClass(Integer.TYPE));
        nameMap.put("float", new ExternalClass(Float.TYPE));
        nameMap.put("long", new ExternalClass(Long.TYPE));
        nameMap.put("double", new ExternalClass(Double.TYPE));
        intMap = new HashMap();
        intMap.put(new Integer(50), new ExternalClass(Boolean.TYPE));
        intMap.put(new Integer(51), new ExternalClass(Byte.TYPE));
        intMap.put(new Integer(52), new ExternalClass(Character.TYPE));
        intMap.put(new Integer(53), new ExternalClass(Short.TYPE));
        intMap.put(new Integer(54), new ExternalClass(Integer.TYPE));
        intMap.put(new Integer(55), new ExternalClass(Float.TYPE));
        intMap.put(new Integer(56), new ExternalClass(Long.TYPE));
        intMap.put(new Integer(57), new ExternalClass(Double.TYPE));
        intMap.put(new Integer(139), new ExternalClass("".getClass()));
        classMap = new HashMap();
        classMap.put(new ExternalClass(Boolean.TYPE), SymTabASTFactory.create(50, "boolean"));
        classMap.put(new ExternalClass(Byte.TYPE), SymTabASTFactory.create(51, "byte"));
        classMap.put(new ExternalClass(Character.TYPE), SymTabASTFactory.create(52, "char"));
        classMap.put(new ExternalClass(Short.TYPE), SymTabASTFactory.create(53, "short"));
        classMap.put(new ExternalClass(Integer.TYPE), SymTabASTFactory.create(54, "int"));
        classMap.put(new ExternalClass(Float.TYPE), SymTabASTFactory.create(55, "float"));
        classMap.put(new ExternalClass(Long.TYPE), SymTabASTFactory.create(56, "long"));
        classMap.put(new ExternalClass(Double.TYPE), SymTabASTFactory.create(57, "double"));
    }
}

