/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage.transmogrify;

import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.SymTabAST;
import java.io.File;

public class Occurrence
implements Comparable {
    private File _file;
    private int _line;
    private int _column;

    public Occurrence(File file, int line, int column) {
        this._file = file;
        this._line = line;
        this._column = column;
    }

    public Occurrence(SymTabAST node) {
        this._file = node.getFile();
        this._line = node.getLineNo();
        this._column = node.getColumnNo();
    }

    public File getFile() {
        return this._file;
    }

    public int getLine() {
        return this._line;
    }

    public int getColumn() {
        return this._column;
    }

    public int compareTo(Object o) {
        if (!(o instanceof Occurrence)) {
            throw new ClassCastException(this.getClass().getName());
        }
        Occurrence other = (Occurrence)o;
        int result = 0;
        result = this.getFile().compareTo(other.getFile());
        if (result == 0) {
            result = this.getLine() - other.getLine();
        }
        if (result == 0) {
            result = this.getColumn() - other.getColumn();
        }
        return result;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof Occurrence) {
            Occurrence occ = (Occurrence)o;
            result = this.getFile().equals(occ.getFile()) && this.getLine() == occ.getLine() && this.getColumn() == occ.getColumn();
        }
        return result;
    }

    public int hashCode() {
        return this.getFile().hashCode();
    }

    public String toString() {
        return "[" + this.getFile() + ":" + this.getLine() + "," + this.getColumn() + "]";
    }
}

